/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.service.base.PortletServiceBaseImpl;
import java.util.List;

@JSONWebService(mode=JSONWebServiceMode.MANUAL)
public class PortletServiceImpl
extends PortletServiceBaseImpl {
    @BeanReference(type=RoleLocalService.class)
    private RoleLocalService _roleLocalService;

    public JSONArray getWARPortlets() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List portlets = this.portletLocalService.getPortlets();
        for (Portlet portlet : portlets) {
            PortletApp portletApp = portlet.getPortletApp();
            if (!portletApp.isWARFile()) continue;
            jsonArray.put(JSONUtil.put((String)"portlet_name", (Object)portlet.getPortletName()).put("servlet_context_name", portletApp.getServletContextName()));
        }
        return jsonArray;
    }

    @JSONWebService
    public boolean hasPortlet(long companyId, String portletId) {
        return this.portletLocalService.hasPortlet(companyId, portletId);
    }

    public Portlet updatePortlet(long companyId, String portletId, String roles, boolean active) throws PortalException {
        if (!this._roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        return this.portletLocalService.updatePortlet(companyId, portletId, roles, active);
    }
}

