/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.CommonPermission;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.util.PortalUtil;

public class CommonPermissionImpl
implements CommonPermission {
    private static final Log _log = LogFactoryUtil.getLog(CommonPermissionImpl.class);

    public void check(PermissionChecker permissionChecker, long classNameId, long classPK, String actionId) throws PortalException {
        this.check(permissionChecker, PortalUtil.getClassName((long)classNameId), classPK, actionId);
    }

    public void check(PermissionChecker permissionChecker, String className, long classPK, String actionId) throws PortalException {
        if (className.equals(Company.class.getName())) {
            long companyId = permissionChecker.getCompanyId();
            if (classPK > 0L) {
                companyId = classPK;
            }
            if (!RoleLocalServiceUtil.hasUserRole((long)permissionChecker.getUserId(), (long)companyId, (String)"Administrator", (boolean)true)) {
                throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
            }
        } else if (className.equals(Contact.class.getName())) {
            User user = UserLocalServiceUtil.getUserByContactId((long)classPK);
            UserPermissionUtil.check((PermissionChecker)permissionChecker, (long)user.getUserId(), (String)actionId);
        } else if (className.equals(Organization.class.getName())) {
            OrganizationPermissionUtil.check((PermissionChecker)permissionChecker, (long)classPK, (String)actionId);
        } else if (className.equals(User.class.getName())) {
            UserPermissionUtil.check((PermissionChecker)permissionChecker, (long)classPK, (String)actionId);
        } else {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Invalid class name " + className));
            }
            throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, new String[]{actionId});
        }
    }
}

