/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.servlet.SharedSessionWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class SharedSessionServletRequest
extends HttpServletRequestWrapper {
    private static final Log _log = LogFactoryUtil.getLog(SharedSessionServletRequest.class);
    private HttpSession _portalHttpSession;
    private final boolean _shared;

    public SharedSessionServletRequest(HttpServletRequest httpServletRequest, boolean shared) {
        super(httpServletRequest);
        this._shared = shared;
        this._portalHttpSession = httpServletRequest.getSession();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (create) {
            this.checkPortalSession();
        }
        if (this._shared) {
            return this._portalHttpSession;
        }
        HttpSession portletHttpSession = super.getSession(create);
        if (portletHttpSession != null && portletHttpSession != this._portalHttpSession) {
            return this.getSharedSessionWrapper(this._portalHttpSession, portletHttpSession);
        }
        return portletHttpSession;
    }

    public HttpSession getSharedSession() {
        return this._portalHttpSession;
    }

    protected void checkPortalSession() {
        try {
            this._portalHttpSession.isNew();
        }
        catch (IllegalStateException illegalStateException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)illegalStateException);
            }
            this._portalHttpSession = super.getSession(true);
        }
    }

    protected HttpSession getSharedSessionWrapper(HttpSession portalHttpSession, HttpSession portletHttpSession) {
        return new SharedSessionWrapper(portalHttpSession, portletHttpSession);
    }
}

