/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionAttributeBuilder;
import com.liferay.portal.spring.transaction.TransactionHandler;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class TransactionInterceptor
extends ChainableMethodAdvice {
    private final TransactionHandler _transactionHandler;

    public TransactionInterceptor(TransactionHandler transactionHandler) {
        this._transactionHandler = transactionHandler;
    }

    public TransactionAttributeAdapter createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        Transactional transactional = (Transactional)annotations.get(Transactional.class);
        TransactionAttribute transactionAttribute = TransactionAttributeBuilder.build(transactional);
        if (transactionAttribute == null) {
            return null;
        }
        return new TransactionAttributeAdapter(transactionAttribute);
    }

    public Object invoke(AopMethodInvocation aopMethodInvocation, Object[] arguments) throws Throwable {
        TransactionAttributeAdapter transactionAttributeAdapter = (TransactionAttributeAdapter)aopMethodInvocation.getAdviceMethodContext();
        TransactionStatusAdapter transactionStatusAdapter = this._transactionHandler.start(transactionAttributeAdapter);
        Object returnValue = null;
        try {
            returnValue = aopMethodInvocation.proceed(arguments);
        }
        catch (Throwable throwable) {
            this._transactionHandler.rollback(throwable, transactionAttributeAdapter, transactionStatusAdapter);
        }
        this._transactionHandler.commit(transactionAttributeAdapter, transactionStatusAdapter);
        return returnValue;
    }
}

