/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sites.kernel.util.SitesUtil;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class FindStrutsAction
implements StrutsAction {
    private static final Log _log = LogFactoryUtil.getLog(FindStrutsAction.class);

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            long groupId;
            long primaryKey;
            block12: {
                primaryKey = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)this.getPrimaryKeyParameterName());
                groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId", (long)themeDisplay.getScopeGroupId());
                if (primaryKey > 0L) {
                    try {
                        long overrideGroupId = this.getGroupId(primaryKey);
                        if (overrideGroupId > 0L) {
                            groupId = overrideGroupId;
                        }
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block12;
                        _log.debug((Throwable)exception);
                    }
                }
            }
            PortletLayoutFinder portletLayoutFinder = this.getPortletLayoutFinder();
            PortletLayoutFinder.Result result = portletLayoutFinder.find(themeDisplay, groupId);
            Layout layout = FindStrutsAction._setTargetLayout(httpServletRequest, groupId, result.getPlid());
            if (!LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (boolean)true, (String)"VIEW")) {
                if (!themeDisplay.isSignedIn() && result.isSignInRequired()) {
                    String redirect = HttpComponentsUtil.addParameter((String)(PortalUtil.getPathMain() + "/portal/login"), (String)"redirect", (String)PortalUtil.getCurrentCompleteURL((HttpServletRequest)httpServletRequest));
                    httpServletResponse.sendRedirect(redirect);
                    return null;
                }
                throw new PrincipalException.MustHavePermission(themeDisplay.getPermissionChecker(), Layout.class.getName(), layout.getLayoutId(), new String[]{"VIEW"});
            }
            String portletId = result.getPortletId();
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)portletId, (Layout)layout, (String)"RENDER_PHASE");
            this.addRequiredParameters(httpServletRequest, portletId, (PortletURL)portletURL);
            boolean inheritRedirect = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"inheritRedirect");
            String redirect = null;
            if (inheritRedirect) {
                String noSuchEntryRedirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"noSuchEntryRedirect");
                redirect = HttpComponentsUtil.getParameter((String)noSuchEntryRedirect, (String)"redirect", (boolean)false);
                redirect = HttpComponentsUtil.decodeURL((String)redirect);
            } else {
                redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect");
            }
            if (Validator.isNotNull((String)redirect)) {
                portletURL.setParameter("redirect", redirect);
            }
            this.setPrimaryKeyParameter((PortletURL)portletURL, primaryKey);
            portletURL.setPortletMode(PortletMode.VIEW);
            portletURL.setWindowState(WindowState.NORMAL);
            portletURL = this.processPortletURL(httpServletRequest, (PortletURL)portletURL);
            httpServletResponse.sendRedirect(portletURL.toString());
        }
        catch (Exception exception) {
            String noSuchEntryRedirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"noSuchEntryRedirect");
            noSuchEntryRedirect = PortalUtil.escapeRedirect((String)noSuchEntryRedirect);
            if (Validator.isNotNull((String)noSuchEntryRedirect) && (exception instanceof NoSuchLayoutException || exception instanceof PrincipalException)) {
                httpServletResponse.sendRedirect(noSuchEntryRedirect);
            }
            PortalUtil.sendError((Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
        return null;
    }

    protected abstract void addRequiredParameters(HttpServletRequest var1, String var2, PortletURL var3);

    protected abstract long getGroupId(long var1) throws Exception;

    protected abstract PortletLayoutFinder getPortletLayoutFinder();

    protected abstract String getPrimaryKeyParameterName();

    protected PortletURL processPortletURL(HttpServletRequest httpServletRequest, PortletURL portletURL) throws Exception {
        return portletURL;
    }

    protected void setPrimaryKeyParameter(PortletURL portletURL, long primaryKey) throws Exception {
        portletURL.setParameter(this.getPrimaryKeyParameterName(), String.valueOf(primaryKey));
    }

    private static Layout _setTargetLayout(HttpServletRequest httpServletRequest, long groupId, long plid) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        if (groupId == layout.getGroupId() || group.getParentGroupId() == layout.getGroupId() || layout.isPrivateLayout() && !SitesUtil.isUserGroupLayoutSetViewable((PermissionChecker)themeDisplay.getPermissionChecker(), (Group)layout.getGroup())) {
            return layout;
        }
        layout = new VirtualLayout(layout, group);
        httpServletRequest.setAttribute("LAYOUT", (Object)layout);
        return layout;
    }
}

