/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.ToolsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurationEnvBuilder {
    private static final Pattern _pattern = Pattern.compile("\\s*public .* ([^\\s]+)\\(\\);");

    public static String buildContent(String[] configurationJavaFileNames) throws IOException {
        StringBundler sb = new StringBundler();
        sb.append("##\n## OSGi Configuration Overrides\n##\n");
        Matcher matcher = _pattern.matcher("");
        for (String configurationJavaFileName : configurationJavaFileNames) {
            if (configurationJavaFileName.contains("/build/compile-include-sources/")) continue;
            Path path = Paths.get(configurationJavaFileName, new String[0]);
            String fullyQualifiedName = configurationJavaFileName.substring(configurationJavaFileName.indexOf(StringBundler.concat((String[])new String[]{"com", File.separator, "liferay"})), configurationJavaFileName.indexOf(".java"));
            fullyQualifiedName = StringUtil.replace((String)fullyQualifiedName, (String)File.separator, (String)".");
            List<String> lines = Files.readAllLines(path);
            for (String line : lines) {
                if (line.contains("public class")) break;
                matcher.reset(line);
                if (!matcher.matches()) continue;
                String configurationKey = StringBundler.concat((String[])new String[]{"configuration.override.", fullyQualifiedName, "_", matcher.group(1)});
                sb.append("\n");
                sb.append("    #\n");
                sb.append("    # Env: ");
                sb.append(ToolsUtil.encodeEnvironmentProperty(configurationKey));
                sb.append("\n");
                sb.append("    #\n");
                sb.append("    #");
                sb.append(configurationKey);
                sb.append("=");
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String[] configurationJavaFileNames = StringUtil.split((String)arguments.get("configuration.java.files"));
        Path path = Paths.get(arguments.get("output.file"), new String[0]);
        String content = new String(Files.readAllBytes(path));
        int index = content.indexOf("##\n## OSGi Configuration Overrides");
        content = content.substring(0, index);
        content = content.concat(ConfigurationEnvBuilder.buildContent(configurationJavaFileNames));
        Files.write(path, content.getBytes(), new OpenOption[0]);
    }
}

