/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_1;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.util.RawMetadataProcessor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected long addRawMetadataProcessorClassName() throws Exception {
        long classNameId = PortalUtil.getClassNameId(RawMetadataProcessor.class);
        if (classNameId != 0L) {
            return classNameId;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("insert into ClassName_ (mvccVersion, classNameId, value) values (?, ?, ?)");){
            classNameId = this.increment();
            preparedStatement.setLong(1, 0L);
            preparedStatement.setLong(2, classNameId);
            preparedStatement.setString(3, RawMetadataProcessor.class.getName());
            preparedStatement.executeUpdate();
        }
        return classNameId;
    }

    protected void doUpgrade() throws Exception {
        this.updateTikaRawMetadataDDMStructure();
        this.updateTikaRawMetadataFileEntryMetadata();
    }

    /*
     * Exception decompiling
     */
    protected long getDDMStructureId(String structureKey, long classNameId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateTikaRawMetadataDDMStructure() throws Exception {
        long classNameId = this.addRawMetadataProcessorClassName();
        long ddmStructureId = this.getDDMStructureId("TIKARAWMETADATA", classNameId);
        if (ddmStructureId != 0L) {
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update DDMStructure set classNameId = ? where structureKey = ?");){
            preparedStatement.setLong(1, classNameId);
            preparedStatement.setString(2, "TIKARAWMETADATA");
            preparedStatement.execute();
        }
    }

    protected void updateTikaRawMetadataFileEntryMetadata() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long oldDDMStructureId = this.getDDMStructureId("TIKARAWMETADATA", PortalUtil.getClassNameId(DLFileEntry.class));
            if (oldDDMStructureId == 0L) {
                return;
            }
            long newDDMStructureId = this.getDDMStructureId("TIKARAWMETADATA", PortalUtil.getClassNameId(RawMetadataProcessor.class));
            if (newDDMStructureId == 0L) {
                return;
            }
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select fileVersionId, DDMStructureId from ", "DLFileEntryMetadata where fileVersionId in ", "(select fileVersionId from DLFileEntryMetadata ", "group by fileVersionId having count(*) >= 2) and ", "DDMStructureId = ?"}));
                 PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"delete from DLFileEntryMetadata where fileVersionId = ? and DDMStructureId = ?");){
                preparedStatement1.setLong(1, oldDDMStructureId);
                ResultSet resultSet = preparedStatement1.executeQuery();
                while (resultSet.next()) {
                    long fileVersionId = resultSet.getLong("fileVersionId");
                    long ddmStructureId = resultSet.getLong("DDMStructureId");
                    preparedStatement2.setLong(1, fileVersionId);
                    preparedStatement2.setLong(2, ddmStructureId);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
            var8_10 = null;
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("update DLFileEntryMetadata set DDMStructureId = ? where DDMStructureId = ?");){
                preparedStatement.setLong(1, newDDMStructureId);
                preparedStatement.setLong(2, oldDDMStructureId);
                preparedStatement.execute();
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
        }
    }
}

