/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_4_x;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeVirtualHost
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeVirtualHost.class);

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select virtualHostId, hostname from VirtualHost where hostname != LOWER(hostname)");
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("update VirtualHost set hostname = ? where virtualHostId = ?");){
            ResultSet resultSet = preparedStatement1.executeQuery();
            while (resultSet.next()) {
                String hostname = resultSet.getString("hostname");
                preparedStatement2.setString(1, StringUtil.toLowerCase((String)hostname));
                long virtualHostId = resultSet.getLong("virtualHostId");
                preparedStatement2.setLong(2, virtualHostId);
                try {
                    preparedStatement2.executeUpdate();
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Deleting duplicate virtual host ", virtualHostId, " with hostname ", hostname}), (Throwable)exception);
                    }
                    this.runSQL("delete from VirtualHost where virtualHostId = " + virtualHostId);
                }
            }
        }
    }
}

