/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.PortalPreferencesLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.portlet.PortletPreferences;

public class PrefsPropsImpl
implements PrefsProps {
    private static final Log _log = LogFactoryUtil.getLog(PrefsPropsImpl.class);
    @BeanReference(type=PortalPreferencesLocalService.class)
    private PortalPreferencesLocalService _portalPreferencesLocalService;

    public boolean getBoolean(long companyId, String name) {
        return this.getBoolean(this.getPreferences(companyId), name);
    }

    public boolean getBoolean(long companyId, String name, boolean defaultValue) {
        return this.getBoolean(this.getPreferences(companyId), name, defaultValue);
    }

    public boolean getBoolean(PortletPreferences preferences, String name) {
        return GetterUtil.getBoolean((String)this.getString(preferences, name));
    }

    public boolean getBoolean(PortletPreferences preferences, String name, boolean defaultValue) {
        return GetterUtil.getBoolean((String)this.getString(preferences, name, defaultValue));
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(this.getPreferences(), name);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.getBoolean(this.getPreferences(), name, defaultValue);
    }

    public String getContent(long companyId, String name) {
        return this.getContent(this.getPreferences(companyId), name);
    }

    public String getContent(PortletPreferences preferences, String name) {
        String value = preferences.getValue(name, "");
        if (Validator.isNotNull((String)value)) {
            return value;
        }
        try {
            return StringUtil.read((ClassLoader)PrefsPropsImpl.class.getClassLoader(), (String)PropsUtil.get(name));
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to read the content for " + PropsUtil.get(name)), (Throwable)ioException);
            return null;
        }
    }

    public String getContent(String name) {
        return this.getContent(this.getPreferences(), name);
    }

    public double getDouble(long companyId, String name) {
        return this.getDouble(this.getPreferences(companyId), name);
    }

    public double getDouble(long companyId, String name, double defaultValue) {
        return this.getDouble(this.getPreferences(companyId), name, defaultValue);
    }

    public double getDouble(PortletPreferences preferences, String name) {
        return GetterUtil.getDouble((String)this.getString(preferences, name));
    }

    public double getDouble(PortletPreferences preferences, String name, double defaultValue) {
        return GetterUtil.getDouble((String)this.getString(preferences, name, defaultValue));
    }

    public double getDouble(String name) {
        return this.getDouble(this.getPreferences(), name);
    }

    public double getDouble(String name, double defaultValue) {
        return this.getDouble(this.getPreferences(), name, defaultValue);
    }

    public int getInteger(long companyId, String name) {
        return this.getInteger(this.getPreferences(companyId), name);
    }

    public int getInteger(long companyId, String name, int defaultValue) {
        return this.getInteger(this.getPreferences(companyId), name, defaultValue);
    }

    public int getInteger(PortletPreferences preferences, String name) {
        return GetterUtil.getInteger((String)this.getString(preferences, name));
    }

    public int getInteger(PortletPreferences preferences, String name, int defaultValue) {
        return GetterUtil.getInteger((String)this.getString(preferences, name, defaultValue));
    }

    public int getInteger(String name) {
        return this.getInteger(this.getPreferences(), name);
    }

    public int getInteger(String name, int defaultValue) {
        return this.getInteger(this.getPreferences(), name, defaultValue);
    }

    public long getLong(long companyId, String name) {
        return this.getLong(this.getPreferences(companyId), name);
    }

    public long getLong(long companyId, String name, long defaultValue) {
        return this.getLong(this.getPreferences(companyId), name, defaultValue);
    }

    public long getLong(PortletPreferences preferences, String name) {
        return GetterUtil.getLong((String)this.getString(preferences, name));
    }

    public long getLong(PortletPreferences preferences, String name, long defaultValue) {
        return GetterUtil.getLong((String)this.getString(preferences, name, defaultValue));
    }

    public long getLong(String name) {
        return this.getLong(this.getPreferences(), name);
    }

    public long getLong(String name, long defaultValue) {
        return this.getLong(this.getPreferences(), name, defaultValue);
    }

    public PortletPreferences getPreferences() {
        return this._portalPreferencesLocalService.getPreferences(0L, 1);
    }

    public PortletPreferences getPreferences(long companyId) {
        return this._portalPreferencesLocalService.getPreferences(companyId, 1);
    }

    public Properties getProperties(PortletPreferences preferences, String prefix, boolean removePrefix) {
        Properties newProperties = new Properties();
        Enumeration enumeration = preferences.getNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(prefix)) continue;
            String value = preferences.getValue(key, "");
            if (removePrefix) {
                key = key.substring(prefix.length());
            }
            newProperties.setProperty(key, value);
        }
        return newProperties;
    }

    public Properties getProperties(String prefix, boolean removePrefix) {
        return this.getProperties(this.getPreferences(), prefix, removePrefix);
    }

    public short getShort(long companyId, String name) {
        return this.getShort(this.getPreferences(companyId), name);
    }

    public short getShort(long companyId, String name, short defaultValue) {
        return this.getShort(this.getPreferences(companyId), name, defaultValue);
    }

    public short getShort(PortletPreferences preferences, String name) {
        return GetterUtil.getShort((String)this.getString(preferences, name));
    }

    public short getShort(PortletPreferences preferences, String name, short defaultValue) {
        return GetterUtil.getShort((String)this.getString(preferences, name, defaultValue));
    }

    public short getShort(String name) {
        return this.getShort(this.getPreferences(), name);
    }

    public short getShort(String name, short defaultValue) {
        return this.getShort(this.getPreferences(), name, defaultValue);
    }

    public String getString(long companyId, String name) {
        return this.getString(this.getPreferences(companyId), name);
    }

    public String getString(long companyId, String name, String defaultValue) {
        return this.getString(this.getPreferences(companyId), name, defaultValue);
    }

    public String getString(PortletPreferences preferences, String name) {
        String value = PropsUtil.get(name);
        return preferences.getValue(name, value);
    }

    public String getString(PortletPreferences preferences, String name, boolean defaultValue) {
        String value = this.getString(preferences, name);
        if (value != null) {
            return value;
        }
        return String.valueOf(defaultValue);
    }

    public String getString(PortletPreferences preferences, String name, double defaultValue) {
        String value = this.getString(preferences, name);
        if (value != null) {
            return value;
        }
        return String.valueOf(defaultValue);
    }

    public String getString(PortletPreferences preferences, String name, int defaultValue) {
        String value = this.getString(preferences, name);
        if (value != null) {
            return value;
        }
        return String.valueOf(defaultValue);
    }

    public String getString(PortletPreferences preferences, String name, long defaultValue) {
        String value = this.getString(preferences, name);
        if (value != null) {
            return value;
        }
        return String.valueOf(defaultValue);
    }

    public String getString(PortletPreferences preferences, String name, short defaultValue) {
        String value = this.getString(preferences, name);
        if (value != null) {
            return value;
        }
        return String.valueOf(defaultValue);
    }

    public String getString(PortletPreferences preferences, String name, String defaultValue) {
        String value = this.getString(preferences, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getString(String name) {
        return this.getString(this.getPreferences(), name);
    }

    public String getString(String name, String defaultValue) {
        return this.getString(this.getPreferences(), name, defaultValue);
    }

    public String[] getStringArray(long companyId, String name, String delimiter) {
        return this.getStringArray(this.getPreferences(companyId), name, delimiter);
    }

    public String[] getStringArray(long companyId, String name, String delimiter, String[] defaultValue) {
        return this.getStringArray(this.getPreferences(companyId), name, delimiter, defaultValue);
    }

    public String[] getStringArray(PortletPreferences preferences, String name, String delimiter) {
        String value = PropsUtil.get(name);
        return StringUtil.split((String)preferences.getValue(name, value), (String)delimiter);
    }

    public String[] getStringArray(PortletPreferences preferences, String name, String delimiter, String[] defaultValue) {
        String value = preferences.getValue(name, null);
        if (value == null) {
            return defaultValue;
        }
        return StringUtil.split((String)value, (String)delimiter);
    }

    public String[] getStringArray(String name, String delimiter) {
        return this.getStringArray(this.getPreferences(), name, delimiter);
    }

    public String[] getStringArray(String name, String delimiter, String[] defaultValue) {
        return this.getStringArray(this.getPreferences(), name, delimiter, defaultValue);
    }

    public String getStringFromNames(long companyId, String ... names) {
        for (String name : names) {
            String value = this.getString(companyId, name);
            if (!Validator.isNotNull((String)value)) continue;
            return value;
        }
        return null;
    }
}

