/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.configuration.ConfigurationFactoryImpl;
import com.liferay.portal.configuration.ConfigurationImpl;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropsUtil {
    private static final Log _log = LogFactoryUtil.getLog(PropsUtil.class);
    private static final Configuration _configuration;
    private static final Map<Long, Configuration> _configurations;

    public static void addProperties(Company company, Properties properties) {
        Configuration configuration = PropsUtil._getConfiguration(company);
        configuration.addProperties(properties);
    }

    public static void addProperties(Company company, UnicodeProperties unicodeProperties) {
        Configuration configuration = PropsUtil._getConfiguration(company);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)unicodeProperties);
        configuration.addProperties(properties);
    }

    public static void addProperties(Properties properties) {
        Configuration configuration = PropsUtil._getConfiguration();
        configuration.addProperties(properties);
    }

    public static void addProperties(UnicodeProperties unicodeProperties) {
        Configuration configuration = PropsUtil._getConfiguration();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)unicodeProperties);
        configuration.addProperties(properties);
    }

    public static boolean contains(Company company, String key) {
        Configuration configuration = PropsUtil._getConfiguration(company);
        return configuration.contains(key);
    }

    public static boolean contains(String key) {
        Configuration configuration = PropsUtil._getConfiguration();
        return configuration.contains(key);
    }

    public static String get(Company company, String key) {
        Configuration configuration = PropsUtil._getConfiguration(company);
        return configuration.get(key);
    }

    public static String get(Company company, String key, Filter filter) {
        Configuration configuration = PropsUtil._getConfiguration(company);
        return configuration.get(key, filter);
    }

    public static String get(String key) {
        Configuration configuration = PropsUtil._getConfiguration();
        return configuration.get(key);
    }

    public static String get(String key, Filter filter) {
        Configuration configuration = PropsUtil._getConfiguration();
        return configuration.get(key, filter);
    }

    public static String[] getArray(Company company, String key) {
        Configuration configuration = PropsUtil._getConfiguration(company);
        return configuration.getArray(key);
    }

    public static String[] getArray(Company company, String key, Filter filter) {
        Configuration configuration = PropsUtil._getConfiguration(company);
        return configuration.getArray(key, filter);
    }

    public static String[] getArray(String key) {
        Configuration configuration = PropsUtil._getConfiguration();
        return configuration.getArray(key);
    }

    public static String[] getArray(String key, Filter filter) {
        Configuration configuration = PropsUtil._getConfiguration();
        return configuration.getArray(key, filter);
    }

    public static Properties getProperties() {
        return PropsUtil.getProperties(false);
    }

    public static Properties getProperties(boolean includeSystem) {
        Configuration configuration = PropsUtil._getConfiguration();
        Properties properties = configuration.getProperties();
        if (!includeSystem) {
            return properties;
        }
        Properties systemCompanyProperties = _configuration.getProperties();
        Properties mergedProperties = (Properties)systemCompanyProperties.clone();
        mergedProperties.putAll((Map<?, ?>)properties);
        return mergedProperties;
    }

    public static Properties getProperties(Company company) {
        return PropsUtil.getProperties(company, false);
    }

    public static Properties getProperties(Company company, boolean includeSystem) {
        Configuration configuration = PropsUtil._getConfiguration(company);
        Properties properties = configuration.getProperties();
        if (!includeSystem) {
            return properties;
        }
        Properties systemCompanyProperties = _configuration.getProperties();
        Properties mergedProperties = (Properties)systemCompanyProperties.clone();
        mergedProperties.putAll((Map<?, ?>)properties);
        return mergedProperties;
    }

    public static Properties getProperties(Company company, String prefix, boolean removePrefix) {
        Configuration configuration = PropsUtil._getConfiguration(company);
        return configuration.getProperties(prefix, removePrefix);
    }

    public static Properties getProperties(String prefix, boolean removePrefix) {
        Configuration configuration = PropsUtil._getConfiguration();
        return configuration.getProperties(prefix, removePrefix);
    }

    public static void removeProperties(Company company, Properties properties) {
        Configuration configuration = PropsUtil._getConfiguration(company);
        configuration.removeProperties(properties);
    }

    public static void removeProperties(Properties properties) {
        Configuration configuration = PropsUtil._getConfiguration();
        configuration.removeProperties(properties);
    }

    public static void set(Company company, String key, String value) {
        Configuration configuration = PropsUtil._getConfiguration(company);
        configuration.set(key, value);
    }

    public static void set(String key, String value) {
        Configuration configuration = PropsUtil._getConfiguration();
        configuration.set(key, value);
    }

    private static Configuration _getConfiguration() {
        if (_configurations == null) {
            return _configuration;
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        if (companyId > 0L) {
            Configuration configuration = _configurations.get(companyId);
            if (configuration == null) {
                String webId = null;
                try {
                    Company company = CompanyLocalServiceUtil.getCompany((long)companyId);
                    webId = company.getWebId();
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
                configuration = new ConfigurationImpl(PropsUtil.class.getClassLoader(), "portal", companyId, webId);
                _configurations.put(companyId, configuration);
            }
            return configuration;
        }
        return _configuration;
    }

    private static Configuration _getConfiguration(Company company) {
        if (_configurations == null) {
            return _configuration;
        }
        long companyId = company.getCompanyId();
        Configuration configuration = _configurations.get(companyId);
        if (configuration == null) {
            configuration = new ConfigurationImpl(PropsUtil.class.getClassLoader(), "portal", companyId, company.getWebId());
            _configurations.put(companyId, configuration);
        }
        return configuration;
    }

    private static String _getDefaultLiferayHome() {
        int pos;
        String defaultLiferayHome = null;
        defaultLiferayHome = ServerDetector.isJBoss() ? SystemProperties.get((String)"jboss.home.dir") + "/.." : (ServerDetector.isWebLogic() ? SystemProperties.get((String)"env.DOMAIN_HOME") + "/.." : (ServerDetector.isTomcat() ? SystemProperties.get((String)"catalina.base") + "/.." : SystemProperties.get((String)"user.dir") + "/liferay"));
        defaultLiferayHome = StringUtil.replace((String)defaultLiferayHome, (char)'\\', (char)'/');
        if ((defaultLiferayHome = StringUtil.replace((String)defaultLiferayHome, (String)"//", (String)"/")).endsWith("/..") && (pos = defaultLiferayHome.lastIndexOf(47, defaultLiferayHome.length() - 4)) != -1) {
            defaultLiferayHome = defaultLiferayHome.substring(0, pos);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Default Liferay home " + defaultLiferayHome));
        }
        return defaultLiferayHome;
    }

    static {
        SystemProperties.set((String)"default.liferay.home", (String)PropsUtil._getDefaultLiferayHome());
        _configuration = ConfigurationFactoryImpl.CONFIGURATION_PORTAL;
        String liferayHome = _configuration.get("liferay.home");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Configured Liferay home " + liferayHome));
        }
        SystemProperties.set((String)"liferay.home", (String)liferayHome);
        SystemProperties.set((String)"ehcache.disk.store.dir", (String)(liferayHome + "/data/ehcache"));
        _configurations = GetterUtil.getBoolean((String)SystemProperties.get((String)"company-id-properties")) ? new HashMap<Long, Configuration>() : null;
    }
}

