/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.RepositoryEventTriggerCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalogUtil;
import java.util.Collection;

public class RepositoryUtil {
    private static final RepositoryEventTrigger _dummyRepositoryEventTrigger = new RepositoryEventTrigger(){

        public <S extends RepositoryEventType, T> void trigger(Class<S> repositoryEventTypeClass, Class<T> modelClass, T model) {
        }
    };

    public static RepositoryEventTrigger getFolderRepositoryEventTrigger(long folderId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getFolderLocalRepository((long)folderId);
        return RepositoryUtil.getRepositoryEventTrigger(localRepository);
    }

    public static RepositoryEventTrigger getRepositoryEventTrigger(long repositoryId) throws PortalException {
        return RepositoryUtil.getRepositoryEventTrigger(RepositoryProviderUtil.getLocalRepository((long)repositoryId));
    }

    public static boolean isExternalRepository(long repositoryId) {
        Repository repository = RepositoryLocalServiceUtil.fetchRepository((long)repositoryId);
        if (repository == null) {
            return false;
        }
        Collection<String> externalRepositoryClassNames = RepositoryClassDefinitionCatalogUtil.getExternalRepositoryClassNames();
        return externalRepositoryClassNames.contains(repository.getClassName());
    }

    protected static RepositoryEventTrigger getRepositoryEventTrigger(LocalRepository localRepository) {
        if (localRepository.isCapabilityProvided(RepositoryEventTriggerCapability.class)) {
            return (RepositoryEventTrigger)localRepository.getCapability(RepositoryEventTriggerCapability.class);
        }
        return _dummyRepositoryEventTrigger;
    }
}

