/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VerifyPermission
extends VerifyProcess {
    private static final long _DEPRECATED_ORGANIZATION_BITWISE_VALUES;
    private static final Log _log;
    private static final Map<Long, Long> _organizationToGroupBitwiseValues;

    protected void checkPermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List modelNames = ResourceActionsUtil.getModelNames();
            for (String modelName : modelNames) {
                List actionIds = ResourceActionsUtil.getModelResourceActions((String)modelName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)actionIds, (boolean)true);
            }
            List portletNames = ResourceActionsUtil.getPortletNames();
            for (String portletName : portletNames) {
                List actionIds = ResourceActionsUtil.getPortletResourceActions((String)portletName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)portletName, (List)actionIds, (boolean)true);
            }
        }
    }

    @Override
    protected void doVerify() throws Exception {
        this.checkPermissions();
        this.fixOrganizationRolePermissions();
        this.fixUserDefaultRolePermissions();
    }

    protected void fixOrganizationRolePermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = ResourcePermissionLocalServiceUtil.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"name", (Object)Organization.class.getName())));
            actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
                long oldActionIds = resourcePermission.getActionIds();
                long newActionIds = oldActionIds & (_DEPRECATED_ORGANIZATION_BITWISE_VALUES ^ 0xFFFFFFFFFFFFFFFFL);
                if (newActionIds == oldActionIds) {
                    return;
                }
                resourcePermission.setActionIds(newActionIds);
                ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)resourcePermission);
                long newGroupActionIds = 0L;
                for (Map.Entry<Long, Long> entry : _organizationToGroupBitwiseValues.entrySet()) {
                    long organizationBitwiseValue = entry.getKey();
                    if ((oldActionIds & organizationBitwiseValue) == 0L) continue;
                    long groupBitwiseValue = entry.getValue();
                    newGroupActionIds |= groupBitwiseValue;
                }
                ResourcePermission groupResourcePermission = ResourcePermissionLocalServiceUtil.fetchResourcePermission((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId());
                if (groupResourcePermission == null) {
                    long resourcePermissionId = CounterLocalServiceUtil.increment((String)ResourcePermission.class.getName());
                    groupResourcePermission = ResourcePermissionLocalServiceUtil.createResourcePermission((long)resourcePermissionId);
                    groupResourcePermission.setCompanyId(resourcePermission.getCompanyId());
                    groupResourcePermission.setName(Group.class.getName());
                    groupResourcePermission.setScope(resourcePermission.getScope());
                    groupResourcePermission.setPrimKey(resourcePermission.getPrimKey());
                    groupResourcePermission.setPrimKeyId(GetterUtil.getLong((String)resourcePermission.getPrimKey()));
                    groupResourcePermission.setRoleId(resourcePermission.getRoleId());
                    groupResourcePermission.setOwnerId(0L);
                    groupResourcePermission.setViewActionId(newGroupActionIds % 2L == 1L);
                }
                groupResourcePermission.setActionIds(groupResourcePermission.getActionIds() | newGroupActionIds);
                ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)groupResourcePermission);
            });
            actionableDynamicQuery.performActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixUserDefaultRolePermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long userClassNameId = PortalUtil.getClassNameId(User.class);
            long userGroupClassNameId = PortalUtil.getClassNameId(UserGroup.class);
            CompanyLocalServiceUtil.forEachCompanyId(companyId -> this.fixUserDefaultRolePermissions(userClassNameId, userGroupClassNameId, (long)companyId), (long[])PortalInstances.getCompanyIdsBySQL());
        }
        finally {
            EntityCacheUtil.clearCache();
            FinderCacheUtil.clearCache();
        }
    }

    protected void fixUserDefaultRolePermissions(long userClassNameId, long userGroupClassNameId, long companyId) throws Exception {
        Role powerUserRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
        Role userRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"User");
        String userPagePermissionsTableName = "TEMP_VERIFY_1";
        String userPagePermissionsConflictsTableName = "TEMP_VERIFY_2";
        try (AutoCloseable dropUserPagePermissionsTable = () -> this.runSQL("drop table " + userPagePermissionsTableName);
             AutoCloseable dropUserPagePermissionsConflictsTable = () -> this.runSQL("drop table " + userPagePermissionsConflictsTableName);){
            this.runSQL(StringBundler.concat((String[])new String[]{"create table ", userPagePermissionsTableName, " (resourcePermissionId LONG not null primary key, ", "primKey VARCHAR(255), plidLength INTEGER, plidString ", "VARCHAR(255), plid LONG, roleId LONG, conflict BOOLEAN)"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"create index IX_VERIFY_1 on ", userPagePermissionsTableName, " (plid)"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"create index IX_VERIFY_2 on ", userPagePermissionsTableName, " (primKey[$COLUMN_LENGTH:255$])"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"create table ", userPagePermissionsConflictsTableName, " (primKey VARCHAR(255) not null)"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"create index IX_VERIFY_3 on ", userPagePermissionsConflictsTableName, " (primKey[$COLUMN_LENGTH:255$])"}));
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Populating temporary table of portlet permissions");
            }
            this.runSQL(StringBundler.concat((String[])new String[]{"insert into ", userPagePermissionsTableName, " select resourcePermissionId, primKey, 0 as plidLength, ", "NULL as plidString, 0 as plid, roleId, [$FALSE$] as ", "conflict from ResourcePermission where companyId = ", String.valueOf(companyId), " and primKey LIKE '%_LAYOUT_%' and scope = ", String.valueOf(4), " and roleId in (", String.valueOf(powerUserRole.getRoleId()), ", ", String.valueOf(userRole.getRoleId()), ")"}));
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Deriving plid for portlet permissions");
            }
            this.runSQL(StringBundler.concat((String[])new String[]{"update ", userPagePermissionsTableName, " set plidLength = INSTR(primKey, '", "_LAYOUT_", "') - 1"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"update ", userPagePermissionsTableName, " set plidString = SUBSTR(primKey, 1, plidLength)"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"update ", userPagePermissionsTableName, " set plid = CAST_LONG(plidString)"}));
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Identifying portlets on user personal pages");
            }
            this.runSQL(StringBundler.concat((String[])new String[]{"delete from ", userPagePermissionsTableName, " where not exists (select 1 from Layout inner join ", "Group_ on Layout.groupId = Group_.groupId where ", userPagePermissionsTableName, ".plid = Layout.plid and Group_.classNameId in (", String.valueOf(userClassNameId), ", ", String.valueOf(userGroupClassNameId), ") and Layout.type_ = '", "portlet", "')"}));
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Identifying portlets that have both user and power user permissions");
            }
            this.runSQL(StringBundler.concat((String[])new String[]{"insert into ", userPagePermissionsConflictsTableName, " select primKey from ", userPagePermissionsTableName, " group by primKey having COUNT(*) > 1"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"delete from ", userPagePermissionsTableName, " where roleId = ", String.valueOf(userRole.getRoleId())}));
            this.runSQL(StringBundler.concat((String[])new String[]{"update ", userPagePermissionsTableName, " set conflict = [$TRUE$] where exists (select 1 from ", userPagePermissionsConflictsTableName, " where ", userPagePermissionsTableName, ".primKey = ", userPagePermissionsConflictsTableName, ".primKey)"}));
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Deleting power user permissions where the portlet has both user and power user permissions");
            }
            this.runSQL(StringBundler.concat((String[])new String[]{"delete from ResourcePermission where ", "resourcePermissionId in (select resourcePermissionId ", "from ", userPagePermissionsTableName, " where conflict = [$TRUE$])"}));
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Switching remaining portlet power user permissions to user permissions");
            }
            this.runSQL(StringBundler.concat((String[])new String[]{"update ResourcePermission set roleId = ", String.valueOf(userRole.getRoleId()), " where resourcePermissionId in (select ", "resourcePermissionId from ", userPagePermissionsTableName, " where conflict = [$FALSE$])"}));
        }
    }

    static {
        _log = LogFactoryUtil.getLog(VerifyPermission.class);
        _organizationToGroupBitwiseValues = new HashMap<Long, Long>();
        String[] deprecatedOrganizationActionIds = new String[]{"MANAGE_ARCHIVED_SETUPS", "MANAGE_LAYOUTS", "MANAGE_STAGING", "MANAGE_TEAMS", "PUBLISH_STAGING", "APPROVE_PROPOSAL", "ASSIGN_REVIEWER"};
        long deprecatedOrganizationBitwiseValues = 0L;
        for (String actionId : deprecatedOrganizationActionIds) {
            ResourceAction organizationResourceAction = ResourceActionLocalServiceUtil.fetchResourceAction((String)Organization.class.getName(), (String)actionId);
            if (organizationResourceAction == null) continue;
            deprecatedOrganizationBitwiseValues |= organizationResourceAction.getBitwiseValue();
            ResourceAction groupResourceAction = ResourceActionLocalServiceUtil.fetchResourceAction((String)Group.class.getName(), (String)actionId);
            if (groupResourceAction == null) continue;
            _organizationToGroupBitwiseValues.put(organizationResourceAction.getBitwiseValue(), groupResourceAction.getBitwiseValue());
        }
        _DEPRECATED_ORGANIZATION_BITWISE_VALUES = deprecatedOrganizationBitwiseValues;
    }
}

