/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.DBResourceUtil;
import com.liferay.portal.kernel.dao.db.BaseDBProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.verify.VerifyException;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class VerifyProcess
extends BaseDBProcess {
    public static final int ALWAYS = -1;
    public static final int NEVER = 0;
    public static final int ONCE = 1;
    private static final Log _log = LogFactoryUtil.getLog(VerifyProcess.class);
    private static final Pattern _createTablePattern = Pattern.compile("create table (\\S*) \\(");
    private Set<String> _portalTableNames;

    public void verify() throws VerifyException {
        long start = System.currentTimeMillis();
        try {
            try (Connection connection = this.getConnection();){
                this.connection = connection;
                this.process(companyId -> {
                    if (_log.isInfoEnabled()) {
                        String info = "Verifying " + ClassUtil.getClassName((Object)((Object)this));
                        if (Validator.isNotNull((Long)companyId)) {
                            info = info + "#" + companyId;
                        }
                        _log.info((Object)info);
                    }
                    this.doVerify();
                });
            }
            this.connection = null;
        }
        catch (Exception exception) {
            try {
                throw new VerifyException(exception);
            }
            catch (Throwable throwable) {
                this.connection = null;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Completed verification process ", ClassUtil.getClassName((Object)((Object)this)), " in ", System.currentTimeMillis() - start, " ms"}));
                }
                throw throwable;
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Completed verification process ", ClassUtil.getClassName((Object)((Object)this)), " in ", System.currentTimeMillis() - start, " ms"}));
        }
    }

    public void verify(VerifyProcess verifyProcess) throws VerifyException {
        verifyProcess.verify();
    }

    protected void doVerify() throws Exception {
    }

    @Deprecated
    protected void doVerify(Collection<? extends Callable<Void>> callables) throws Exception {
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(callables.size());
            List futures = executorService.invokeAll(callables);
            executorService.shutdown();
            UnsafeConsumer.accept(futures, Future::get);
        }
        catch (Throwable throwable) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            throw new Exception("Verification error: " + clazz.getName(), throwable);
        }
    }

    /*
     * Exception decompiling
     */
    protected int getBuildNumber() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Set<String> getPortalTableNames() throws Exception {
        if (this._portalTableNames != null) {
            return this._portalTableNames;
        }
        Matcher matcher = _createTablePattern.matcher(DBResourceUtil.getPortalTablesSQL());
        HashSet<String> tableNames = new HashSet<String>();
        while (matcher.find()) {
            String match = matcher.group(1);
            tableNames.add(StringUtil.toLowerCase((String)match));
        }
        this._portalTableNames = tableNames;
        return tableNames;
    }

    protected boolean isForceConcurrent(Collection<? extends Callable<Void>> callables) {
        return false;
    }

    protected boolean isPortalTableName(String tableName) throws Exception {
        Set<String> portalTableNames = this.getPortalTableNames();
        return portalTableNames.contains(StringUtil.toLowerCase((String)tableName));
    }
}

