/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.exception.NoSuchEntryException;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.kernel.validator.AssetEntryValidator;
import com.liferay.asset.kernel.validator.AssetEntryValidatorExclusionRule;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.RenderLayoutContentThreadLocal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.view.count.ViewCountManagerUtil;
import com.liferay.portlet.asset.service.base.AssetEntryLocalServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.portlet.asset.util.AssetSearcher;
import com.liferay.social.kernel.service.SocialActivityCounterLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.osgi.framework.BundleContext;

public class AssetEntryLocalServiceImpl
extends AssetEntryLocalServiceBaseImpl {
    @BeanReference(type=AssetCategoryLocalService.class)
    private AssetCategoryLocalService _assetCategoryLocalService;
    private final ServiceTrackerMap<String, List<AssetEntryValidatorExclusionRule>> _assetEntryValidatorExclusionRuleServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)SystemBundleUtil.getBundleContext(), AssetEntryValidatorExclusionRule.class, (String)"model.class.name");
    private final ServiceTrackerMap<String, List<AssetEntryValidator>> _assetEntryValidatorServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)SystemBundleUtil.getBundleContext(), AssetEntryValidator.class, (String)"model.class.name");
    @BeanReference(type=AssetLinkLocalService.class)
    private AssetLinkLocalService _assetLinkLocalService;
    @BeanReference(type=AssetTagLocalService.class)
    private AssetTagLocalService _assetTagLocalService;
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=SocialActivityCounterLocalService.class)
    private SocialActivityCounterLocalService _socialActivityCounterLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    @SystemEvent(type=1)
    public void deleteEntry(AssetEntry entry) throws PortalException {
        this._assetLinkLocalService.deleteLinks(entry.getEntryId());
        List tags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
        this.assetEntryPersistence.remove((BaseModel)entry);
        for (AssetTag tag : tags) {
            if (!entry.isVisible()) continue;
            this._assetTagLocalService.decrementAssetCount(tag.getTagId(), entry.getClassNameId());
        }
        ViewCountManagerUtil.deleteViewCount((long)entry.getCompanyId(), (long)this._classNameLocalService.getClassNameId(AssetEntry.class), (long)entry.getEntryId());
        SocialActivityManagerUtil.deleteActivities((ClassedModel)entry);
    }

    public void deleteEntry(long entryId) throws PortalException {
        AssetEntry entry = this.assetEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public void deleteEntry(String className, long classPK) throws PortalException {
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(this._classNameLocalService.getClassNameId(className), classPK);
        if (entry != null) {
            this.deleteEntry(entry);
        }
    }

    public void deleteGroupEntries(long groupId) throws PortalException {
        List<AssetEntry> assetEntries = this.getGroupEntries(groupId);
        for (AssetEntry assetEntry : assetEntries) {
            this.deleteEntry(assetEntry);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this._assetEntryValidatorExclusionRuleServiceTrackerMap.close();
        this._assetEntryValidatorServiceTrackerMap.close();
    }

    public AssetEntry fetchEntry(long entryId) {
        return this.assetEntryPersistence.fetchByPrimaryKey(entryId);
    }

    public AssetEntry fetchEntry(long classNameId, long classPK) {
        return this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
    }

    public AssetEntry fetchEntry(long groupId, String classUuid) {
        return this.assetEntryPersistence.fetchByG_CU(groupId, classUuid);
    }

    public AssetEntry fetchEntry(String className, long classPK) {
        return this.assetEntryLocalService.fetchEntry(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<AssetEntry> getAncestorEntries(long entryId) throws PortalException {
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        AssetEntry parentEntry = this.getParentEntry(entryId);
        while (parentEntry != null) {
            entries.add(parentEntry);
            parentEntry = this.getParentEntry(parentEntry.getEntryId());
        }
        return entries;
    }

    public List<AssetEntry> getChildEntries(long entryId) throws PortalException {
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        List links = this._assetLinkLocalService.getDirectLinks(entryId, 1);
        for (AssetLink link : links) {
            AssetEntry curAsset = this.getEntry(link.getEntryId2());
            entries.add(curAsset);
        }
        return entries;
    }

    public List<AssetEntry> getCompanyEntries(long companyId, int start, int end) {
        return this.assetEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyEntriesCount(long companyId) {
        return this.assetEntryPersistence.countByCompanyId(companyId);
    }

    public List<AssetEntry> getEntries(AssetEntryQuery entryQuery) {
        return this.assetEntryFinder.findEntries(entryQuery);
    }

    public List<AssetEntry> getEntries(long[] groupIds, long[] classNameIds, long[] classTypeIds, String keywords, String userName, String title, String description, Boolean listable, boolean advancedSearch, boolean andOperator, int start, int end, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2) {
        return this.getEntries(this.getAssetEntryQuery(groupIds, classNameIds, classTypeIds, keywords, userName, title, description, listable, advancedSearch, andOperator, start, end, orderByCol1, orderByCol2, orderByType1, orderByType2));
    }

    public List<AssetEntry> getEntries(long[] groupIds, long[] classNameIds, String keywords, String userName, String title, String description, Boolean listable, boolean advancedSearch, boolean andOperator, int start, int end, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2) {
        return this.getEntries(this.getAssetEntryQuery(groupIds, classNameIds, keywords, userName, title, description, listable, advancedSearch, andOperator, start, end, orderByCol1, orderByCol2, orderByType1, orderByType2));
    }

    public int getEntriesCount(AssetEntryQuery entryQuery) {
        return this.assetEntryFinder.countEntries(entryQuery);
    }

    public int getEntriesCount(long[] groupIds, long[] classNameIds, long[] classTypeIds, String keywords, String userName, String title, String description, Boolean listable, boolean advancedSearch, boolean andOperator) {
        return this.getEntriesCount(this.getAssetEntryQuery(groupIds, classNameIds, classTypeIds, keywords, userName, title, description, listable, advancedSearch, andOperator, -1, -1, null, null, null, null));
    }

    public int getEntriesCount(long[] groupIds, long[] classNameIds, String keywords, String userName, String title, String description, Boolean listable, boolean advancedSearch, boolean andOperator) {
        return this.getEntriesCount(groupIds, classNameIds, new long[0], keywords, userName, title, description, listable, advancedSearch, andOperator);
    }

    public AssetEntry getEntry(long entryId) throws PortalException {
        return this.assetEntryPersistence.findByPrimaryKey(entryId);
    }

    public AssetEntry getEntry(long groupId, String classUuid) throws PortalException {
        return this.assetEntryPersistence.findByG_CU(groupId, classUuid);
    }

    public AssetEntry getEntry(String className, long classPK) throws PortalException {
        return this.assetEntryPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public double getEntryPriority(long classNameId, long classPK) {
        AssetEntry assetEntry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (assetEntry == null) {
            return 0.0;
        }
        return assetEntry.getPriority();
    }

    public double getEntryPriority(String className, long classPK) {
        return this.getEntryPriority(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<AssetEntry> getGroupEntries(long groupId) {
        return this.assetEntryPersistence.findByGroupId(groupId);
    }

    public AssetEntry getNextEntry(long entryId) throws PortalException {
        try {
            this.getParentEntry(entryId);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            List<AssetEntry> childEntries = this.getChildEntries(entryId);
            if (childEntries.isEmpty()) {
                throw noSuchEntryException;
            }
            return childEntries.get(0);
        }
        List links = this._assetLinkLocalService.getDirectLinks(entryId, 1);
        for (int i = 0; i < links.size(); ++i) {
            AssetLink link = (AssetLink)links.get(i);
            if (link.getEntryId2() != entryId) continue;
            if (i + 1 >= links.size()) {
                throw new NoSuchEntryException("{entryId=" + entryId + "}");
            }
            AssetLink nextLink = (AssetLink)links.get(i + 1);
            return this.getEntry(nextLink.getEntryId2());
        }
        throw new NoSuchEntryException("{entryId=" + entryId + "}");
    }

    public AssetEntry getParentEntry(long entryId) throws PortalException {
        List links = this._assetLinkLocalService.getReverseLinks(entryId, 1);
        if (links.isEmpty()) {
            throw new NoSuchEntryException("{entryId=" + entryId + "}");
        }
        AssetLink link = (AssetLink)links.get(0);
        return this.getEntry(link.getEntryId1());
    }

    public AssetEntry getPreviousEntry(long entryId) throws PortalException {
        this.getParentEntry(entryId);
        List links = this._assetLinkLocalService.getDirectLinks(entryId, 1);
        for (int i = 0; i < links.size(); ++i) {
            AssetLink link = (AssetLink)links.get(i);
            if (link.getEntryId2() != entryId) continue;
            if (i == 0) {
                throw new NoSuchEntryException("{entryId=" + entryId + "}");
            }
            AssetLink nextAssetLink = (AssetLink)links.get(i - 1);
            return this.getEntry(nextAssetLink.getEntryId2());
        }
        throw new NoSuchEntryException("{entryId=" + entryId + "}");
    }

    public List<AssetEntry> getTopViewedEntries(String className, boolean asc, int start, int end) {
        return this.getTopViewedEntries(new String[]{className}, asc, start, end);
    }

    public List<AssetEntry> getTopViewedEntries(String[] className, boolean asc, int start, int end) {
        long[] classNameIds = new long[className.length];
        for (int i = 0; i < className.length; ++i) {
            classNameIds[i] = this._classNameLocalService.getClassNameId(className[i]);
        }
        AssetEntryQuery entryQuery = new AssetEntryQuery();
        entryQuery.setClassNameIds(classNameIds);
        entryQuery.setEnd(end);
        entryQuery.setExcludeZeroViewCount(true);
        entryQuery.setOrderByCol1("viewCount");
        entryQuery.setOrderByType1(asc ? "ASC" : "DESC");
        entryQuery.setStart(start);
        return this.assetEntryFinder.findEntries(entryQuery);
    }

    public void incrementViewCounter(long userId, AssetEntry assetEntry) throws PortalException {
        if (RenderLayoutContentThreadLocal.isRenderLayoutContent()) {
            return;
        }
        User user = this._userLocalService.getUser(userId);
        this.assetEntryLocalService.incrementViewCounter(assetEntry.getCompanyId(), user.getUserId(), assetEntry.getClassName(), assetEntry.getClassPK(), 1);
        if (!user.isDefaultUser()) {
            SocialActivityManagerUtil.addActivity((long)user.getUserId(), (ClassedModel)assetEntry, (int)10001, (String)"", (long)0L);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public AssetEntry incrementViewCounter(long companyId, long userId, String className, long classPK) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this.assetEntryLocalService.incrementViewCounter(companyId, user.getUserId(), className, classPK, 1);
        AssetEntry assetEntry = this.getEntry(className, classPK);
        if (!user.isDefaultUser()) {
            SocialActivityManagerUtil.addActivity((long)user.getUserId(), (ClassedModel)assetEntry, (int)10001, (String)"", (long)0L);
        }
        return assetEntry;
    }

    @Transactional(enabled=false)
    public void incrementViewCounter(long companyId, long userId, String className, long classPK, int increment) {
        if (ExportImportThreadLocal.isImportInProcess() || classPK <= 0L) {
            return;
        }
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(this._classNameLocalService.getClassNameId(className), classPK);
        if (entry == null) {
            return;
        }
        ViewCountManagerUtil.incrementViewCount((long)companyId, (long)this._classNameLocalService.getClassNameId(AssetEntry.class), (long)entry.getEntryId(), (int)increment);
    }

    public void reindex(List<AssetEntry> entries) throws PortalException {
        for (AssetEntry entry : entries) {
            this.reindex(entry);
        }
    }

    public Hits search(long companyId, long[] groupIds, long userId, long[] classNameIds, long classTypeId, String keywords, boolean showNonindexable, int[] statuses, int start, int end, Sort sort) {
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, groupIds, userId, classTypeId, keywords, null, null, showNonindexable, statuses, false, start, end, sort);
            return this.doSearch(classNameIds, searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, long classTypeId, String keywords, boolean showNonindexable, int status, int start, int end) {
        return this.search(companyId, groupIds, userId, className, classTypeId, keywords, keywords, keywords, null, null, showNonindexable, new int[]{status}, false, start, end);
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, long classTypeId, String keywords, boolean showNonindexable, int[] statuses, int start, int end) {
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, groupIds, userId, classTypeId, keywords, null, null, showNonindexable, statuses, false, start, end);
            return this.doSearch(companyId, className, searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, long classTypeId, String keywords, boolean showNonindexable, int[] statuses, int start, int end, Sort sort) {
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, groupIds, userId, classTypeId, keywords, null, null, showNonindexable, statuses, false, start, end, sort);
            return this.doSearch(companyId, className, searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, long classTypeId, String keywords, int status, int start, int end) {
        return this.search(companyId, groupIds, userId, className, classTypeId, keywords, false, status, start, end);
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, long classTypeId, String userName, String title, String description, String assetCategoryIds, String assetTagNames, boolean showNonindexable, int status, boolean andSearch, int start, int end) {
        return this.search(companyId, groupIds, userId, className, classTypeId, userName, title, description, assetCategoryIds, assetTagNames, showNonindexable, new int[]{status}, andSearch, start, end);
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, long classTypeId, String userName, String title, String description, String assetCategoryIds, String assetTagNames, boolean showNonindexable, int[] statuses, boolean andSearch, int start, int end) {
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, groupIds, userId, classTypeId, userName, title, description, assetCategoryIds, assetTagNames, showNonindexable, statuses, andSearch, start, end);
            return this.doSearch(companyId, className, searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, long classTypeId, String userName, String title, String description, String assetCategoryIds, String assetTagNames, int status, boolean andSearch, int start, int end) {
        return this.search(companyId, groupIds, userId, className, classTypeId, userName, title, description, assetCategoryIds, assetTagNames, false, new int[]{status}, andSearch, start, end);
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, String keywords, int status, int start, int end) {
        return this.search(companyId, groupIds, userId, className, 0L, keywords, status, start, end);
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, String userName, String title, String description, String assetCategoryIds, String assetTagNames, int status, boolean andSearch, int start, int end) {
        return this.search(companyId, groupIds, userId, className, 0L, userName, title, description, assetCategoryIds, assetTagNames, status, andSearch, start, end);
    }

    public long searchCount(long companyId, long[] groupIds, long userId, long[] classNameIds, long classTypeId, String keywords, boolean showNonindexable, int[] statuses) {
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, groupIds, userId, classTypeId, keywords, null, null, showNonindexable, statuses, false, -1, -1);
            return this.doSearchCount(classNameIds, searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public long searchCount(long companyId, long[] groupIds, long userId, String className, long classTypeId, String keywords, boolean showNonindexable, int[] statuses) {
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, groupIds, userId, classTypeId, keywords, null, null, showNonindexable, statuses, false, -1, -1);
            return this.doSearchCount(companyId, className, searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public long searchCount(long companyId, long[] groupIds, long userId, String className, long classTypeId, String keywords, String assetCategoryIds, String assetTagNames, boolean showInvisible, boolean showNonindexable, int[] statuses, boolean andSearch) {
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, groupIds, userId, classTypeId, keywords, assetCategoryIds, assetTagNames, showNonindexable, statuses, andSearch, -1, -1);
            return this.doSearchCount(companyId, className, searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public long searchCount(long companyId, long[] groupIds, long userId, String className, long classTypeId, String userName, String title, String description, String assetCategoryIds, String assetTagNames, boolean showInvisible, boolean showNonindexable, int[] statuses, boolean andSearch) {
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, groupIds, userId, classTypeId, userName, title, description, assetCategoryIds, assetTagNames, showNonindexable, statuses, andSearch, -1, -1);
            return this.doSearchCount(companyId, className, searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public long searchCount(long companyId, long[] groupIds, long userId, String className, long classTypeId, String userName, String title, String description, String assetCategoryIds, String assetTagNames, boolean showNonindexable, int[] statuses, boolean andSearch) {
        return this.searchCount(companyId, groupIds, userId, className, classTypeId, userName, title, description, assetCategoryIds, assetTagNames, showNonindexable, false, statuses, andSearch);
    }

    public AssetEntry updateEntry(long userId, long groupId, Date createDate, Date modifiedDate, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean listable, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Double priority) throws PortalException {
        return this.updateEntry(userId, groupId, createDate, modifiedDate, className, classPK, classUuid, classTypeId, categoryIds, tagNames, listable, visible, startDate, endDate, publishDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority, null);
    }

    public AssetEntry updateEntry(long userId, long groupId, Date createDate, Date modifiedDate, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean listable, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Double priority, ServiceContext serviceContext) throws PortalException {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        this.validate(groupId, className, classPK, classTypeId, categoryIds, tagNames);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        long entryId = 0L;
        boolean oldVisible = false;
        if (entry == null) {
            entryId = this.counterLocalService.increment();
        } else {
            entryId = entry.getEntryId();
            oldVisible = entry.isVisible();
        }
        if (tagNames != null && (entry != null || tagNames.length > 0)) {
            Group siteGroup = this._groupLocalService.getGroup(PortalUtil.getSiteGroupId((long)groupId));
            List tags = this._assetTagLocalService.checkTags(userId, siteGroup, tagNames);
            if (visible) {
                if (entry == null) {
                    for (AssetTag tag : tags) {
                        this._assetTagLocalService.incrementAssetCount(tag.getTagId(), classNameId);
                    }
                } else {
                    List oldTags = this.assetEntryPersistence.getAssetTags(entryId);
                    for (AssetTag oldTag : oldTags) {
                        if (tags.contains(oldTag)) continue;
                        this._assetTagLocalService.decrementAssetCount(oldTag.getTagId(), classNameId);
                    }
                    for (AssetTag tag : tags) {
                        if (oldTags.contains(tag)) continue;
                        this._assetTagLocalService.incrementAssetCount(tag.getTagId(), classNameId);
                    }
                }
            } else if (oldVisible) {
                List oldTags = this.assetEntryPersistence.getAssetTags(entryId);
                for (AssetTag oldTag : oldTags) {
                    this._assetTagLocalService.decrementAssetCount(oldTag.getTagId(), classNameId);
                }
            }
            this.assetEntryPersistence.setAssetTags(entryId, tags);
        }
        if (entry == null) {
            entry = this.assetEntryPersistence.create(entryId);
            Group group = this._groupLocalService.getGroup(groupId);
            entry.setCompanyId(group.getCompanyId());
            entry.setUserId(userId);
            User user = this._userLocalService.fetchUser(userId);
            if (user != null) {
                entry.setUserName(user.getFullName());
            } else {
                entry.setUserName("");
            }
            if (createDate == null) {
                createDate = new Date();
            }
            entry.setCreateDate(createDate);
            entry.setClassNameId(classNameId);
            entry.setClassPK(classPK);
            entry.setClassUuid(classUuid);
            if (priority == null) {
                entry.setPriority(0.0);
            }
        } else {
            entry = this.assetEntryPersistence.findByPrimaryKey(entryId);
        }
        entry.setGroupId(groupId);
        if (modifiedDate == null) {
            modifiedDate = new Date();
        }
        entry.setModifiedDate(modifiedDate);
        entry.setClassTypeId(classTypeId);
        entry.setListable(listable);
        entry.setVisible(visible);
        entry.setStartDate(startDate);
        entry.setEndDate(endDate);
        if (publishDate != null) {
            entry.setPublishDate(publishDate);
        }
        entry.setExpirationDate(expirationDate);
        entry.setMimeType(mimeType);
        entry.setTitle(title);
        entry.setDescription(description);
        entry.setSummary(summary);
        entry.setUrl(url);
        entry.setLayoutUuid(layoutUuid);
        entry.setHeight(height);
        entry.setWidth(width);
        if (priority != null) {
            entry.setPriority(priority.doubleValue());
        }
        entry = (AssetEntry)this.assetEntryPersistence.update((BaseModel)entry);
        if (serviceContext == null || serviceContext.isIndexingEnabled()) {
            this.reindex(entry);
        }
        return entry;
    }

    public AssetEntry updateEntry(long userId, long groupId, String className, long classPK, long[] categoryIds, String[] tagNames) throws PortalException {
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(this._classNameLocalService.getClassNameId(className), classPK);
        if (entry != null) {
            return this.assetEntryLocalService.updateEntry(userId, groupId, entry.getCreateDate(), entry.getModifiedDate(), className, classPK, entry.getClassUuid(), entry.getClassTypeId(), categoryIds, tagNames, entry.isListable(), entry.isVisible(), entry.getStartDate(), entry.getEndDate(), entry.getPublishDate(), entry.getExpirationDate(), entry.getMimeType(), entry.getTitle(), entry.getDescription(), entry.getSummary(), entry.getUrl(), entry.getLayoutUuid(), entry.getHeight(), entry.getWidth(), Double.valueOf(entry.getPriority()));
        }
        return this.assetEntryLocalService.updateEntry(userId, groupId, null, null, className, classPK, null, 0L, categoryIds, tagNames, true, true, null, null, null, null, null, null, null, null, null, null, 0, 0, (Double)null);
    }

    public AssetEntry updateEntry(String className, long classPK, Date publishDate, Date expirationDate, boolean listable, boolean visible) throws PortalException {
        AssetEntry entry = this.assetEntryPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), classPK);
        entry.setListable(listable);
        entry.setPublishDate(publishDate);
        entry.setExpirationDate(expirationDate);
        return this.updateVisible(entry, visible);
    }

    public AssetEntry updateVisible(AssetEntry entry, boolean visible) throws PortalException {
        if (visible == entry.isVisible()) {
            return (AssetEntry)this.assetEntryPersistence.update((BaseModel)entry);
        }
        entry.setVisible(visible);
        entry = (AssetEntry)this.assetEntryPersistence.update((BaseModel)entry);
        List tags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
        if (visible) {
            for (AssetTag tag : tags) {
                this._assetTagLocalService.incrementAssetCount(tag.getTagId(), entry.getClassNameId());
            }
            this._socialActivityCounterLocalService.enableActivityCounters(entry.getClassNameId(), entry.getClassPK());
        } else {
            for (AssetTag tag : tags) {
                this._assetTagLocalService.decrementAssetCount(tag.getTagId(), entry.getClassNameId());
            }
            this._socialActivityCounterLocalService.disableActivityCounters(entry.getClassNameId(), entry.getClassPK());
        }
        return entry;
    }

    public AssetEntry updateVisible(String className, long classPK, boolean visible) throws PortalException {
        AssetEntry entry = this.assetEntryPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), classPK);
        return this.updateVisible(entry, visible);
    }

    public void validate(long groupId, String className, long classPK, long classTypePK, long[] categoryIds, String[] tagNames) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        List assetEntryValidatorExclusionRules = (List)this._assetEntryValidatorExclusionRuleServiceTrackerMap.getService((Object)className);
        if (assetEntryValidatorExclusionRules != null) {
            for (AssetEntryValidatorExclusionRule assetEntryValidatorExclusionRule : assetEntryValidatorExclusionRules) {
                if (!assetEntryValidatorExclusionRule.isValidationExcluded(groupId, className, classPK, classTypePK, categoryIds, tagNames)) continue;
                return;
            }
        }
        for (AssetEntryValidator assetEntryValidator : this._getAssetEntryValidators(className)) {
            assetEntryValidator.validate(groupId, className, classPK, classTypePK, categoryIds, tagNames);
        }
    }

    public void validate(long groupId, String className, long classTypePK, long[] categoryIds, String[] tagNames) throws PortalException {
        this.validate(groupId, className, 0L, classTypePK, categoryIds, tagNames);
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, long userId, long classTypeId, String assetCategoryIds, String assetTagNames, boolean showNonindexable, int[] statuses, boolean andSearch, int start, int end) {
        return this.buildSearchContext(companyId, groupIds, userId, classTypeId, assetCategoryIds, assetTagNames, showNonindexable, statuses, andSearch, start, end, null);
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, long userId, long classTypeId, String assetCategoryIds, String assetTagNames, boolean showNonindexable, int[] statuses, boolean andSearch, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        searchContext.setAssetCategoryIds(StringUtil.split((String)assetCategoryIds, (long)0L));
        searchContext.setAssetTagNames(StringUtil.split((String)assetTagNames));
        searchContext.setAttribute("paginationType", (Serializable)((Object)"regular"));
        if (showNonindexable) {
            searchContext.setAttribute("showNonindexable", (Serializable)Boolean.TRUE);
        }
        searchContext.setAttribute("status", (Serializable)statuses);
        if (classTypeId >= 0L) {
            searchContext.setClassTypeIds(new long[]{classTypeId});
        }
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setSorts(new Sort[]{sort});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, long userId, long classTypeId, String keywords, String assetCategoryIds, String assetTagNames, boolean showNonindexable, int[] statuses, boolean andSearch, int start, int end) {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, userId, classTypeId, assetCategoryIds, assetTagNames, showNonindexable, statuses, andSearch, start, end);
        searchContext.setKeywords(keywords);
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, long userId, long classTypeId, String keywords, String assetCategoryIds, String assetTagNames, boolean showNonindexable, int[] statuses, boolean andSearch, int start, int end, Sort sort) {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, userId, classTypeId, assetCategoryIds, assetTagNames, showNonindexable, statuses, andSearch, start, end, sort);
        searchContext.setKeywords(keywords);
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, long userId, long classTypeId, String userName, String title, String description, String assetCategoryIds, String assetTagNames, boolean showNonindexable, int[] statuses, boolean andSearch, int start, int end) {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, userId, classTypeId, assetCategoryIds, assetTagNames, showNonindexable, statuses, andSearch, start, end);
        searchContext.setAttribute("description", (Serializable)((Object)description));
        searchContext.setAttribute("title", (Serializable)((Object)title));
        searchContext.setAttribute("userName", (Serializable)((Object)userName));
        return searchContext;
    }

    protected long[] checkCategories(String className, long classPK, long[] categoryIds) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            return categoryIds;
        }
        List oldCategories = this._assetCategoryLocalService.getCategories(className, classPK);
        for (AssetCategory category : oldCategories) {
            if (ArrayUtil.contains((long[])categoryIds, (long)category.getCategoryId()) || AssetCategoryPermission.contains(permissionChecker, category, "VIEW")) continue;
            categoryIds = ArrayUtil.append((long[])categoryIds, (long)category.getCategoryId());
        }
        return categoryIds;
    }

    protected Hits doSearch(long companyId, String className, SearchContext searchContext) throws Exception {
        return this.doSearch(this.getClassNameIds(companyId, className), searchContext);
    }

    protected Hits doSearch(long[] classNameIds, SearchContext searchContext) throws Exception {
        Indexer<?> indexer = AssetSearcher.getInstance();
        AssetSearcher assetSearcher = (AssetSearcher)indexer;
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        assetEntryQuery.setClassNameIds(classNameIds);
        this._setAssetCategoryIds(searchContext.getAssetCategoryIds(), searchContext.isAndSearch(), assetEntryQuery);
        this._setAssetTagNames(searchContext.getGroupIds(), searchContext.getAssetTagNames(), searchContext.isAndSearch(), assetEntryQuery);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(this._hasScoreSort(searchContext));
        assetSearcher.setAssetEntryQuery(assetEntryQuery);
        return assetSearcher.search(searchContext);
    }

    protected long doSearchCount(long companyId, String className, SearchContext searchContext) throws Exception {
        return this.doSearchCount(this.getClassNameIds(companyId, className), searchContext);
    }

    protected long doSearchCount(long[] classNameIds, SearchContext searchContext) throws Exception {
        Indexer<?> indexer = AssetSearcher.getInstance();
        AssetSearcher assetSearcher = (AssetSearcher)indexer;
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        assetEntryQuery.setClassNameIds(classNameIds);
        this._setAssetCategoryIds(searchContext.getAssetCategoryIds(), searchContext.isAndSearch(), assetEntryQuery);
        this._setAssetTagNames(searchContext.getGroupIds(), searchContext.getAssetTagNames(), searchContext.isAndSearch(), assetEntryQuery);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        assetSearcher.setAssetEntryQuery(assetEntryQuery);
        return assetSearcher.searchCount(searchContext);
    }

    protected AssetEntryQuery getAssetEntryQuery(long[] groupIds, long[] classNameIds, long[] classTypeIds, String keywords, String userName, String title, String description, Boolean listable, boolean advancedSearch, boolean andOperator, int start, int end, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2) {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        assetEntryQuery.setClassNameIds(classNameIds);
        if (ArrayUtil.isNotEmpty((long[])classTypeIds)) {
            assetEntryQuery.setClassTypeIds(classTypeIds);
        }
        assetEntryQuery.setEnd(end);
        assetEntryQuery.setGroupIds(groupIds);
        assetEntryQuery.setListable(listable);
        assetEntryQuery.setOrderByCol1(orderByCol1);
        assetEntryQuery.setOrderByCol2(orderByCol2);
        assetEntryQuery.setOrderByType1(orderByType1);
        assetEntryQuery.setOrderByType2(orderByType2);
        assetEntryQuery.setStart(start);
        if (advancedSearch) {
            assetEntryQuery.setAndOperator(andOperator);
            assetEntryQuery.setDescription(description);
            assetEntryQuery.setTitle(title);
            assetEntryQuery.setUserName(userName);
        } else {
            assetEntryQuery.setKeywords(keywords);
        }
        return assetEntryQuery;
    }

    protected AssetEntryQuery getAssetEntryQuery(long[] groupIds, long[] classNameIds, String keywords, String userName, String title, String description, Boolean listable, boolean advancedSearch, boolean andOperator, int start, int end, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2) {
        return this.getAssetEntryQuery(groupIds, classNameIds, new long[0], keywords, userName, title, description, listable, advancedSearch, andOperator, start, end, orderByCol1, orderByCol2, orderByType1, orderByType2);
    }

    protected long[] getClassNameIds(long companyId, String className) {
        if (Validator.isNotNull((String)className)) {
            return new long[]{this._classNameLocalService.getClassNameId(className)};
        }
        List rendererFactories = AssetRendererFactoryRegistryUtil.getAssetRendererFactories((long)companyId);
        long[] classNameIds = new long[rendererFactories.size()];
        for (int i = 0; i < rendererFactories.size(); ++i) {
            AssetRendererFactory assetRendererFactory = (AssetRendererFactory)rendererFactories.get(i);
            classNameIds[i] = this._classNameLocalService.getClassNameId(assetRendererFactory.getClassName());
        }
        return classNameIds;
    }

    protected long[] getTagIds(long[] groupIds, String tagName) {
        if (groupIds != null) {
            return this._assetTagLocalService.getTagIds(groupIds, tagName);
        }
        return this._assetTagLocalService.getTagIds(tagName);
    }

    protected void reindex(AssetEntry entry) throws PortalException {
        String className = PortalUtil.getClassName((long)entry.getClassNameId());
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)className);
        indexer.reindex(className, entry.getClassPK());
    }

    private List<AssetEntryValidator> _getAssetEntryValidators(String className) {
        List classNameAssetEntryValidators;
        ArrayList<AssetEntryValidator> assetEntryValidators = new ArrayList<AssetEntryValidator>();
        List generalAssetEntryValidators = (List)this._assetEntryValidatorServiceTrackerMap.getService((Object)"*");
        if (ListUtil.isNotEmpty((List)generalAssetEntryValidators)) {
            assetEntryValidators.addAll(generalAssetEntryValidators);
        }
        if (Validator.isNotNull((String)className) && ListUtil.isNotEmpty((List)(classNameAssetEntryValidators = (List)this._assetEntryValidatorServiceTrackerMap.getService((Object)className)))) {
            assetEntryValidators.addAll(classNameAssetEntryValidators);
        }
        return assetEntryValidators;
    }

    private boolean _hasScoreSort(SearchContext searchContext) {
        for (Sort sort : searchContext.getSorts()) {
            if (sort == null || sort.getType() != 0) continue;
            return true;
        }
        return false;
    }

    private void _setAssetCategoryIds(long[] assetCategoryIds, boolean andSearch, AssetEntryQuery assetEntryQuery) {
        if (ArrayUtil.isEmpty((long[])assetCategoryIds)) {
            return;
        }
        if (andSearch) {
            assetEntryQuery.setAnyCategoryIds(assetCategoryIds);
        } else {
            assetEntryQuery.setAllCategoryIds(assetCategoryIds);
        }
    }

    private void _setAssetTagNames(long[] groupIds, String[] assetTagNames, boolean andSearch, AssetEntryQuery assetEntryQuery) {
        if (andSearch) {
            for (String assetTagName : assetTagNames) {
                long[] allAssetTagIds = this.getTagIds(groupIds, assetTagName);
                assetEntryQuery.addAllTagIdsArray(allAssetTagIds);
            }
        } else if (ArrayUtil.isNotEmpty((Object[])assetTagNames)) {
            long[] assetTagIds = this.getTagIds(groupIds, StringUtil.merge((Object[])assetTagNames));
            assetEntryQuery.setAnyTagIds(assetTagIds);
        }
    }
}

