/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.model.AssetVocabularyDisplay;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.base.AssetVocabularyServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoriesPermission;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetVocabularyServiceImpl
extends AssetVocabularyServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;

    public AssetVocabulary addVocabulary(long groupId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, int visibilityType, ServiceContext serviceContext) throws PortalException {
        AssetCategoriesPermission.check(this.getPermissionChecker(), groupId, "ADD_VOCABULARY");
        return this.assetVocabularyLocalService.addVocabulary(this.getUserId(), groupId, title, titleMap, descriptionMap, settings, visibilityType, serviceContext);
    }

    public AssetVocabulary addVocabulary(long groupId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        AssetCategoriesPermission.check(this.getPermissionChecker(), groupId, "ADD_VOCABULARY");
        return this.assetVocabularyLocalService.addVocabulary(this.getUserId(), groupId, title, titleMap, descriptionMap, settings, serviceContext);
    }

    public AssetVocabulary addVocabulary(long groupId, String title, ServiceContext serviceContext) throws PortalException {
        AssetCategoriesPermission.check(this.getPermissionChecker(), groupId, "ADD_VOCABULARY");
        return this.assetVocabularyLocalService.addVocabulary(this.getUserId(), groupId, title, serviceContext);
    }

    public AssetVocabulary addVocabulary(long groupId, String name, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        AssetCategoriesPermission.check(this.getPermissionChecker(), groupId, "ADD_VOCABULARY");
        return this.assetVocabularyLocalService.addVocabulary(this.getUserId(), groupId, name, title, titleMap, descriptionMap, settings, serviceContext);
    }

    public AssetVocabulary addVocabulary(String externalReferenceCode, long groupId, String name, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, int visibilityType, ServiceContext serviceContext) throws PortalException {
        AssetCategoriesPermission.check(this.getPermissionChecker(), groupId, "ADD_VOCABULARY");
        return this.assetVocabularyLocalService.addVocabulary(externalReferenceCode, this.getUserId(), groupId, name, title, titleMap, descriptionMap, settings, visibilityType, serviceContext);
    }

    public List<AssetVocabulary> deleteVocabularies(long[] vocabularyIds, ServiceContext serviceContext) throws PortalException {
        ArrayList<AssetVocabulary> failedVocabularies = new ArrayList<AssetVocabulary>();
        for (long vocabularyId : vocabularyIds) {
            try {
                AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "DELETE");
                this.assetVocabularyLocalService.deleteVocabulary(vocabularyId);
            }
            catch (PortalException portalException) {
                if (serviceContext == null) {
                    return null;
                }
                if (serviceContext.isFailOnPortalException()) {
                    throw portalException;
                }
                AssetVocabulary vocabulary = this.assetVocabularyPersistence.fetchByPrimaryKey(vocabularyId);
                if (vocabulary == null) {
                    vocabulary = this.assetVocabularyPersistence.create(vocabularyId);
                }
                failedVocabularies.add(vocabulary);
            }
        }
        return failedVocabularies;
    }

    public void deleteVocabulary(long vocabularyId) throws PortalException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "DELETE");
        this.assetVocabularyLocalService.deleteVocabulary(vocabularyId);
    }

    public AssetVocabulary fetchVocabulary(long vocabularyId) throws PortalException {
        AssetVocabulary vocabulary = this.assetVocabularyLocalService.fetchAssetVocabulary(vocabularyId);
        if (vocabulary != null) {
            AssetVocabularyPermission.check(this.getPermissionChecker(), vocabulary, "VIEW");
        }
        return vocabulary;
    }

    public AssetVocabulary getAssetVocabularyByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        AssetVocabulary vocabulary = this.assetVocabularyLocalService.getAssetVocabularyByExternalReferenceCode(externalReferenceCode, groupId);
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabulary.getVocabularyId(), "VIEW");
        return vocabulary;
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds) {
        return this.getGroupsVocabularies(groupIds, null);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className) {
        return this.getGroupsVocabularies(groupIds, className, -1L);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className, long classTypePK) {
        List vocabularies = this.assetVocabularyPersistence.filterFindByGroupId(groupIds);
        if (Validator.isNull((String)className)) {
            return vocabularies;
        }
        long classNameId = this._classNameLocalService.getClassNameId(className);
        return ListUtil.filter((List)vocabularies, assetVocabulary -> assetVocabulary.isAssociatedToClassNameIdAndClassTypePK(classNameId, classTypePK));
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId) throws PortalException {
        return this.getGroupVocabularies(groupId, true);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, boolean createDefaultVocabulary) throws PortalException {
        return this.getGroupVocabularies(groupId, createDefaultVocabulary, -1, -1, null);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, boolean createDefaultVocabulary, int start, int end, OrderByComparator<AssetVocabulary> orderByComparator) throws PortalException {
        List<AssetVocabulary> vocabularies = this.getGroupVocabularies(groupId, start, end, orderByComparator);
        if (!vocabularies.isEmpty() || !createDefaultVocabulary) {
            return vocabularies;
        }
        int count = this.assetVocabularyLocalService.getGroupVocabulariesCount(new long[]{groupId});
        if (count > 0) {
            return vocabularies;
        }
        vocabularies = new ArrayList<AssetVocabulary>();
        AssetVocabulary vocabulary = this.assetVocabularyLocalService.addDefaultVocabulary(groupId);
        vocabularies.add(vocabulary);
        return vocabularies;
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, int visibilityType) {
        return this.assetVocabularyPersistence.filterFindByG_V(groupId, visibilityType);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, int start, int end, OrderByComparator<AssetVocabulary> orderByComparator) {
        return this.assetVocabularyPersistence.filterFindByGroupId(groupId, start, end, orderByComparator);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> orderByComparator) {
        return this.assetVocabularyPersistence.filterFindByG_LikeN(groupId, name, start, end, orderByComparator);
    }

    public List<AssetVocabulary> getGroupVocabularies(long[] groupIds) {
        return this.assetVocabularyPersistence.filterFindByGroupId(groupIds);
    }

    public List<AssetVocabulary> getGroupVocabularies(long[] groupIds, int[] visibilityTypes) {
        return this.assetVocabularyPersistence.filterFindByG_V(groupIds, visibilityTypes);
    }

    public int getGroupVocabulariesCount(long groupId) {
        return this.assetVocabularyPersistence.filterCountByGroupId(groupId);
    }

    public int getGroupVocabulariesCount(long groupId, String name) {
        return this.assetVocabularyPersistence.filterCountByG_LikeN(groupId, name);
    }

    public int getGroupVocabulariesCount(long[] groupIds) {
        return this.assetVocabularyPersistence.filterCountByGroupId(groupIds);
    }

    public AssetVocabularyDisplay getGroupVocabulariesDisplay(long groupId, String name, int start, int end, boolean addDefaultVocabulary, OrderByComparator<AssetVocabulary> orderByComparator) throws PortalException {
        List<AssetVocabulary> vocabularies;
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            vocabularies = this.getGroupVocabularies(groupId, name, start, end, orderByComparator);
            total = this.getGroupVocabulariesCount(groupId, name);
        } else {
            vocabularies = this.getGroupVocabularies(groupId, start, end, orderByComparator);
            total = this.getGroupVocabulariesCount(groupId);
        }
        if (addDefaultVocabulary && total == 0 && this.assetVocabularyPersistence.countByGroupId(groupId) == 0) {
            vocabularies = new ArrayList<AssetVocabulary>();
            vocabularies.add(this.assetVocabularyLocalService.addDefaultVocabulary(groupId));
            total = 1;
        }
        return new AssetVocabularyDisplay(vocabularies, total, start, end);
    }

    public AssetVocabularyDisplay getGroupVocabulariesDisplay(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> orderByComparator) throws PortalException {
        return this.getGroupVocabulariesDisplay(groupId, name, start, end, false, orderByComparator);
    }

    public AssetVocabulary getVocabulary(long vocabularyId) throws PortalException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "VIEW");
        return this.assetVocabularyLocalService.getVocabulary(vocabularyId);
    }

    public AssetVocabularyDisplay searchVocabulariesDisplay(long groupId, String title, boolean addDefaultVocabulary, int start, int end) throws PortalException {
        return this.searchVocabulariesDisplay(groupId, title, addDefaultVocabulary, start, end, null);
    }

    public AssetVocabularyDisplay searchVocabulariesDisplay(long groupId, String title, boolean addDefaultVocabulary, int start, int end, Sort sort) throws PortalException {
        User user = this.getUser();
        BaseModelSearchResult baseModelSearchResult = this.assetVocabularyLocalService.searchVocabularies(user.getCompanyId(), new long[]{groupId}, title, null, start, end, sort);
        ArrayList<AssetVocabulary> vocabularies = baseModelSearchResult.getBaseModels();
        int total = baseModelSearchResult.getLength();
        if (addDefaultVocabulary && total == 0 && (total = this.assetVocabularyPersistence.countByGroupId(groupId)) == 0) {
            vocabularies = new ArrayList<AssetVocabulary>(1);
            AssetVocabulary defaultVocabulary = this.assetVocabularyLocalService.addDefaultVocabulary(groupId);
            vocabularies.add(defaultVocabulary);
            total = 1;
        }
        return new AssetVocabularyDisplay((List)vocabularies, total, start, end);
    }

    public AssetVocabulary updateVocabulary(long vocabularyId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings) throws PortalException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "UPDATE");
        return this.assetVocabularyLocalService.updateVocabulary(vocabularyId, titleMap, descriptionMap, settings);
    }

    public AssetVocabulary updateVocabulary(long vocabularyId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, int visibilityType) throws PortalException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "UPDATE");
        return this.assetVocabularyLocalService.updateVocabulary(vocabularyId, titleMap, descriptionMap, settings, visibilityType);
    }

    public AssetVocabulary updateVocabulary(long vocabularyId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "UPDATE");
        return this.assetVocabularyLocalService.updateVocabulary(vocabularyId, title, titleMap, descriptionMap, settings, serviceContext);
    }
}

