/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalService;
import com.liferay.document.library.kernel.service.persistence.DLFileShortcutPersistence;
import com.liferay.document.library.kernel.service.persistence.DLFileVersionPersistence;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.messaging.async.Async;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.RepositoryEventTriggerCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.event.WorkflowRepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portlet.documentlibrary.service.base.DLAppHelperLocalServiceBaseImpl;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DLAppHelperLocalServiceImpl
extends DLAppHelperLocalServiceBaseImpl {
    @BeanReference(type=AssetCategoryLocalService.class)
    private AssetCategoryLocalService _assetCategoryLocalService;
    @BeanReference(type=AssetEntryLocalService.class)
    private AssetEntryLocalService _assetEntryLocalService;
    @BeanReference(type=AssetLinkLocalService.class)
    private AssetLinkLocalService _assetLinkLocalService;
    @BeanReference(type=AssetTagLocalService.class)
    private AssetTagLocalService _assetTagLocalService;
    @BeanReference(type=DLAppService.class)
    private DLAppService _dlAppService;
    @BeanReference(type=DLFileEntryLocalService.class)
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @BeanReference(type=DLFileShortcutLocalService.class)
    private DLFileShortcutLocalService _dlFileShortcutLocalService;
    @BeanReference(type=DLFileShortcutPersistence.class)
    private DLFileShortcutPersistence _dlFileShortcutPersistence;
    @BeanReference(type=DLFileVersionPersistence.class)
    private DLFileVersionPersistence _dlFileVersionPersistence;
    @BeanReference(type=RatingsStatsLocalService.class)
    private RatingsStatsLocalService _ratingsStatsLocalService;

    public void addFolder(long userId, Folder folder, ServiceContext serviceContext) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
    }

    public void cancelCheckOut(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, FileVersion draftFileVersion, ServiceContext serviceContext) throws PortalException {
        if (draftFileVersion == null) {
            return;
        }
        AssetEntry draftAssetEntry = this._assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), draftFileVersion.getPrimaryKey());
        if (draftAssetEntry != null) {
            this._assetEntryLocalService.deleteEntry(draftAssetEntry);
        }
    }

    public void cancelCheckOuts(long groupId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getCancelCheckOutsActionableDynamicQuery(groupId);
        actionableDynamicQuery.performActions();
    }

    public void checkAssetEntry(long userId, FileEntry fileEntry, FileVersion fileVersion) throws PortalException {
        AssetEntry fileVersionAssetEntry;
        AssetEntry fileEntryAssetEntry = this._assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        long[] assetCategoryIds = new long[]{};
        String[] assetTagNames = new String[]{};
        long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
        if (fileEntryAssetEntry == null) {
            fileEntryAssetEntry = this._assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, false, null, null, null, fileEntry.getExpirationDate(), fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null);
        }
        if ((fileVersionAssetEntry = this._assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId())) != null || fileVersion.isApproved()) {
            return;
        }
        String version = fileVersion.getVersion();
        if (version.equals("1.0")) {
            return;
        }
        assetCategoryIds = this._assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        assetTagNames = this._assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        fileVersionAssetEntry = this._assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, false, null, null, null, fileEntry.getExpirationDate(), fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null);
        List assetLinks = this._assetLinkLocalService.getDirectLinks(fileEntryAssetEntry.getEntryId(), false);
        long[] assetLinkIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        this._assetLinkLocalService.updateLinks(userId, fileVersionAssetEntry.getEntryId(), assetLinkIds, 0);
    }

    public void deleteFileEntry(FileEntry fileEntry) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this._deleteFileEntry(fileEntry.getFileEntryId());
    }

    public void deleteFolder(Folder folder) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this._assetEntryLocalService.deleteEntry(DLFolderConstants.getClassName(), folder.getFolderId());
    }

    public void deleteRepositoryFileEntries(long repositoryId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._dlFileEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"repositoryId", (Object)repositoryId)));
        actionableDynamicQuery.setPerformActionMethod(dlFileEntry -> this._deleteFileEntry(dlFileEntry.getFileEntryId()));
    }

    public long getCheckedOutFileEntriesCount(long groupId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getCancelCheckOutsActionableDynamicQuery(groupId);
        return actionableDynamicQuery.performCount();
    }

    public void getFileAsStream(long userId, FileEntry fileEntry, boolean incrementCounter) {
        if (!incrementCounter) {
            return;
        }
        this._assetEntryLocalService.incrementViewCounter(fileEntry.getCompanyId(), userId, DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 1);
        List fileShortcuts = this._dlFileShortcutPersistence.findByToFileEntryId(fileEntry.getFileEntryId());
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this._assetEntryLocalService.incrementViewCounter(fileEntry.getCompanyId(), userId, DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId(), 1);
        }
    }

    public List<DLFileShortcut> getFileShortcuts(long groupId, long folderId, boolean active, int status) {
        return this._dlFileShortcutPersistence.findByG_F_A_S(groupId, folderId, active, status);
    }

    public int getFileShortcutsCount(long groupId, long folderId, boolean active, int status) {
        return this._dlFileShortcutPersistence.countByG_F_A_S(groupId, folderId, active, status);
    }

    public List<FileEntry> getNoAssetFileEntries() {
        return null;
    }

    public void moveDependentsToTrash(DLFolder dlFolder) throws PortalException {
    }

    public FileEntry moveFileEntryFromTrash(long userId, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException {
        return null;
    }

    public FileEntry moveFileEntryToTrash(long userId, FileEntry fileEntry) throws PortalException {
        return null;
    }

    public FileShortcut moveFileShortcutFromTrash(long userId, FileShortcut fileShortcut, long newFolderId, ServiceContext serviceContext) throws PortalException {
        return null;
    }

    public FileShortcut moveFileShortcutToTrash(long userId, FileShortcut fileShortcut) throws PortalException {
        return null;
    }

    public Folder moveFolderFromTrash(long userId, Folder folder, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        return null;
    }

    public Folder moveFolderToTrash(long userId, Folder folder) throws PortalException {
        return null;
    }

    @Async
    public void reindex(long companyId, List<Long> dlFileEntryIds) throws PortalException {
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor(dlFileEntryIds.size());
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List sublist = dlFileEntryIds.subList(start, end);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
            IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._dlFileEntryLocalService.getIndexableActionableDynamicQuery();
            indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Property dlFileEntryId = PropertyFactoryUtil.forName((String)"fileEntryId");
                dynamicQuery.add(dlFileEntryId.in((Collection)sublist));
            });
            indexableActionableDynamicQuery.setCompanyId(companyId);
            indexableActionableDynamicQuery.setPerformActionMethod(dlFileEntry -> indexableActionableDynamicQuery.addDocuments(new Document[]{indexer.getDocument(dlFileEntry)}));
            indexableActionableDynamicQuery.performActions();
            intervalActionProcessor.incrementStart(sublist.size());
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    public void restoreDependentsFromTrash(DLFolder dlFolder) throws PortalException {
    }

    public void restoreFileEntryFromTrash(long userId, FileEntry fileEntry) throws PortalException {
    }

    public void restoreFileEntryFromTrash(long userId, long newFolderId, FileEntry fileEntry) throws PortalException {
    }

    public void restoreFileShortcutFromTrash(long userId, FileShortcut fileShortcut) throws PortalException {
    }

    public void restoreFolderFromTrash(long userId, Folder folder) throws PortalException {
    }

    public AssetEntry updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long assetClassPK) throws PortalException {
        long[] assetCategoryIds = this._assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), assetClassPK);
        String[] assetTagNames = this._assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), assetClassPK);
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), assetClassPK);
        List assetLinks = null;
        if (assetEntry != null) {
            assetLinks = this._assetLinkLocalService.getDirectLinks(assetEntry.getEntryId(), false);
        }
        long[] assetLinkIds = ListUtil.toLongArray(assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetLinkEntryIds(assetLinkIds);
        serviceContext.setAssetTagNames(assetTagNames);
        return this.updateAsset(userId, fileEntry, fileVersion, serviceContext);
    }

    public AssetEntry updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, ServiceContext serviceContext) throws PortalException {
        AssetEntry assetEntry = null;
        boolean visible = false;
        boolean addDraftAssetEntry = false;
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileVersion dlFileVersion = (DLFileVersion)fileVersion.getModel();
            if (dlFileVersion.isApproved()) {
                visible = true;
            } else {
                String version = dlFileVersion.getVersion();
                if (!version.equals("1.0")) {
                    addDraftAssetEntry = true;
                }
            }
        } else {
            visible = true;
        }
        long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
        if (addDraftAssetEntry) {
            if (serviceContext.getAssetCategoryIds() == null) {
                serviceContext.setAssetCategoryIds(this._assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId()));
            }
            if (serviceContext.getAssetTagNames() == null) {
                serviceContext.setAssetTagNames(this._assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId()));
            }
            if (serviceContext.getAssetLinkEntryIds() == null) {
                AssetEntry previousAssetEntry = this._assetEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
                List assetLinks = this._assetLinkLocalService.getDirectLinks(previousAssetEntry.getEntryId(), 0, false);
                serviceContext.setAssetLinkEntryIds(ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR));
            }
            assetEntry = this._assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId(), fileEntry.getUuid(), fileEntryTypeId, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), true, false, null, null, null, fileEntry.getExpirationDate(), fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, serviceContext);
        } else {
            Date publishDate = null;
            if (visible) {
                publishDate = fileEntry.getCreateDate();
            }
            assetEntry = this._assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), true, visible, null, null, publishDate, fileEntry.getExpirationDate(), fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, serviceContext);
            List dlFileShortcuts = this._dlFileShortcutPersistence.findByToFileEntryId(fileEntry.getFileEntryId());
            for (DLFileShortcut dlFileShortcut : dlFileShortcuts) {
                this._assetEntryLocalService.updateEntry(userId, dlFileShortcut.getGroupId(), dlFileShortcut.getCreateDate(), dlFileShortcut.getModifiedDate(), DLFileShortcutConstants.getClassName(), dlFileShortcut.getFileShortcutId(), dlFileShortcut.getUuid(), fileEntryTypeId, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), true, true, null, null, dlFileShortcut.getCreateDate(), null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, serviceContext);
            }
        }
        this._assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), serviceContext.getAssetLinkEntryIds(), 0);
        return assetEntry;
    }

    public AssetEntry updateAsset(long userId, Folder folder, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        boolean visible = false;
        if (folder instanceof LiferayFolder) {
            DLFolder dlFolder = (DLFolder)folder.getModel();
            if (dlFolder.isApproved() && !dlFolder.isHidden() && !dlFolder.isInHiddenFolder()) {
                visible = true;
            }
        } else {
            visible = true;
        }
        Date publishDate = null;
        if (visible) {
            publishDate = folder.getCreateDate();
        }
        AssetEntry assetEntry = this._assetEntryLocalService.updateEntry(userId, folder.getGroupId(), folder.getCreateDate(), folder.getModifiedDate(), DLFolderConstants.getClassName(), folder.getFolderId(), folder.getUuid(), 0L, assetCategoryIds, assetTagNames, true, visible, null, null, publishDate, null, null, folder.getName(), folder.getDescription(), null, null, null, 0, 0, null);
        this._assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
        return assetEntry;
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, long assetClassPK) throws PortalException {
        String version;
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        boolean updateAsset = true;
        if (fileEntry instanceof LiferayFileEntry && (version = fileEntry.getVersion()).equals(destinationFileVersion.getVersion())) {
            updateAsset = false;
        }
        if (updateAsset) {
            this.updateAsset(userId, fileEntry, destinationFileVersion, assetClassPK);
        }
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, ServiceContext serviceContext) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        if (Objects.equals(serviceContext.getCommand(), "revert")) {
            List assetCategories = this._assetCategoryLocalService.getCategories(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            List assetCategoryIds = ListUtil.toList((List)assetCategories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
            serviceContext.setAssetCategoryIds(ArrayUtil.toLongArray((Collection)assetCategoryIds));
        }
        this.updateAsset(userId, fileEntry, destinationFileVersion, serviceContext);
    }

    public void updateFolder(long userId, Folder folder, ServiceContext serviceContext) throws PortalException {
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
    }

    public void updateStatus(long userId, FileEntry fileEntry, FileVersion latestFileVersion, int oldStatus, int newStatus, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        if (newStatus == 0) {
            String event;
            String latestFileVersionVersion = latestFileVersion.getVersion();
            if (latestFileVersionVersion.equals(fileEntry.getVersion())) {
                AssetEntry assetEntry;
                AssetEntry draftAssetEntry;
                if (!latestFileVersionVersion.equals("1.0") && (draftAssetEntry = this._assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), latestFileVersion.getPrimaryKey())) != null) {
                    long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
                    long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                    String[] assetTagNames = draftAssetEntry.getTagNames();
                    List assetLinks = this._assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0, false);
                    long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
                    AssetEntry assetEntry2 = this._assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, true, null, null, fileEntry.getCreateDate(), fileEntry.getExpirationDate(), draftAssetEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null);
                    this._assetLinkLocalService.updateLinks(userId, assetEntry2.getEntryId(), assetLinkEntryIds, 0);
                    this._assetEntryLocalService.deleteEntry(draftAssetEntry);
                }
                if ((assetEntry = this._assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId())) != null) {
                    this._assetEntryLocalService.updateEntry(assetEntry.getClassName(), assetEntry.getClassPK(), assetEntry.getCreateDate(), assetEntry.getExpirationDate(), assetEntry.isListable(), true);
                }
            }
            if (Validator.isNotNull((String)(event = GetterUtil.getString((Object)workflowContext.get("event"))))) {
                this.triggerRepositoryEvent(fileEntry.getRepositoryId(), this.getWorkflowRepositoryEventTypeClass(event), FileEntry.class, fileEntry);
            }
            if (oldStatus != 8 && !fileEntry.isInTrash()) {
                Date activityCreateDate = latestFileVersion.getModifiedDate();
                int activityType = 2;
                if (event.equals("add")) {
                    activityCreateDate = latestFileVersion.getCreateDate();
                    activityType = 1;
                }
                JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)fileEntry.getTitle());
                SocialActivityManagerUtil.addUniqueActivity((long)latestFileVersion.getStatusByUserId(), (Date)activityCreateDate, (ClassedModel)fileEntry, (int)activityType, (String)extraDataJSONObject.toString(), (long)0L);
            }
        } else {
            List approvedFileVersions;
            boolean visible = false;
            if (newStatus != 8 && !(approvedFileVersions = this._dlFileVersionPersistence.findByF_S(fileEntry.getFileEntryId(), 0)).isEmpty()) {
                visible = true;
            }
            this._assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), visible);
        }
    }

    protected ActionableDynamicQuery getCancelCheckOutsActionableDynamicQuery(long groupId) {
        ActionableDynamicQuery fileEntryActionableDynamicQuery = this._dlFileEntryLocalService.getActionableDynamicQuery();
        fileEntryActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property fileEntryIdProperty = PropertyFactoryUtil.forName((String)"fileEntryId");
            DynamicQuery fileVersionDynamicQuery = DynamicQueryFactoryUtil.forClass(DLFileVersion.class, (String)"dlFileVersion", (ClassLoader)PortalClassLoaderUtil.getClassLoader());
            fileVersionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"fileEntryId"));
            fileVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"dlFileVersion.fileEntryId", (String)"this.fileEntryId"));
            Property versionProperty = PropertyFactoryUtil.forName((String)"version");
            fileVersionDynamicQuery.add(versionProperty.eq((Object)"PWC"));
            dynamicQuery.add(fileEntryIdProperty.in(fileVersionDynamicQuery));
        });
        fileEntryActionableDynamicQuery.setGroupId(groupId);
        fileEntryActionableDynamicQuery.setPerformActionMethod(dlFileEntry -> this._dlAppService.cancelCheckOut(dlFileEntry.getFileEntryId()));
        return fileEntryActionableDynamicQuery;
    }

    protected long getFileEntryTypeId(FileEntry fileEntry) {
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
            return dlFileEntry.getFileEntryTypeId();
        }
        return 0L;
    }

    protected Class<? extends WorkflowRepositoryEventType> getWorkflowRepositoryEventTypeClass(String syncEvent) {
        if (syncEvent.equals("add")) {
            return WorkflowRepositoryEventType.Add.class;
        }
        if (syncEvent.equals("update")) {
            return WorkflowRepositoryEventType.Update.class;
        }
        throw new IllegalArgumentException(String.format("Unsupported sync event %s", syncEvent));
    }

    protected <T extends RepositoryModel<T>> void triggerRepositoryEvent(long repositoryId, Class<? extends RepositoryEventType> repositoryEventType, Class<T> modelClass, T target) throws PortalException {
        Repository repository = RepositoryProviderUtil.getRepository((long)repositoryId);
        if (repository.isCapabilityProvided(RepositoryEventTriggerCapability.class)) {
            RepositoryEventTriggerCapability repositoryEventTriggerCapability = (RepositoryEventTriggerCapability)repository.getCapability(RepositoryEventTriggerCapability.class);
            repositoryEventTriggerCapability.trigger(repositoryEventType, modelClass, target);
        }
    }

    private void _deleteFileEntry(long fileEntryId) throws PortalException {
        this._dlFileShortcutLocalService.deleteFileShortcuts(fileEntryId);
        this._assetEntryLocalService.deleteEntry(DLFileEntryConstants.getClassName(), fileEntryId);
        this._ratingsStatsLocalService.deleteStats(DLFileEntryConstants.getClassName(), fileEntryId);
    }

    private class DLSyncConstants {
        public static final String EVENT_ADD = "add";
        public static final String EVENT_UPDATE = "update";

        private DLSyncConstants() {
        }
    }
}

