/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.document.library.kernel.antivirus.AntivirusScannerUtil;
import com.liferay.document.library.kernel.exception.AccessDeniedException;
import com.liferay.document.library.kernel.exception.DirectoryNameException;
import com.liferay.document.library.kernel.store.DLStore;
import com.liferay.document.library.kernel.store.DLStoreRequest;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.ByteArrayFileInputStream;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DLStoreImpl
implements DLStore {
    private static volatile Store _store = (Store)ServiceProxyFactory.newServiceTrackedInstance(Store.class, DLStoreImpl.class, (String)"_store", (String)"(default=true)", (boolean)true);

    public static void setStore(Store store) {
        _store = store;
    }

    public void addFile(DLStoreRequest dlStoreRequest, byte[] bytes) throws PortalException {
        this.validate(dlStoreRequest.getFileName(), dlStoreRequest.isValidateFileExtension());
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((byte[])bytes);
        }
        _store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), (InputStream)new UnsyncByteArrayInputStream(bytes));
    }

    public void addFile(DLStoreRequest dlStoreRequest, File file) throws PortalException {
        this.validate(dlStoreRequest.getFileName(), dlStoreRequest.isValidateFileExtension());
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((File)file);
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            _store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), (InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public void addFile(DLStoreRequest dlStoreRequest, InputStream inputStream1) throws PortalException {
        block22: {
            if (inputStream1 instanceof ByteArrayFileInputStream) {
                ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)inputStream1;
                this.addFile(dlStoreRequest, byteArrayFileInputStream.getFile());
                return;
            }
            this.validate(dlStoreRequest.getFileName(), dlStoreRequest.isValidateFileExtension());
            if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED && AntivirusScannerUtil.isActive()) {
                File tempFile = null;
                try {
                    tempFile = FileUtil.createTempFile();
                    FileUtil.write((File)tempFile, (InputStream)inputStream1);
                    AntivirusScannerUtil.scan((File)tempFile);
                    try (FileInputStream inputStream2 = new FileInputStream(tempFile);){
                        _store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), (InputStream)inputStream2);
                        break block22;
                    }
                }
                catch (IOException ioException) {
                    throw new SystemException("Unable to scan file " + dlStoreRequest.getFileName(), (Throwable)ioException);
                }
                finally {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                }
            }
            try {
                _store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), inputStream1);
            }
            catch (AccessDeniedException accessDeniedException) {
                throw new PrincipalException((Throwable)accessDeniedException);
            }
        }
    }

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, byte[] bytes) throws PortalException {
        this.addFile(DLStoreRequest.builder((long)companyId, (long)repositoryId, (String)fileName).validateFileExtension(validateFileExtension).build(), bytes);
    }

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, File file) throws PortalException {
        this.addFile(DLStoreRequest.builder((long)companyId, (long)repositoryId, (String)fileName).validateFileExtension(validateFileExtension).build(), file);
    }

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, InputStream inputStream) throws PortalException {
        this.addFile(DLStoreRequest.builder((long)companyId, (long)repositoryId, (String)fileName).validateFileExtension(validateFileExtension).build(), inputStream);
    }

    public void addFile(long companyId, long repositoryId, String fileName, byte[] bytes) throws PortalException {
        this.addFile(DLStoreRequest.builder((long)companyId, (long)repositoryId, (String)fileName).validateFileExtension(true).build(), bytes);
    }

    public void addFile(long companyId, long repositoryId, String fileName, File file) throws PortalException {
        this.addFile(DLStoreRequest.builder((long)companyId, (long)repositoryId, (String)fileName).validateFileExtension(true).build(), file);
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream inputStream) throws PortalException {
        this.addFile(DLStoreRequest.builder((long)companyId, (long)repositoryId, (String)fileName).validateFileExtension(true).build(), inputStream);
    }

    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        InputStream inputStream = _store.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel);
        if (inputStream == null) {
            inputStream = new UnsyncByteArrayInputStream(new byte[0]);
        }
        _store.addFile(companyId, repositoryId, fileName, toVersionLabel, inputStream);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        _store.deleteDirectory(companyId, repositoryId, dirName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        for (String versionLabel : _store.getFileVersions(companyId, repositoryId, fileName)) {
            _store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        try {
            _store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new PrincipalException((Throwable)accessDeniedException);
        }
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        try {
            return StreamUtil.toByteArray((InputStream)_store.getFileAsStream(companyId, repositoryId, fileName, ""));
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        try {
            return StreamUtil.toByteArray((InputStream)_store.getFileAsStream(companyId, repositoryId, fileName, versionLabel));
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        return _store.getFileAsStream(companyId, repositoryId, fileName, "");
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        return _store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)dirName)) {
            throw new DirectoryNameException(dirName);
        }
        return _store.getFileNames(companyId, repositoryId, dirName);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        return _store.getFileSize(companyId, repositoryId, fileName, "");
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        return _store.hasFile(companyId, repositoryId, fileName, "1.0");
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        return _store.hasFile(companyId, repositoryId, fileName, versionLabel);
    }

    public void updateFile(DLStoreRequest dlStoreRequest, File file) throws PortalException {
        this.validate(dlStoreRequest.getFileName(), dlStoreRequest.getFileExtension(), dlStoreRequest.getSourceFileName(), dlStoreRequest.isValidateFileExtension());
        this._validateVersionLabel(dlStoreRequest.getVersionLabel());
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((File)file);
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            _store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), (InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public void updateFile(DLStoreRequest dlStoreRequest, InputStream inputStream1) throws PortalException {
        block23: {
            this.validate(dlStoreRequest.getFileName(), dlStoreRequest.getFileExtension(), dlStoreRequest.getSourceFileName(), dlStoreRequest.isValidateFileExtension());
            this._validateVersionLabel(dlStoreRequest.getVersionLabel());
            if (inputStream1 instanceof ByteArrayFileInputStream) {
                ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)inputStream1;
                if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
                    AntivirusScannerUtil.scan((File)byteArrayFileInputStream.getFile());
                }
                _store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), inputStream1);
                return;
            }
            if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED && AntivirusScannerUtil.isActive()) {
                File tempFile = null;
                try {
                    tempFile = FileUtil.createTempFile();
                    FileUtil.write((File)tempFile, (InputStream)inputStream1);
                    AntivirusScannerUtil.scan((File)tempFile);
                    try (FileInputStream inputStream = new FileInputStream(tempFile);){
                        _store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), (InputStream)inputStream);
                        break block23;
                    }
                }
                catch (IOException ioException) {
                    throw new SystemException("Unable to scan file " + dlStoreRequest.getFileName(), (Throwable)ioException);
                }
                finally {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                }
            }
            try {
                _store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), inputStream1);
            }
            catch (AccessDeniedException accessDeniedException) {
                throw new PrincipalException((Throwable)accessDeniedException);
            }
        }
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException {
        for (String versionLabel : _store.getFileVersions(companyId, repositoryId, fileName)) {
            _store.addFile(companyId, newRepositoryId, fileName, versionLabel, _store.getFileAsStream(companyId, repositoryId, fileName, versionLabel));
            _store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String fileExtension, boolean validateFileExtension, String versionLabel, String sourceFileName, File file) throws PortalException {
        this.updateFile(DLStoreRequest.builder((long)companyId, (long)repositoryId, (String)fileName).fileExtension(fileExtension).sourceFileName(sourceFileName).validateFileExtension(validateFileExtension).versionLabel(versionLabel).build(), file);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String fileExtension, boolean validateFileExtension, String versionLabel, String sourceFileName, InputStream inputStream1) throws PortalException {
        this.updateFile(DLStoreRequest.builder((long)companyId, (long)repositoryId, (String)fileName).fileExtension(fileExtension).sourceFileName(sourceFileName).validateFileExtension(validateFileExtension).versionLabel(versionLabel).build(), inputStream1);
    }

    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        InputStream inputStream = _store.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel);
        if (inputStream == null) {
            inputStream = new UnsyncByteArrayInputStream(new byte[0]);
        }
        _store.addFile(companyId, repositoryId, fileName, toVersionLabel, inputStream);
        _store.deleteFile(companyId, repositoryId, fileName, fromVersionLabel);
    }

    public void validate(String fileName, boolean validateFileExtension) throws PortalException {
        DLValidatorUtil.validateFileName((String)fileName);
        if (validateFileExtension) {
            DLValidatorUtil.validateFileExtension((String)fileName);
        }
    }

    public void validate(String fileName, boolean validateFileExtension, byte[] bytes) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((long)GroupThreadLocal.getGroupId(), (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (byte[])bytes);
    }

    public void validate(String fileName, boolean validateFileExtension, File file) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((long)GroupThreadLocal.getGroupId(), (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (File)file);
    }

    public void validate(String fileName, boolean validateFileExtension, InputStream inputStream) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((long)GroupThreadLocal.getGroupId(), (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (InputStream)inputStream);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateSourceFileExtension((String)fileExtension, (String)sourceFileName);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, File file) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((long)GroupThreadLocal.getGroupId(), (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (File)file);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, InputStream inputStream) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((long)GroupThreadLocal.getGroupId(), (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (InputStream)inputStream);
    }

    protected void validate(String fileName, boolean validateFileExtension, String versionLabel) throws PortalException {
        this.validate(fileName, validateFileExtension);
        this._validateVersionLabel(versionLabel);
    }

    protected void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, File file, String versionLabel) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension, file);
        this._validateVersionLabel(versionLabel);
    }

    protected void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, InputStream inputStream, String versionLabel) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension, inputStream);
        this._validateVersionLabel(versionLabel);
    }

    private void _validateVersionLabel(String versionLabel) throws PortalException {
        DLValidatorUtil.validateVersionLabel((String)StringUtil.removeLast((String)versionLabel, (String)".index"));
    }
}

