/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portlet.social.service.base.SocialRequestLocalServiceBaseImpl;
import com.liferay.social.kernel.exception.RequestUserIdException;
import com.liferay.social.kernel.model.SocialRequest;
import com.liferay.social.kernel.service.SocialRequestInterpreterLocalService;
import java.util.List;

public class SocialRequestLocalServiceImpl
extends SocialRequestLocalServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=SocialRequestInterpreterLocalService.class)
    private SocialRequestInterpreterLocalService _socialRequestInterpreterLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public SocialRequest addRequest(long userId, long groupId, String className, long classPK, int type, String extraData, long receiverUserId) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        User receiverUser = this._userPersistence.findByPrimaryKey(receiverUserId);
        long now = System.currentTimeMillis();
        if (userId == receiverUserId || user.isDefaultUser() || receiverUser.isDefaultUser() || user.getCompanyId() != receiverUser.getCompanyId()) {
            throw new RequestUserIdException();
        }
        long classNameId = this._classNameLocalService.getClassNameId(className);
        SocialRequest request = this.socialRequestPersistence.fetchByU_C_C_T_R(userId, classNameId, classPK, type, receiverUserId);
        if (request == null) {
            long requestId = this.counterLocalService.increment(SocialRequest.class.getName());
            request = this.socialRequestPersistence.create(requestId);
        }
        request.setGroupId(groupId);
        request.setCompanyId(user.getCompanyId());
        request.setUserId(user.getUserId());
        request.setCreateDate(now);
        request.setModifiedDate(now);
        request.setClassNameId(classNameId);
        request.setClassPK(classPK);
        request.setType(type);
        request.setExtraData(extraData);
        request.setReceiverUserId(receiverUserId);
        request.setStatus(3);
        return (SocialRequest)this.socialRequestPersistence.update((BaseModel)request);
    }

    public void deleteReceiverUserRequests(long receiverUserId) {
        List requests = this.socialRequestPersistence.findByReceiverUserId(receiverUserId);
        for (SocialRequest request : requests) {
            this.deleteRequest(request);
        }
    }

    public void deleteRequest(long requestId) throws PortalException {
        SocialRequest request = this.socialRequestPersistence.findByPrimaryKey(requestId);
        this.deleteRequest(request);
    }

    public void deleteRequest(SocialRequest request) {
        this.socialRequestPersistence.remove((BaseModel)request);
    }

    public void deleteRequests(long className, long classPK) {
        List requests = this.socialRequestPersistence.findByC_C(className, classPK);
        for (SocialRequest request : requests) {
            this.deleteRequest(request);
        }
    }

    public void deleteUserRequests(long userId) {
        List requests = this.socialRequestPersistence.findByUserId(userId);
        for (SocialRequest request : requests) {
            this.deleteRequest(request);
        }
    }

    public List<SocialRequest> getReceiverUserRequests(long receiverUserId, int start, int end) {
        return this.socialRequestPersistence.findByReceiverUserId(receiverUserId, start, end);
    }

    public List<SocialRequest> getReceiverUserRequests(long receiverUserId, int status, int start, int end) {
        return this.socialRequestPersistence.findByR_S(receiverUserId, status, start, end);
    }

    public int getReceiverUserRequestsCount(long receiverUserId) {
        return this.socialRequestPersistence.countByReceiverUserId(receiverUserId);
    }

    public int getReceiverUserRequestsCount(long receiverUserId, int status) {
        return this.socialRequestPersistence.countByR_S(receiverUserId, status);
    }

    public List<SocialRequest> getUserRequests(long userId, int start, int end) {
        return this.socialRequestPersistence.findByUserId(userId, start, end);
    }

    public List<SocialRequest> getUserRequests(long userId, int status, int start, int end) {
        return this.socialRequestPersistence.findByU_S(userId, status, start, end);
    }

    public int getUserRequestsCount(long userId) {
        return this.socialRequestPersistence.countByUserId(userId);
    }

    public int getUserRequestsCount(long userId, int status) {
        return this.socialRequestPersistence.countByU_S(userId, status);
    }

    public boolean hasRequest(long userId, String className, long classPK, int type, int status) {
        int count = this.socialRequestPersistence.countByU_C_C_T_S(userId, this._classNameLocalService.getClassNameId(className), classPK, type, status);
        return count > 0;
    }

    public boolean hasRequest(long userId, String className, long classPK, int type, long receiverUserId, int status) {
        SocialRequest socialRequest = this.socialRequestPersistence.fetchByU_C_C_T_R(userId, this._classNameLocalService.getClassNameId(className), classPK, type, receiverUserId);
        return socialRequest != null && socialRequest.getStatus() == status;
    }

    public SocialRequest updateRequest(long requestId, int status, ThemeDisplay themeDisplay) throws PortalException {
        SocialRequest request = this.socialRequestPersistence.findByPrimaryKey(requestId);
        request.setModifiedDate(System.currentTimeMillis());
        request.setStatus(status);
        request = (SocialRequest)this.socialRequestPersistence.update((BaseModel)request);
        if (status == 1) {
            this._socialRequestInterpreterLocalService.processConfirmation(request, themeDisplay);
        } else if (status == 2) {
            this._socialRequestInterpreterLocalService.processRejection(request, themeDisplay);
        }
        return request;
    }
}

