/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.setup.SetupWizardUtil;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SetupWizardAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(SetupWizardAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!PropsValues.SETUP_WIZARD_ENABLED) {
            httpServletResponse.sendRedirect(themeDisplay.getPathMain());
        }
        String cmd = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"cmd");
        try {
            if (Validator.isNull((String)cmd)) {
                return actionMapping.getActionForward("portal.setup_wizard");
            }
            if (cmd.equals("translate")) {
                SetupWizardUtil.updateLanguage(httpServletRequest, httpServletResponse);
                return actionMapping.getActionForward("portal.setup_wizard");
            }
            if (cmd.equals("test")) {
                this.testDatabase(httpServletRequest, httpServletResponse);
                return null;
            }
            if (cmd.equals("update")) {
                SetupWizardUtil.updateSetup(httpServletRequest, httpServletResponse);
                if (ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"defaultDatabase")) {
                    PropsValues.SETUP_WIZARD_ENABLED = false;
                }
            }
            httpServletResponse.sendRedirect(themeDisplay.getPathMain() + "/portal/setup_wizard");
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof PrincipalException) {
                SessionErrors.add((HttpServletRequest)httpServletRequest, exception.getClass());
                return actionMapping.getActionForward("portal.setup_wizard");
            }
            PortalUtil.sendError((Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return null;
        }
    }

    protected void putMessage(HttpServletRequest httpServletRequest, JSONObject jsonObject, String key, Object ... arguments) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String message = themeDisplay.translate(key, arguments);
        jsonObject.put("message", message);
    }

    protected void testDatabase(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            SetupWizardUtil.testDatabase(httpServletRequest);
            jsonObject.put("success", true);
            this.putMessage(httpServletRequest, jsonObject, "database-connection-was-established-successfully", new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.putMessage(httpServletRequest, jsonObject, "database-driver-x-is-not-present", classNotFoundException.getLocalizedMessage());
        }
        catch (SQLException sqlException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sqlException, (Throwable)sqlException);
            }
            this.putMessage(httpServletRequest, jsonObject, "database-connection-could-not-be-established", new Object[0]);
        }
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)jsonObject.toString());
    }
}

