/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.FriendlyURLResolverRegistryUtil;
import com.liferay.portal.kernel.portlet.LayoutFriendlyURLSeparatorComposite;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.admin.util.AdminUtil;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UpdateLanguageAction
implements Action {
    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String languageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"languageId");
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        if (LanguageUtil.isAvailableLocale((long)themeDisplay.getSiteGroupId(), (Locale)locale)) {
            boolean persistState = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"persistState", (boolean)true);
            if (themeDisplay.isSignedIn() && persistState) {
                User user = themeDisplay.getUser();
                Contact contact = user.getContact();
                AdminUtil.updateUser(httpServletRequest, user.getUserId(), user.getScreenName(), user.getEmailAddress(), user.getFacebookId(), user.getOpenId(), languageId, user.getTimeZoneId(), user.getGreeting(), user.getComments(), contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn());
            }
            HttpSession session = httpServletRequest.getSession();
            session.setAttribute("LOCALE", (Object)locale);
            LanguageUtil.updateCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Locale)locale);
        }
        httpServletResponse.sendRedirect(this.getRedirect(httpServletRequest, themeDisplay, locale));
        return null;
    }

    public String getRedirect(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, Locale locale) throws PortalException {
        String i18nPath;
        String redirect;
        String layoutURL = redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect"));
        String friendlyURLSeparatorPart = "";
        String queryString = "";
        int questionIndex = redirect.indexOf("?");
        if (questionIndex != -1) {
            queryString = redirect.substring(questionIndex);
            layoutURL = redirect.substring(0, questionIndex);
        }
        String friendlyURLSeparator = "";
        int friendlyURLSeparatorIndex = -1;
        for (String urlSeparator : FriendlyURLResolverRegistryUtil.getURLSeparators()) {
            if ("/~".equals(urlSeparator) || (friendlyURLSeparatorIndex = layoutURL.indexOf(urlSeparator)) == -1) continue;
            friendlyURLSeparator = urlSeparator;
            break;
        }
        Layout layout = themeDisplay.getLayout();
        if (friendlyURLSeparatorIndex != -1) {
            block14: {
                friendlyURLSeparatorPart = layoutURL.substring(friendlyURLSeparatorIndex);
                try {
                    LayoutFriendlyURLSeparatorComposite layoutFriendlyURLSeparatorComposite = PortalUtil.getLayoutFriendlyURLSeparatorComposite((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (String)friendlyURLSeparatorPart, (Map)httpServletRequest.getParameterMap(), (Map)HashMapBuilder.put((Object)"request", (Object)httpServletRequest).build());
                    friendlyURLSeparatorPart = layoutFriendlyURLSeparatorComposite.getFriendlyURL();
                }
                catch (NoSuchLayoutException noSuchLayoutException) {
                    if ("/-/".equals(friendlyURLSeparator)) break block14;
                    throw noSuchLayoutException;
                }
            }
            layoutURL = layoutURL.substring(0, friendlyURLSeparatorIndex);
        }
        if (themeDisplay.isI18n() && layoutURL.startsWith(i18nPath = themeDisplay.getI18nPath())) {
            layoutURL = layoutURL.substring(i18nPath.length());
        }
        if (this.isFriendlyURLResolver(layoutURL) || layout.isTypeControlPanel()) {
            redirect = layoutURL + friendlyURLSeparatorPart;
        } else if (layoutURL.equals("/") || this.isGroupFriendlyURL(layout.getGroup(), layout, layoutURL, locale)) {
            redirect = PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0 ? layoutURL : PortalUtil.getGroupFriendlyURL((LayoutSet)layout.getLayoutSet(), (ThemeDisplay)themeDisplay, (Locale)locale);
            if (!redirect.endsWith("/") && !friendlyURLSeparatorPart.startsWith("/")) {
                redirect = redirect + "/";
            }
            if (Validator.isNotNull((String)friendlyURLSeparatorPart)) {
                redirect = redirect + friendlyURLSeparatorPart;
            }
        } else {
            redirect = PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0 ? PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay, (Locale)locale) : PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay, (Locale)locale);
            if (Validator.isNotNull((String)friendlyURLSeparatorPart)) {
                redirect = redirect + friendlyURLSeparatorPart;
            }
        }
        if (Validator.isNotNull((String)queryString)) {
            redirect = redirect + queryString;
        }
        return redirect;
    }

    protected boolean isFriendlyURLResolver(String layoutURL) {
        String[] urlSeparators;
        for (String urlSeparator : urlSeparators = FriendlyURLResolverRegistryUtil.getURLSeparators()) {
            if (!layoutURL.contains(urlSeparator)) continue;
            return true;
        }
        return false;
    }

    protected boolean isGroupFriendlyURL(Group group, Layout layout, String layoutURL, Locale locale) {
        if (Validator.isNull((String)layoutURL)) {
            return true;
        }
        int pos = layoutURL.lastIndexOf(47);
        String layoutURLLanguageId = layoutURL.substring(pos + 1);
        Locale layoutURLLocale = LocaleUtil.fromLanguageId((String)layoutURLLanguageId, (boolean)true, (boolean)false);
        if (layoutURLLocale != null) {
            return true;
        }
        return PortalUtil.isGroupFriendlyURL((String)layoutURL, (String)group.getFriendlyURL(), (String)layout.getFriendlyURL(locale));
    }
}

