/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PostgreSQLDB
extends BaseDB {
    private static final String[] _POSTGRESQL = new String[]{"--", "true", "false", "'01/01/1970'", "current_timestamp", " oid", " bytea", " bool", " timestamp", " double precision", " integer", " bigint", " text", " text", " varchar", "", "commit"};
    private static final int[] _SQL_TYPES = new int[]{-5, -2, -7, 93, 8, 4, -5, 12, 12, 12};
    private static final boolean _SUPPORTS_QUERYING_AFTER_EXCEPTION = false;

    public static String getCreateRulesSQL(String tableName, String columnName) {
        StringBundler sb = new StringBundler(45);
        sb.append("create or replace rule delete_");
        sb.append(tableName);
        sb.append("_");
        sb.append(columnName);
        sb.append(" as on delete to ");
        sb.append(tableName);
        sb.append(" do also select case when exists(select 1 from ");
        sb.append("pg_catalog.pg_largeobject_metadata where (oid = old.");
        sb.append(columnName);
        sb.append(")) then lo_unlink(old.");
        sb.append(columnName);
        sb.append(") end from ");
        sb.append(tableName);
        sb.append(" where ");
        sb.append(tableName);
        sb.append(".");
        sb.append(columnName);
        sb.append(" = old.");
        sb.append(columnName);
        sb.append(";\ncreate or replace rule update_");
        sb.append(tableName);
        sb.append("_");
        sb.append(columnName);
        sb.append(" as on update to ");
        sb.append(tableName);
        sb.append(" where old.");
        sb.append(columnName);
        sb.append(" is distinct from new.");
        sb.append(columnName);
        sb.append(" and old.");
        sb.append(columnName);
        sb.append(" is not null do also select case when exists(select 1 ");
        sb.append("from pg_catalog.pg_largeobject_metadata where (oid = old.");
        sb.append(columnName);
        sb.append(")) then lo_unlink(old.");
        sb.append(columnName);
        sb.append(") end from ");
        sb.append(tableName);
        sb.append(" where ");
        sb.append(tableName);
        sb.append(".");
        sb.append(columnName);
        sb.append(" = old.");
        sb.append(columnName);
        sb.append(";");
        return sb.toString();
    }

    public PostgreSQLDB(int majorVersion, int minorVersion) {
        super(DBType.POSTGRESQL, majorVersion, minorVersion);
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.replaceTemplate(template);
        template = this.reword(template);
        return template;
    }

    @Override
    public List<Index> getIndexes(Connection connection) throws SQLException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        StringBundler sb = new StringBundler(3);
        sb.append("select indexname, tablename, indexdef from pg_indexes ");
        sb.append("where schemaname = current_schema() and (indexname like ");
        sb.append("'liferay_%' or indexname like 'ix_%')");
        String sql = sb.toString();
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String indexName = resultSet.getString("indexname");
                String tableName = resultSet.getString("tablename");
                String indexSQL = StringUtil.toLowerCase((String)StringUtil.trim((String)resultSet.getString("indexdef")));
                boolean unique = true;
                if (indexSQL.startsWith("create index ")) {
                    unique = false;
                }
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        return indexes;
    }

    public String getPopulateSQL(String databaseName, String sqlContent) {
        StringBundler sb = new StringBundler(4);
        sb.append("\\c ");
        sb.append(databaseName);
        sb.append(";\n\n");
        sb.append(sqlContent);
        return sb.toString();
    }

    public String getRecreateSQL(String databaseName) {
        StringBundler sb = new StringBundler(6);
        sb.append("drop database ");
        sb.append(databaseName);
        sb.append(";\n");
        sb.append("create database ");
        sb.append(databaseName);
        sb.append(" encoding = 'UNICODE';\n");
        return sb.toString();
    }

    @Override
    public boolean isSupportsQueryingAfterException() {
        return false;
    }

    @Override
    protected int[] getSQLTypes() {
        return _SQL_TYPES;
    }

    @Override
    protected String[] getTemplate() {
        return _POSTGRESQL;
    }

    @Override
    protected String reword(String data) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            StringBundler createRulesSQLSB = new StringBundler();
            String line = null;
            String tableName = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] tokens;
                String[] template;
                if (line.startsWith("alter_column_name ")) {
                    template = this.buildColumnNameTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ rename @old-column@ to @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
                } else if (line.startsWith("alter_column_type ")) {
                    template = this.buildColumnTypeTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ alter @old-column@ type @type@ using @old-column@::@type@;", (String[])REWORD_TEMPLATE, (String[])template);
                    String nullable = template[template.length - 1];
                    if (!Validator.isBlank((String)nullable)) {
                        line = nullable.equals("not null") ? line.concat(StringUtil.replace((String)"alter table @table@ alter column @old-column@ set not null;", (String[])REWORD_TEMPLATE, (String[])template)) : line.concat(StringUtil.replace((String)"alter table @table@ alter column @old-column@ drop not null;", (String[])REWORD_TEMPLATE, (String[])template));
                    }
                } else if (line.startsWith("alter_table_name ")) {
                    template = this.buildTableNameTokens(line);
                    line = StringUtil.replace((String)"alter table @old-table@ rename to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
                } else if (line.startsWith("create table ")) {
                    tokens = StringUtil.split((String)line, (char)' ');
                    tableName = tokens[2];
                } else if (line.contains("drop index")) {
                    tokens = StringUtil.split((String)line, (char)' ');
                    line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
                } else if (line.contains("drop primary key")) {
                    tokens = StringUtil.split((String)line, (char)' ');
                    line = StringUtil.replace((String)"alter table @table@ drop constraint @table@_pkey;", (String)"@table@", (String)tokens[2]);
                } else if (line.contains(this.getTemplateBlob())) {
                    tokens = StringUtil.split((String)line, (char)' ');
                    createRulesSQLSB.append("\n");
                    createRulesSQLSB.append(PostgreSQLDB.getCreateRulesSQL(tableName, tokens[0]));
                } else if (line.contains("\\'")) {
                    line = StringUtil.replace((String)line, (String)"\\'", (String)"''");
                }
                sb.append(line);
                sb.append("\n");
            }
            sb.append(createRulesSQLSB.toString());
            String string = sb.toString();
            return string;
        }
    }
}

