/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.deploy.hot.CustomJspBag;
import com.liferay.portal.deploy.hot.DuplicateCustomJspException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.SanitizerLogWrapper;
import com.liferay.portal.kernel.url.URLContainer;
import com.liferay.portal.kernel.util.CustomJspRegistryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CustomJspBagRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(CustomJspBagRegistryUtil.class);
    private static final CustomJspBagRegistryUtil _customJspBagRegistryUtil = new CustomJspBagRegistryUtil();
    private final Map<ServiceReference<CustomJspBag>, CustomJspBag> _customJspBagsMap = new ConcurrentHashMap<ServiceReference<CustomJspBag>, CustomJspBag>();
    private final ServiceTracker<CustomJspBag, CustomJspBag> _serviceTracker;

    public static Map<ServiceReference<CustomJspBag>, CustomJspBag> getCustomJspBags() {
        return Collections.unmodifiableMap(CustomJspBagRegistryUtil._customJspBagRegistryUtil._customJspBagsMap);
    }

    protected InputStream getCustomJspInputStream(URLContainer urlContainer, String customJsp) throws IOException {
        URL url = urlContainer.getResource(customJsp);
        return url.openStream();
    }

    protected void getCustomJsps(URLContainer urlContainer, String resourcePath, List<String> customJsps) {
        Set resourcePaths = urlContainer.getResources(resourcePath);
        if (resourcePaths == null || resourcePaths.isEmpty()) {
            return;
        }
        for (String curResourcePath : resourcePaths) {
            if (curResourcePath.endsWith("/")) {
                this.getCustomJsps(urlContainer, curResourcePath, customJsps);
                continue;
            }
            String customJsp = curResourcePath;
            customJsp = StringUtil.replace((String)customJsp, (String)"//", (String)"/");
            customJsps.add(customJsp);
        }
    }

    protected String getPortalJsp(String customJsp, String customJspDir) {
        if (Validator.isNull((String)customJsp) || Validator.isNull((String)customJspDir)) {
            return null;
        }
        int pos = customJsp.indexOf(customJspDir);
        return customJsp.substring(pos + customJspDir.length());
    }

    protected File getPortalJspBackupFile(File portalJspFile) {
        String fileName = portalJspFile.getName();
        String filePath = portalJspFile.toString();
        int fileNameIndex = fileName.lastIndexOf(46);
        if (fileNameIndex > 0) {
            int filePathIndex = filePath.lastIndexOf(fileName);
            fileName = fileName.substring(0, fileNameIndex) + ".portal" + fileName.substring(fileNameIndex);
            filePath = filePath.substring(0, filePathIndex) + fileName;
        } else {
            filePath = filePath + ".portal";
        }
        return new File(filePath);
    }

    protected void initCustomJspBag(String contextId, String contextName, CustomJspBag customJspBag) throws Exception {
        String customJspDir = customJspBag.getCustomJspDir();
        boolean customJspGlobal = customJspBag.isCustomJspGlobal();
        List<String> customJsps = customJspBag.getCustomJsps();
        String portalWebDir = PortalUtil.getPortalWebDir();
        for (String customJsp : customJsps) {
            String portalJsp = this.getPortalJsp(customJsp, customJspDir);
            if (customJspGlobal) {
                File portalJspFile = new File(portalWebDir + portalJsp);
                File portalJspBackupFile = this.getPortalJspBackupFile(portalJspFile);
                if (portalJspFile.exists() && !portalJspBackupFile.exists()) {
                    FileUtil.copyFile((File)portalJspFile, (File)portalJspBackupFile);
                }
            } else {
                portalJsp = CustomJspRegistryUtil.getCustomJspFileName((String)contextId, (String)portalJsp);
            }
            FileUtil.write((String)(portalWebDir + portalJsp), (InputStream)this.getCustomJspInputStream(customJspBag.getURLContainer(), customJsp));
        }
        if (!customJspGlobal) {
            CustomJspRegistryUtil.registerServletContextName((String)contextId, (String)contextName);
        }
    }

    protected void verifyCustomJsps(String contextId, CustomJspBag customJspBag) throws DuplicateCustomJspException {
        HashSet<String> customJsps = new HashSet<String>();
        for (String string : customJspBag.getCustomJsps()) {
            String string2 = this.getPortalJsp(string, customJspBag.getCustomJspDir());
            customJsps.add(string2);
        }
        HashMap<String, String> conflictingCustomJsps = new HashMap<String, String>();
        for (Map.Entry<ServiceReference<CustomJspBag>, CustomJspBag> entry : this._customJspBagsMap.entrySet()) {
            CustomJspBag currentCustomJspBag = entry.getValue();
            if (!currentCustomJspBag.isCustomJspGlobal()) continue;
            ServiceReference<CustomJspBag> serviceReference = entry.getKey();
            String contextName = GetterUtil.getString((Object)serviceReference.getProperty("context.name"));
            List<String> currentCustomJsps = currentCustomJspBag.getCustomJsps();
            for (String currentCustomJsp : currentCustomJsps) {
                String currentPortalJsp = this.getPortalJsp(currentCustomJsp, currentCustomJspBag.getCustomJspDir());
                if (!customJsps.contains(currentPortalJsp)) continue;
                conflictingCustomJsps.put(currentPortalJsp, contextName);
            }
        }
        if (conflictingCustomJsps.isEmpty()) {
            return;
        }
        _log.error((Object)(contextId + " conflicts with the installed hooks"));
        if (_log.isDebugEnabled()) {
            Log log = SanitizerLogWrapper.allowCRLF((Log)_log);
            StringBundler stringBundler = new StringBundler(conflictingCustomJsps.size() * 4 + 2);
            stringBundler.append("Colliding JSP files in ");
            stringBundler.append(contextId);
            stringBundler.append("\n");
            int i = 0;
            for (Map.Entry entry : conflictingCustomJsps.entrySet()) {
                stringBundler.append((String)entry.getKey());
                stringBundler.append(" with ");
                stringBundler.append((String)entry.getValue());
                if (i + 1 < conflictingCustomJsps.size()) {
                    stringBundler.append("\n");
                }
                ++i;
            }
            log.debug((Object)stringBundler.toString());
        }
        throw new DuplicateCustomJspException();
    }

    private CustomJspBagRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(context.id=*)(context.name=*)(objectClass=" + CustomJspBag.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new CustomJspBagRegistryUtilServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private class CustomJspBagRegistryUtilServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<CustomJspBag, CustomJspBag> {
        private CustomJspBagRegistryUtilServiceTrackerCustomizer() {
        }

        public CustomJspBag addingService(ServiceReference<CustomJspBag> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            CustomJspBag customJspBag = (CustomJspBag)registry.getService(serviceReference);
            List<String> customJsps = customJspBag.getCustomJsps();
            if (customJsps.isEmpty()) {
                CustomJspBagRegistryUtil.this.getCustomJsps(customJspBag.getURLContainer(), customJspBag.getCustomJspDir(), customJspBag.getCustomJsps());
                customJsps = customJspBag.getCustomJsps();
                if (customJsps.isEmpty()) {
                    return null;
                }
            }
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler(customJsps.size() * 2);
                sb.append("Custom JSP files:\n");
                for (int i = 0; i < customJsps.size(); ++i) {
                    String customJsp = customJsps.get(i);
                    sb.append(customJsp);
                    if (i + 1 >= customJsps.size()) continue;
                    sb.append("\n");
                }
                Log log = SanitizerLogWrapper.allowCRLF((Log)_log);
                log.debug((Object)sb.toString());
            }
            String contextId = GetterUtil.getString((Object)serviceReference.getProperty("context.id"));
            if (customJspBag.isCustomJspGlobal() && !CustomJspBagRegistryUtil.this._customJspBagsMap.isEmpty()) {
                try {
                    CustomJspBagRegistryUtil.this.verifyCustomJsps(contextId, customJspBag);
                }
                catch (DuplicateCustomJspException duplicateCustomJspException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)duplicateCustomJspException.getMessage(), (Throwable)((Object)duplicateCustomJspException));
                    }
                    registry.ungetService(serviceReference);
                    return null;
                }
            }
            String contextName = GetterUtil.getString((Object)serviceReference.getProperty("context.name"));
            try {
                CustomJspBagRegistryUtil.this.initCustomJspBag(contextId, contextName, customJspBag);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)exception.getMessage(), (Throwable)exception);
                }
                registry.ungetService(serviceReference);
                return null;
            }
            CustomJspBagRegistryUtil.this._customJspBagsMap.put(serviceReference, customJspBag);
            return customJspBag;
        }

        public void modifiedService(ServiceReference<CustomJspBag> serviceReference, CustomJspBag customJspBag) {
            this.removedService(serviceReference, customJspBag);
            this.addingService((ServiceReference)serviceReference);
        }

        public void removedService(ServiceReference<CustomJspBag> serviceReference, CustomJspBag customJspBag) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            String contextId = GetterUtil.getString((Object)serviceReference.getProperty("context.id"));
            for (String customJsp : customJspBag.getCustomJsps()) {
                File portalJspFile;
                String customJspDir = customJspBag.getCustomJspDir();
                int pos = customJsp.indexOf(customJspDir);
                String portalJsp = customJsp.substring(pos + customJspDir.length());
                if (customJspBag.isCustomJspGlobal()) {
                    portalJspFile = new File(PortalUtil.getPortalWebDir() + portalJsp);
                    File portalJspBackupFile = CustomJspBagRegistryUtil.this.getPortalJspBackupFile(portalJspFile);
                    if (portalJspBackupFile.exists()) {
                        try {
                            FileUtil.copyFile((File)portalJspBackupFile, (File)portalJspFile);
                        }
                        catch (IOException ioException) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Object)ioException, (Throwable)ioException);
                            }
                            return;
                        }
                        portalJspBackupFile.delete();
                        continue;
                    }
                    if (!portalJspFile.exists()) continue;
                    portalJspFile.delete();
                    continue;
                }
                portalJsp = CustomJspRegistryUtil.getCustomJspFileName((String)contextId, (String)portalJsp);
                portalJspFile = new File(PortalUtil.getPortalWebDir() + portalJsp);
                if (!portalJspFile.exists()) continue;
                portalJspFile.delete();
            }
            if (!customJspBag.isCustomJspGlobal()) {
                CustomJspRegistryUtil.unregisterServletContextName((String)contextId);
            }
            CustomJspBagRegistryUtil.this._customJspBagsMap.remove(serviceReference);
        }
    }
}

