/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.deploy.hot.ServiceBag;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.lang.reflect.Method;

public class ServiceWrapperRegistry {
    private static final Log _log = LogFactoryUtil.getLog(ServiceWrapperRegistry.class);
    private final ServiceTracker<ServiceWrapper<?>, ServiceBag<?>> _serviceTracker;

    public ServiceWrapperRegistry() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(ServiceWrapper.class.getName(), (ServiceTrackerCustomizer)new ServiceWrapperServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void close() {
        this._serviceTracker.close();
    }

    private static class ServiceWrapperServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServiceWrapper<?>, ServiceBag<?>> {
        private ServiceWrapperServiceTrackerCustomizer() {
        }

        public ServiceBag<?> addingService(ServiceReference<ServiceWrapper<?>> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            ServiceWrapper serviceWrapper = (ServiceWrapper)registry.getService(serviceReference);
            try {
                return this._getServiceBag(serviceWrapper);
            }
            catch (Throwable throwable) {
                _log.error((Object)("Unable to get service bag for " + serviceWrapper.getClass()), throwable);
                return null;
            }
        }

        public void modifiedService(ServiceReference<ServiceWrapper<?>> serviceReference, ServiceBag<?> serviceHolder) {
        }

        public void removedService(ServiceReference<ServiceWrapper<?>> serviceReference, ServiceBag<?> serviceBag) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            try {
                serviceBag.replace();
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> ServiceBag<?> _getServiceBag(ServiceWrapper<T> serviceWrapper) throws NoSuchMethodException {
            Class<?> clazz = serviceWrapper.getClass();
            Method method = clazz.getMethod("getWrappedService", new Class[0]);
            Class<?> serviceTypeClass = method.getReturnType();
            Object service = null;
            ServiceReference serviceReference = null;
            Registry registry = RegistryUtil.getRegistry();
            try {
                service = PortalBeanLocatorUtil.locate((String)serviceTypeClass.getName());
            }
            catch (BeanLocatorException beanLocatorException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)beanLocatorException, (Throwable)beanLocatorException);
                }
                serviceReference = registry.getServiceReference(serviceTypeClass);
                service = registry.getService(serviceReference);
            }
            Object serviceProxy = service;
            if (!ProxyUtil.isProxyClass(serviceProxy.getClass())) {
                _log.error((Object)"Service hooks require Spring to be configured to use JdkDynamicProxy and will not work with CGLIB");
                if (serviceReference != null) {
                    registry.ungetService(serviceReference);
                }
                return null;
            }
            ClassLoader classLoader = clazz.getClassLoader();
            try {
                AopInvocationHandler aopInvocationHandler = (AopInvocationHandler)ProxyUtil.fetchInvocationHandler((Object)serviceProxy, AopInvocationHandler.class);
                serviceWrapper.setWrappedService(aopInvocationHandler.getTarget());
                ServiceBag<T> serviceBag = new ServiceBag<T>(classLoader, aopInvocationHandler, serviceTypeClass, serviceWrapper);
                return serviceBag;
            }
            finally {
                if (serviceReference != null) {
                    registry.ungetService(serviceReference);
                }
            }
        }
    }
}

