/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.handlers;

import com.liferay.petra.concurrent.BaseFutureListener;
import com.liferay.petra.concurrent.FutureListener;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.concurrent.NoticeableFutureConverter;
import com.liferay.petra.process.ClassPathUtil;
import com.liferay.petra.process.PathHolder;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessConfig;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.fabric.agent.FabricAgent;
import com.liferay.portal.fabric.netty.agent.NettyFabricAgentStub;
import com.liferay.portal.fabric.netty.fileserver.FileHelperUtil;
import com.liferay.portal.fabric.netty.handlers.NettyChannelAttributes;
import com.liferay.portal.fabric.netty.rpc.ChannelThreadLocal;
import com.liferay.portal.fabric.netty.rpc.RPCUtil;
import com.liferay.portal.fabric.netty.rpc.SyncProcessRPCCallable;
import com.liferay.portal.fabric.netty.util.NettyUtil;
import com.liferay.portal.fabric.netty.worker.NettyFabricWorkerConfig;
import com.liferay.portal.fabric.netty.worker.NettyFabricWorkerStub;
import com.liferay.portal.fabric.repository.Repository;
import com.liferay.portal.fabric.worker.FabricWorker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class NettyFabricWorkerExecutionChannelHandler
extends SimpleChannelInboundHandler<NettyFabricWorkerConfig<Serializable>> {
    private static final Log _log = LogFactoryUtil.getLog(NettyFabricWorkerExecutionChannelHandler.class);
    private final long _executionTimeout;
    private final FabricAgent _fabricAgent;
    private final Repository<Channel> _repository;

    public NettyFabricWorkerExecutionChannelHandler(Repository<Channel> repository, FabricAgent fabricAgent, long executionTimeout) {
        if (repository == null) {
            throw new NullPointerException("Repository is null");
        }
        if (fabricAgent == null) {
            throw new NullPointerException("Fabric agent is null");
        }
        this._repository = repository;
        this._fabricAgent = fabricAgent;
        this._executionTimeout = executionTimeout;
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        final Channel channel = channelHandlerContext.channel();
        _log.error((Object)("Closing " + channel + " due to:"), throwable);
        ChannelFuture channelFuture = channel.close();
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)(channel + " is closed"));
                }
            }
        });
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, NettyFabricWorkerConfig<Serializable> nettyFabricWorkerConfig) {
        NoticeableFuture<LoadedPaths> noticeableFuture = this.loadPaths(channelHandlerContext.channel(), nettyFabricWorkerConfig);
        noticeableFuture.addFutureListener((FutureListener)new PostLoadPathsFutureListener(channelHandlerContext, nettyFabricWorkerConfig));
    }

    protected NoticeableFuture<LoadedPaths> loadPaths(Channel channel, NettyFabricWorkerConfig<Serializable> nettyFabricWorkerConfig) {
        ProcessConfig processConfig = nettyFabricWorkerConfig.getProcessConfig();
        final LinkedHashMap<Path, Object> bootstrapPaths = new LinkedHashMap<Path, Object>();
        for (PathHolder pathHolder : processConfig.getBootstrapClassPathHolders()) {
            bootstrapPaths.put(Paths.get(pathHolder.toString(), new String[0]), null);
        }
        final LinkedHashMap<Path, Object> runtimePaths = new LinkedHashMap<Path, Object>();
        for (PathHolder pathHolder : processConfig.getRuntimeClassPathHolders()) {
            runtimePaths.put(Paths.get(pathHolder.toString(), new String[0]), null);
        }
        final Map<Path, Path> inputPaths = nettyFabricWorkerConfig.getInputPathMap();
        HashMap mergedPaths = HashMapBuilder.putAll(bootstrapPaths).putAll(runtimePaths).putAll(inputPaths).build();
        return new NoticeableFutureConverter<LoadedPaths, Map<Path, Path>>(this._repository.getFiles(channel, mergedPaths, false)){

            protected LoadedPaths convert(Map<Path, Path> mergedPaths) throws IOException {
                HashMap<Path, Path> loadedInputPaths = new HashMap<Path, Path>();
                ArrayList<Path> missedInputPaths = new ArrayList<Path>();
                for (Path path : inputPaths.keySet()) {
                    Path loadedInputPath = mergedPaths.get(path);
                    if (loadedInputPath == null) {
                        missedInputPaths.add(path);
                        continue;
                    }
                    loadedInputPaths.put(path, loadedInputPath);
                }
                if (!missedInputPaths.isEmpty()) {
                    throw new IOException("Unable to get input paths: " + missedInputPaths);
                }
                ArrayList<Path> loadedBootstrapPaths = new ArrayList<Path>();
                ArrayList<Path> missedBootstrapPaths = new ArrayList<Path>();
                for (Path path : bootstrapPaths.keySet()) {
                    Path loadedBootstrapPath = mergedPaths.get(path);
                    if (loadedBootstrapPath == null) {
                        missedBootstrapPaths.add(path);
                        continue;
                    }
                    loadedBootstrapPaths.add(loadedBootstrapPath);
                }
                if (!missedBootstrapPaths.isEmpty() && _log.isWarnEnabled()) {
                    _log.warn((Object)("Incomplete bootstrap classpath loaded, missed: " + missedBootstrapPaths));
                }
                ArrayList<Path> loadedRuntimePaths = new ArrayList<Path>();
                ArrayList<Path> missedRuntimePaths = new ArrayList<Path>();
                for (Path path : runtimePaths.keySet()) {
                    Path loadedRuntimePath = mergedPaths.get(path);
                    if (loadedRuntimePath == null) {
                        missedRuntimePaths.add(path);
                        continue;
                    }
                    loadedRuntimePaths.add(loadedRuntimePath);
                }
                if (!missedRuntimePaths.isEmpty() && _log.isWarnEnabled()) {
                    _log.warn((Object)("Incomplete runtime classpath loaded, missed: " + missedRuntimePaths));
                }
                return new LoadedPaths(loadedInputPaths, StringUtil.merge(loadedBootstrapPaths, (String)File.pathSeparator), StringUtil.merge(loadedRuntimePaths, (String)File.pathSeparator));
            }
        };
    }

    protected void sendResult(Channel channel, long fabricWorkerId, Serializable result, Throwable throwable) {
        final FabricWorkerResultProcessCallable fabricWorkerResultProcessCallable = new FabricWorkerResultProcessCallable(fabricWorkerId, result, throwable);
        NoticeableFuture<Serializable> noticeableFuture = RPCUtil.execute(channel, new SyncProcessRPCCallable<Serializable>(fabricWorkerResultProcessCallable));
        NettyUtil.scheduleCancellation(channel, noticeableFuture, this._executionTimeout);
        noticeableFuture.addFutureListener((FutureListener)new BaseFutureListener<Serializable>(){

            public void completeWithException(java.util.concurrent.Future<Serializable> future, Throwable throwable) {
                _log.error((Object)("Unable to send back fabric worker result " + fabricWorkerResultProcessCallable), throwable);
            }
        });
    }

    protected class PostLoadPathsFutureListener
    extends BaseFutureListener<LoadedPaths> {
        private final ChannelHandlerContext _channelHandlerContext;
        private final NettyFabricWorkerConfig<Serializable> _nettyFabricWorkerConfig;

        public PostLoadPathsFutureListener(ChannelHandlerContext channelHandlerContext, NettyFabricWorkerConfig<Serializable> nettyFabricWorkerConfig) {
            this._channelHandlerContext = channelHandlerContext;
            this._nettyFabricWorkerConfig = nettyFabricWorkerConfig;
        }

        public void completeWithException(java.util.concurrent.Future<LoadedPaths> future, Throwable throwable) {
            NettyFabricWorkerExecutionChannelHandler.this.sendResult(this._channelHandlerContext.channel(), this._nettyFabricWorkerConfig.getId(), null, throwable);
        }

        public void completeWithResult(java.util.concurrent.Future<LoadedPaths> loadPathsFuture, final LoadedPaths loadedPaths) {
            EventExecutor eventExecutor = this._channelHandlerContext.executor();
            Future future = eventExecutor.submit((Callable)new Callable<FabricWorker<Serializable>>(){

                @Override
                public FabricWorker<Serializable> call() throws ProcessException {
                    return NettyFabricWorkerExecutionChannelHandler.this._fabricAgent.execute(loadedPaths.toProcessConfig(PostLoadPathsFutureListener.this._nettyFabricWorkerConfig.getProcessConfig()), PostLoadPathsFutureListener.this._nettyFabricWorkerConfig.getProcessCallable());
                }
            });
            future.addListener((GenericFutureListener)new PostFabricWorkerExecutionFutureListener(this._channelHandlerContext.channel(), loadedPaths, this._nettyFabricWorkerConfig));
        }
    }

    protected class PostFabricWorkerFinishFutureListener
    implements FutureListener<Serializable> {
        private final Channel _channel;
        private final LoadedPaths _loadedPaths;
        private final NettyFabricWorkerConfig<Serializable> _nettyFabricWorkerConfig;

        public PostFabricWorkerFinishFutureListener(Channel channel, NettyFabricWorkerConfig<Serializable> nettyFabricWorkerConfig, LoadedPaths loadedPaths) {
            this._channel = channel;
            this._nettyFabricWorkerConfig = nettyFabricWorkerConfig;
            this._loadedPaths = loadedPaths;
        }

        public void complete(java.util.concurrent.Future<Serializable> future) {
            Map<Path, Path> inputPaths = this._loadedPaths.getInputPaths();
            for (Path path : inputPaths.values()) {
                FileHelperUtil.delete(true, path);
            }
            try {
                NettyFabricWorkerExecutionChannelHandler.this.sendResult(this._channel, this._nettyFabricWorkerConfig.getId(), future.get(), null);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ExecutionException) {
                    throwable = throwable.getCause();
                }
                NettyFabricWorkerExecutionChannelHandler.this.sendResult(this._channel, this._nettyFabricWorkerConfig.getId(), null, throwable);
            }
        }
    }

    protected class PostFabricWorkerExecutionFutureListener
    implements GenericFutureListener<Future<FabricWorker<Serializable>>> {
        private final Channel _channel;
        private final LoadedPaths _loadedPaths;
        private final NettyFabricWorkerConfig<Serializable> _nettyFabricWorkerConfig;

        public PostFabricWorkerExecutionFutureListener(Channel channel, LoadedPaths loadedPaths, NettyFabricWorkerConfig<Serializable> nettyFabricWorkerConfig) {
            this._channel = channel;
            this._loadedPaths = loadedPaths;
            this._nettyFabricWorkerConfig = nettyFabricWorkerConfig;
        }

        public void operationComplete(Future<FabricWorker<Serializable>> future) throws Exception {
            Throwable throwable = future.cause();
            if (throwable != null) {
                NettyFabricWorkerExecutionChannelHandler.this.sendResult(this._channel, this._nettyFabricWorkerConfig.getId(), null, throwable);
                return;
            }
            FabricWorker fabricWorker = (FabricWorker)future.get();
            NettyChannelAttributes.putFabricWorker(this._channel, this._nettyFabricWorkerConfig.getId(), fabricWorker);
            NoticeableFuture<Serializable> noticeableFuture = RPCUtil.execute(this._channel, new SyncProcessRPCCallable<Serializable>(new FabricAgentFinishStartupProcessCallable(this._nettyFabricWorkerConfig.getId())));
            NettyUtil.scheduleCancellation(this._channel, noticeableFuture, NettyFabricWorkerExecutionChannelHandler.this._executionTimeout);
            noticeableFuture.addFutureListener((FutureListener)new BaseFutureListener<Serializable>(){

                public void completeWithException(java.util.concurrent.Future<Serializable> future, Throwable throwable) {
                    _log.error((Object)"Unable to finish fabric worker startup", throwable);
                }
            });
            NoticeableFuture processNoticeableFuture = fabricWorker.getProcessNoticeableFuture();
            processNoticeableFuture.addFutureListener((FutureListener)new PostFabricWorkerFinishFutureListener(this._channel, this._nettyFabricWorkerConfig, this._loadedPaths));
        }
    }

    protected static class LoadedPaths {
        private final String _bootstrapClassPath;
        private final Map<Path, Path> _inputPaths;
        private final String _runtimeClassPath;

        public LoadedPaths(Map<Path, Path> inputPaths, String bootstrapClassPath, String runtimeClassPath) {
            this._inputPaths = inputPaths;
            this._bootstrapClassPath = bootstrapClassPath;
            this._runtimeClassPath = runtimeClassPath;
        }

        public Map<Path, Path> getInputPaths() {
            return this._inputPaths;
        }

        public ProcessConfig toProcessConfig(ProcessConfig processConfig) throws ProcessException {
            ProcessConfig.Builder builder = new ProcessConfig.Builder();
            builder.setArguments(processConfig.getArguments());
            builder.setBootstrapClassPath(this._bootstrapClassPath);
            builder.setJavaExecutable(processConfig.getJavaExecutable());
            builder.setRuntimeClassPath(this._runtimeClassPath);
            try {
                ArrayList urls = new ArrayList();
                Collections.addAll(urls, ClassPathUtil.getClassPathURLs((String)this._bootstrapClassPath));
                Collections.addAll(urls, ClassPathUtil.getClassPathURLs((String)this._runtimeClassPath));
                builder.setReactClassLoader((ClassLoader)new URLClassLoader(urls.toArray(new URL[0])));
            }
            catch (MalformedURLException malformedURLException) {
                throw new ProcessException((Throwable)malformedURLException);
            }
            return builder.build();
        }
    }

    protected static class FabricWorkerResultProcessCallable
    implements ProcessCallable<Serializable> {
        private static final long serialVersionUID = 1L;
        private final long _id;
        private final Serializable _result;
        private final Throwable _throwable;

        public Serializable call() throws ProcessException {
            Channel channel = ChannelThreadLocal.getChannel();
            NettyFabricAgentStub nettyStubFabricAgent = NettyChannelAttributes.getNettyFabricAgentStub(channel);
            if (nettyStubFabricAgent == null) {
                throw new ProcessException("Unable to locate fabric agent on channel " + channel);
            }
            NettyFabricWorkerStub<?> nettyStubFabricWorker = nettyStubFabricAgent.takeNettyStubFabricWorker(this._id);
            if (nettyStubFabricWorker == null) {
                throw new ProcessException(StringBundler.concat((Object[])new Object[]{"Unable to locate fabric worker on channel ", channel, ", with fabric worker id ", this._id}));
            }
            if (this._throwable != null) {
                nettyStubFabricWorker.setException(this._throwable);
            } else {
                nettyStubFabricWorker.setResult(this._result);
            }
            return null;
        }

        public String toString() {
            StringBundler sb = new StringBundler(7);
            sb.append("{id=");
            sb.append(this._id);
            sb.append(", result=");
            sb.append((Object)this._result);
            sb.append(", throwable=");
            sb.append((Object)this._throwable);
            sb.append("}");
            return sb.toString();
        }

        protected FabricWorkerResultProcessCallable(long id, Serializable result, Throwable throwable) {
            this._id = id;
            this._result = result;
            this._throwable = throwable;
        }
    }

    protected static class FabricAgentFinishStartupProcessCallable
    implements ProcessCallable<Serializable> {
        private static final long serialVersionUID = 1L;
        private final long _id;

        public Serializable call() throws ProcessException {
            Channel channel = ChannelThreadLocal.getChannel();
            NettyFabricAgentStub nettyStubFabricAgent = NettyChannelAttributes.getNettyFabricAgentStub(channel);
            if (nettyStubFabricAgent == null) {
                throw new ProcessException("Unable to locate fabric agent on channel " + channel);
            }
            nettyStubFabricAgent.finishStartup(this._id);
            return null;
        }

        protected FabricAgentFinishStartupProcessCallable(long id) {
            this._id = id;
        }
    }
}

