/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.jsonwebservice.JSONRPCRequest;
import com.liferay.portal.jsonwebservice.JSONRPCResponse;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionConfig;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionParameters;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceNaming;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.util.PropsUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.util.StringPlus;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import jodd.bean.BeanCopy;
import jodd.bean.BeanUtil;
import jodd.time.TimeUtil;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.TypeConverterManager;
import jodd.util.ClassUtil;
import jodd.util.StringUtil;

public class JSONWebServiceActionImpl
implements JSONWebServiceAction {
    private static final String[] _JSONWS_WEB_SERVICE_PARAMETER_TYPE_WHITELIST_CLASS_NAMES = PropsUtil.getArray("jsonws.web.service.parameter.type.whitelist.class.names");
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceActionImpl.class);
    private static final ServiceTracker<Object, Object> _serviceTracker;
    private final JSONWebServiceActionConfig _jsonWebServiceActionConfig;
    private final JSONWebServiceActionParameters _jsonWebServiceActionParameters;
    private final JSONWebServiceNaming _jsonWebServiceNaming;

    public JSONWebServiceActionImpl(JSONWebServiceActionConfig jsonWebServiceActionConfig, JSONWebServiceActionParameters jsonWebServiceActionParameters, JSONWebServiceNaming jsonWebServiceNaming) {
        this._jsonWebServiceActionConfig = jsonWebServiceActionConfig;
        this._jsonWebServiceActionParameters = jsonWebServiceActionParameters;
        this._jsonWebServiceNaming = jsonWebServiceNaming;
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping() {
        return this._jsonWebServiceActionConfig;
    }

    public Object invoke() throws Exception {
        JSONRPCRequest jsonRPCRequest = this._jsonWebServiceActionParameters.getJSONRPCRequest();
        if (jsonRPCRequest == null) {
            return this._invokeActionMethod();
        }
        Object result = null;
        Exception exception1 = null;
        try {
            result = this._invokeActionMethod();
        }
        catch (Exception exception2) {
            exception1 = exception2;
            _log.error((Object)exception2, (Throwable)exception2);
        }
        return new JSONRPCResponse(jsonRPCRequest, result, exception1);
    }

    private void _checkTypeIsAssignable(int argumentPos, Class<?> targetClass, Class<?> parameterType) {
        String parameterTypeName = parameterType.getName();
        if (parameterTypeName.contains("com.liferay") && parameterTypeName.contains("Util")) {
            throw new IllegalArgumentException("Not instantiating " + parameterTypeName);
        }
        if (Objects.equals(targetClass, parameterType)) {
            return;
        }
        if (!ClassUtil.isTypeOf(parameterType, targetClass)) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Unmatched argument type ", parameterTypeName, " for method argument ", argumentPos}));
        }
        if (parameterType.isPrimitive()) {
            return;
        }
        if (parameterTypeName.equals(this._jsonWebServiceNaming.convertModelClassToImplClassName(targetClass))) {
            return;
        }
        if (ArrayUtil.contains((Object[])_JSONWS_WEB_SERVICE_PARAMETER_TYPE_WHITELIST_CLASS_NAMES, (Object)parameterTypeName)) {
            return;
        }
        ServiceReference[] serviceReferences = _serviceTracker.getServiceReferences();
        if (serviceReferences != null) {
            String key = "jsonws.web.service.parameter.type.whitelist.class.names";
            for (ServiceReference serviceReference : serviceReferences) {
                List whitelistedClassNames = StringPlus.asList((Object)serviceReference.getProperty(key));
                if (!whitelistedClassNames.contains(parameterTypeName)) continue;
                return;
            }
        }
        throw new TypeConversionException(parameterTypeName + " is not allowed to be instantiated");
    }

    private Object _convertListToArray(List<?> list, Class<?> componentType) {
        Object array = Array.newInstance(componentType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object entry = list.get(i);
            if (entry != null) {
                entry = this._convertType(entry, componentType);
            }
            Array.set(array, i, entry);
        }
        return array;
    }

    private Object _convertType(Object inputObject, Class<?> targetType) {
        if (targetType == null) {
            return inputObject;
        }
        TypeConverterManager typeConverterManager = TypeConverterManager.get();
        Object outputObject = null;
        try {
            outputObject = typeConverterManager.convertType(inputObject, targetType);
        }
        catch (TypeConversionException typeConversionException) {
            if (inputObject instanceof Map) {
                try {
                    if (targetType.isInterface()) {
                        Class<?> clazz = this.getClass();
                        ClassLoader classLoader = clazz.getClassLoader();
                        String modelClassName = this._jsonWebServiceNaming.convertModelClassToImplClassName(targetType);
                        try {
                            targetType = classLoader.loadClass(modelClassName);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Object)classNotFoundException, (Throwable)classNotFoundException);
                            }
                            Class<?> actionClass = this._jsonWebServiceActionConfig.getActionClass();
                            classLoader = actionClass.getClassLoader();
                            targetType = classLoader.loadClass(modelClassName);
                        }
                    }
                    outputObject = targetType.newInstance();
                    BeanCopy beanCopy = new BeanCopy(inputObject, outputObject);
                    beanCopy.copy();
                    return outputObject;
                }
                catch (Exception exception) {
                    throw new TypeConversionException((Throwable)exception);
                }
            }
            throw typeConversionException;
        }
        return outputObject;
    }

    private Object _convertValueToParameterValue(Object value, Class<?> parameterType, Class<?>[] genericParameterTypes) {
        if (parameterType.isArray()) {
            if (parameterType.isInstance(value)) {
                return value;
            }
            if (value instanceof File) {
                try {
                    return FileUtil.getBytes((File)((File)value));
                }
                catch (IOException ioException) {
                    _log.error((Object)ioException, (Throwable)ioException);
                    return null;
                }
            }
            List list = null;
            if (value instanceof List) {
                list = (List)value;
            } else {
                String valueString = value.toString();
                if (!(valueString = valueString.trim()).startsWith("[")) {
                    valueString = StringBundler.concat((String[])new String[]{"[", valueString, "]"});
                }
                list = (List)JSONFactoryUtil.looseDeserialize((String)valueString, ArrayList.class);
            }
            return this._convertListToArray(list, parameterType.getComponentType());
        }
        if (Enum.class.isAssignableFrom(parameterType)) {
            return Enum.valueOf(parameterType, value.toString());
        }
        if (parameterType.equals(Calendar.class)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            String valueString = value.toString();
            valueString = valueString.trim();
            calendar.setTimeInMillis(GetterUtil.getLong((String)valueString));
            return calendar;
        }
        if (Collection.class.isAssignableFrom(parameterType)) {
            List list = null;
            if (value instanceof List) {
                list = (List)value;
            } else {
                String valueString = value.toString();
                if (!(valueString = valueString.trim()).startsWith("[")) {
                    valueString = StringBundler.concat((String[])new String[]{"[", valueString, "]"});
                }
                list = (List)JSONFactoryUtil.looseDeserialize((String)valueString, ArrayList.class);
            }
            return this._generifyList(list, genericParameterTypes);
        }
        if (parameterType.equals(Locale.class)) {
            String valueString = value.toString();
            valueString = valueString.trim();
            return LocaleUtil.fromLanguageId((String)valueString);
        }
        if (parameterType.equals(Map.class)) {
            Map map = null;
            if (value instanceof Map) {
                map = (Map)value;
            } else {
                String valueString = value.toString();
                valueString = valueString.trim();
                map = (Map)JSONFactoryUtil.looseDeserialize((String)valueString, HashMap.class);
            }
            return this._generifyMap(map, genericParameterTypes);
        }
        Object parameterValue = null;
        try {
            parameterValue = this._convertType(value, parameterType);
        }
        catch (Exception exception1) {
            if (value instanceof Map) {
                try {
                    parameterValue = this._createDefaultParameterValue(null, parameterType);
                }
                catch (Exception exception2) {
                    ClassCastException classCastException = new ClassCastException(exception1.getMessage());
                    classCastException.addSuppressed(exception2);
                    throw classCastException;
                }
                BeanCopy beanCopy = new BeanCopy(value, parameterValue);
                beanCopy.copy();
            }
            String valueString = value.toString();
            if (!(valueString = valueString.trim()).startsWith("{")) {
                throw new ClassCastException(exception1.getMessage());
            }
            parameterValue = JSONFactoryUtil.looseDeserialize((String)valueString, parameterType);
        }
        return parameterValue;
    }

    private Object _createDefaultParameterValue(String parameterName, Class<?> parameterType) throws Exception {
        if (parameterName != null && parameterName.equals("serviceContext") && parameterType.equals(ServiceContext.class)) {
            ServiceContext serviceContext = this._jsonWebServiceActionParameters.getServiceContext();
            if (serviceContext == null) {
                serviceContext = new ServiceContext();
            }
            return serviceContext;
        }
        return parameterType.newInstance();
    }

    private List<?> _generifyList(List<?> list, Class<?>[] types) {
        if (types == null) {
            return list;
        }
        if (types.length != 1) {
            return list;
        }
        ArrayList newList = new ArrayList(list.size());
        for (Object entry : list) {
            if (entry != null) {
                entry = this._convertType(entry, types[0]);
            }
            newList.add(entry);
        }
        return newList;
    }

    private Map<?, ?> _generifyMap(Map<?, ?> map, Class<?>[] types) {
        if (types == null) {
            return map;
        }
        if (types.length != 2) {
            return map;
        }
        HashMap newMap = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = this._convertType(entry.getKey(), types[0]);
            Object value = entry.getValue();
            if (value != null) {
                value = this._convertType(value, types[1]);
            }
            newMap.put(key, value);
        }
        return newMap;
    }

    private void _injectInnerParametersIntoValue(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            return;
        }
        List<Map.Entry<String, Object>> innerParameters = this._jsonWebServiceActionParameters.getInnerParameters(parameterName);
        if (innerParameters == null) {
            return;
        }
        for (Map.Entry<String, Object> innerParameter : innerParameters) {
            try {
                BeanUtil.pojo.setProperty(parameterValue, innerParameter.getKey(), innerParameter.getValue());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to set inner parameter ", parameterName, ".", innerParameter.getKey()}), (Throwable)exception);
            }
        }
    }

    private Object _invokeActionMethod() throws Exception {
        Object actionObject = this._jsonWebServiceActionConfig.getActionObject();
        Method actionMethod = this._jsonWebServiceActionConfig.getActionMethod();
        Object[] parameters = this._prepareParameters(this._jsonWebServiceActionConfig.getActionClass());
        if (this._jsonWebServiceActionConfig.isDeprecated() && _log.isWarnEnabled()) {
            _log.warn((Object)("Invoking deprecated method " + actionMethod.getName()));
        }
        return actionMethod.invoke(actionObject, parameters);
    }

    private Object[] _prepareParameters(Class<?> actionClass) throws Exception {
        MethodParameter[] methodParameters = this._jsonWebServiceActionConfig.getMethodParameters();
        Object[] parameters = new Object[methodParameters.length];
        for (int i = 0; i < methodParameters.length; ++i) {
            String parameterName = methodParameters[i].getName();
            parameterName = CamelCaseUtil.normalizeCamelCase((String)parameterName);
            Object value = this._jsonWebServiceActionParameters.getParameter(parameterName);
            Object parameterValue = null;
            if (value != null) {
                Class<?> targetClass;
                Class<?> parameterType = targetClass = methodParameters[i].getType();
                String parameterTypeName = this._jsonWebServiceActionParameters.getParameterTypeName(parameterName);
                if (parameterTypeName != null) {
                    ClassLoader classLoader = actionClass.getClassLoader();
                    parameterType = classLoader.loadClass(parameterTypeName);
                    this._checkTypeIsAssignable(i, targetClass, parameterType);
                }
                if (value.equals(Void.TYPE)) {
                    parameterValue = this._createDefaultParameterValue(parameterName, parameterType);
                } else {
                    parameterValue = this._convertValueToParameterValue(value, parameterType, methodParameters[i].getGenericTypes());
                    ServiceContext serviceContext = this._jsonWebServiceActionParameters.getServiceContext();
                    if (serviceContext != null && parameterName.equals("serviceContext")) {
                        if (parameterValue != null && parameterValue instanceof ServiceContext) {
                            serviceContext.merge((ServiceContext)parameterValue);
                        }
                        parameterValue = serviceContext;
                    }
                }
            }
            this._injectInnerParametersIntoValue(parameterName, parameterValue);
            parameters[i] = parameterValue;
        }
        return parameters;
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(registry.getFilter(StringBundler.concat((String[])new String[]{"(", "jsonws.web.service.parameter.type.whitelist.class.names", "=*)"})));
        _serviceTracker.open();
        TypeConverterManager typeConverterManager = TypeConverterManager.get();
        typeConverterManager.register(Date.class, (TypeConverter)new DateTypeConverter());
        typeConverterManager.register(Locale.class, (TypeConverter)new LocaleTypeConverter());
    }

    private static class LocaleTypeConverter
    implements TypeConverter<Locale> {
        private LocaleTypeConverter() {
        }

        public Locale convert(Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Locale) {
                return (Locale)object;
            }
            return LocaleUtil.fromLanguageId((String)String.valueOf(object), (boolean)false);
        }
    }

    private static class DateTypeConverter
    implements TypeConverter<Date> {
        private static final DateTimeFormatter _dateTimeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-[MM][M]-[dd][d]").optionalStart().optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().appendOptional(DateTimeFormatter.ISO_TIME).toFormatter();

        private DateTypeConverter() {
        }

        public Date convert(Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                return new Date(calendar.getTimeInMillis());
            }
            if (object instanceof Date) {
                return (Date)object;
            }
            if (object instanceof LocalDate) {
                return TimeUtil.toDate((LocalDate)((LocalDate)object));
            }
            if (object instanceof LocalDateTime) {
                return TimeUtil.toDate((LocalDateTime)((LocalDateTime)object));
            }
            if (object instanceof Number) {
                Number number = (Number)object;
                return new Date(number.longValue());
            }
            String stringValue = object.toString();
            if (!StringUtil.containsOnlyDigits((CharSequence)(stringValue = stringValue.trim()))) {
                TemporalAccessor temporalAccessor = _dateTimeFormatter.parseBest(stringValue, ZonedDateTime::from, LocalDateTime::from, LocalDate::from);
                if (temporalAccessor instanceof LocalDate) {
                    return TimeUtil.toDate((LocalDate)((LocalDate)temporalAccessor));
                }
                if (temporalAccessor instanceof LocalDateTime) {
                    return TimeUtil.toDate((LocalDateTime)((LocalDateTime)temporalAccessor));
                }
                if (temporalAccessor instanceof ZonedDateTime) {
                    ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
                    return Date.from(zonedDateTime.toInstant());
                }
                throw new TypeConversionException(object);
            }
            try {
                return new Date(Long.parseLong(stringValue));
            }
            catch (NumberFormatException numberFormatException) {
                throw new TypeConversionException(object, (Throwable)numberFormatException);
            }
        }
    }
}

