/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util.velocity;

import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.PortletJSONUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.layoutconfiguration.util.PortletRenderer;
import com.liferay.portal.layoutconfiguration.util.velocity.ColumnProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateProcessor
implements ColumnProcessor {
    private static final RenderWeightComparator _renderWeightComparator = new RenderWeightComparator();
    private final HttpServletRequest _httpServletRequest;
    private final HttpServletResponse _httpServletResponse;
    private final Portlet _portlet;
    private final boolean _portletAjaxRender;
    private final Map<Integer, List<PortletRenderer>> _portletRenderers;

    public TemplateProcessor(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId) {
        this._httpServletRequest = httpServletRequest;
        this._httpServletResponse = httpServletResponse;
        if (Validator.isNotNull((String)portletId)) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        } else {
            this._portlet = null;
        }
        this._portletAjaxRender = GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("PORTLET_AJAX_RENDER"));
        this._portletRenderers = new TreeMap<Integer, List<PortletRenderer>>(_renderWeightComparator);
    }

    public Map<Integer, List<PortletRenderer>> getPortletRenderers() {
        return this._portletRenderers;
    }

    @Override
    public String processColumn(String columnId) throws Exception {
        return this.processColumn(columnId, "");
    }

    @Override
    public String processColumn(String columnId, String classNames) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        return this._processColumn(columnId, classNames, layoutTypePortlet, layoutTypePortlet.getAllPortlets(columnId));
    }

    @Override
    public String processDynamicColumn(String columnId, String classNames) throws Exception {
        Portlet portlet;
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        String portletId = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"p_p_id");
        if (Validator.isNotNull((String)portletId) && (portlet = PortletLocalServiceUtil.getPortletById((String)portletId)) != null) {
            portlets.add(portlet);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._processColumn(columnId, classNames, themeDisplay.getLayoutTypePortlet(), portlets);
    }

    @Override
    public String processMax() throws Exception {
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(this._httpServletResponse);
        PortletContainerUtil.renderHeaders((HttpServletRequest)this._httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, (Portlet)this._portlet);
        PortletContainerUtil.render((HttpServletRequest)this._httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, (Portlet)this._portlet);
        return bufferCacheServletResponse.getString();
    }

    @Override
    public String processPortlet(String portletId) throws Exception {
        return this.processPortlet(portletId, (Map)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String processPortlet(String portletId, Map<String, ?> defaultSettingsMap) throws Exception {
        LayoutTypePortlet layoutTypePortlet;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        if (layout.isTypePortlet() && !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId, true) && !layout.isPortletEmbedded(portletId, layout.getGroupId())) {
            String defaultPreferences = portlet.getDefaultPreferences();
            Settings currentSettings = SettingsFactoryUtil.getSettings((SettingsLocator)new PortletInstanceSettingsLocator(layout, portletId));
            ModifiableSettings currentModifiableSettings = currentSettings.getModifiableSettings();
            Collection currentModifiableSettingsKeys = currentModifiableSettings.getModifiedKeys();
            if (!currentModifiableSettingsKeys.isEmpty()) {
                StringBundler sb = new StringBundler();
                sb.append("<portlet-preferences>");
                for (String key : currentModifiableSettingsKeys) {
                    String[] values = currentModifiableSettings.getValues(key, null);
                    if (values == null) continue;
                    sb.append("<preference><name>");
                    sb.append(key);
                    sb.append("</name>");
                    for (String value : values) {
                        sb.append("<value>");
                        sb.append(XMLUtil.toCompactSafe((String)value));
                        sb.append("</value>");
                    }
                    sb.append("</preference>");
                }
                sb.append("</portlet-preferences>");
                defaultPreferences = sb.toString();
            }
            PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)layout.getCompanyId(), (long)layout.getGroupId(), (int)3, (long)layout.getPlid(), (String)portletId, (String)defaultPreferences);
        }
        if (defaultSettingsMap != null) {
            Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new PortletInstanceSettingsLocator(layout, portletId));
            ModifiableSettings modifiableSettings = settings.getModifiableSettings();
            boolean modified = false;
            for (Map.Entry<String, ?> entry : defaultSettingsMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String) {
                    String storedValue = modifiableSettings.getValue(key, null);
                    if (storedValue != null) continue;
                    modifiableSettings.setValue(key, (String)value);
                    modified = true;
                    continue;
                }
                if (value instanceof String[]) {
                    String[] storedValues = modifiableSettings.getValues(key, null);
                    if (storedValues != null) continue;
                    modifiableSettings.setValues(key, (String[])value);
                    modified = true;
                    continue;
                }
                throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Key ", key, " has unsupported value of type ", ClassUtil.getClassName(value.getClass())}));
            }
            if (modified) {
                modifiableSettings.store();
            }
        }
        this._httpServletRequest.setAttribute("RENDER_PORTLET_RESOURCE", (Object)Boolean.TRUE);
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(this._httpServletResponse);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        PortletJSONUtil.populatePortletJSONObject((HttpServletRequest)this._httpServletRequest, (String)"", (Portlet)portlet, (JSONObject)jsonObject);
        try {
            PortletJSONUtil.writeHeaderPaths((HttpServletResponse)this._httpServletResponse, (JSONObject)jsonObject);
            HttpServletRequest httpServletRequest = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)this._httpServletRequest, null, null, null, null);
            PortletContainerUtil.render((HttpServletRequest)httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, (Portlet)portlet);
            PortletJSONUtil.writeFooterPaths((HttpServletResponse)this._httpServletResponse, (JSONObject)jsonObject);
            String string = bufferCacheServletResponse.getString();
            return string;
        }
        finally {
            this._httpServletRequest.removeAttribute("RENDER_PORTLET_RESOURCE");
        }
    }

    @Override
    public String processPortlet(String portletProviderClassName, PortletProvider.Action portletProviderAction) throws Exception {
        String portletId = PortletProviderUtil.getPortletId((String)portletProviderClassName, (PortletProvider.Action)portletProviderAction);
        return this.processPortlet(portletId);
    }

    private String _processColumn(String columnId, String classNames, LayoutTypePortlet layoutTypePortlet, List<Portlet> portlets) throws Exception {
        StringBundler sb = new StringBundler(portlets.size() * 3 + 11);
        sb.append("<div class=\"");
        if (layoutTypePortlet.isColumnCustomizable(columnId)) {
            sb.append("customizable ");
        }
        if (portlets.isEmpty()) {
            sb.append("empty ");
        }
        sb.append("portlet-dropzone ");
        if (layoutTypePortlet.isColumnDisabled(columnId) && layoutTypePortlet.isCustomizable()) {
            sb.append("portlet-dropzone-disabled");
        }
        if (Validator.isNotNull((String)classNames)) {
            sb.append(classNames);
        }
        sb.append("\" id=\"layout-column_");
        sb.append(columnId);
        sb.append("\">");
        for (int i = 0; i < portlets.size(); ++i) {
            Portlet portlet = portlets.get(i);
            Integer columnCount = portlets.size();
            Integer columnPos = i;
            PortletRenderer portletRenderer = new PortletRenderer(portlet, columnId, columnCount, columnPos);
            if (this._portletAjaxRender && portlet.getRenderWeight() < 1) {
                StringBundler renderResultSB = portletRenderer.renderAjax(this._httpServletRequest, this._httpServletResponse);
                sb.append(renderResultSB);
                continue;
            }
            Integer renderWeight = portlet.getRenderWeight();
            List<PortletRenderer> portletRenderers = this._portletRenderers.get(renderWeight);
            if (portletRenderers == null) {
                portletRenderers = new ArrayList<PortletRenderer>();
                this._portletRenderers.put(renderWeight, portletRenderers);
            }
            portletRenderers.add(portletRenderer);
            sb.append("[$TEMPLATE_PORTLET_");
            sb.append(portlet.getPortletId());
            sb.append("$]");
        }
        sb.append("</div>");
        return sb.toString();
    }

    private static class RenderWeightComparator
    implements Comparator<Integer> {
        private RenderWeightComparator() {
        }

        @Override
        public int compare(Integer renderWeight1, Integer renderWeight2) {
            return renderWeight2 - renderWeight1;
        }
    }
}

