/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.nio.intraband.proxy;

import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.rpc.IntrabandRPCUtil;
import com.liferay.portal.kernel.process.ProcessCallable;

public class StubHolder<T> {
    private static final Log _log = LogFactoryUtil.getLog(StubHolder.class);
    private static final ProcessCallable<Boolean> _startupFinishedProcessCallable = new StartupFinishedProcessCallable();
    private final T _originalT;
    private final RegistrationReference _registrationReference;
    private volatile T _stub;
    private final StubCreator<T> _stubCreator;
    private final String _stubId;

    public StubHolder(T originalT, String stubId, RegistrationReference registrationReference, StubCreator<T> stubCreator) {
        this._originalT = originalT;
        this._stubId = stubId;
        this._registrationReference = registrationReference;
        this._stubCreator = stubCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getStub() {
        if (this._stub != null) {
            return this.doGetStub();
        }
        RegistrationReference registrationReference = this._registrationReference;
        synchronized (registrationReference) {
            boolean startupFinished;
            block11: {
                if (this._stub != null) {
                    return this.doGetStub();
                }
                NoticeableFuture future = IntrabandRPCUtil.execute((RegistrationReference)this._registrationReference, _startupFinishedProcessCallable);
                startupFinished = false;
                try {
                    startupFinished = (Boolean)future.get();
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block11;
                    _log.warn((Object)"Unable to detect SPI's startup status", (Throwable)exception);
                }
            }
            if (!startupFinished) {
                return this._originalT;
            }
            try {
                this._stub = this._stubCreator.createStub(this._stubId, this._originalT, this._registrationReference);
                return this._stub;
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to create stub", (Throwable)exception);
                }
                return this._stubCreator.onCreationFailure(this._stubId, this._originalT, exception);
            }
        }
    }

    protected T doGetStub() {
        if (this._registrationReference.isValid()) {
            return this._stub;
        }
        return this._stubCreator.onInvalidation(this._stubId, this._stub, this._originalT);
    }

    private static class StartupFinishedProcessCallable
    implements ProcessCallable<Boolean> {
        private static final long serialVersionUID = 1L;

        private StartupFinishedProcessCallable() {
        }

        public Boolean call() {
            return StartupHelperUtil.isStartupFinished();
        }
    }

    public static interface StubCreator<T> {
        public T createStub(String var1, T var2, RegistrationReference var3) throws Exception;

        public T onCreationFailure(String var1, T var2, Exception var3);

        public T onInvalidation(String var1, T var2, T var3);
    }
}

