/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.License;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.plugin.RemotePluginPackageRepository;
import com.liferay.portal.kernel.plugin.Screenshot;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.plugin.LocalPluginPackageRepository;
import com.liferay.portal.plugin.PluginPackageException;
import com.liferay.portal.plugin.PluginPackageImpl;
import com.liferay.portal.plugin.RepositoryReport;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.commons.lang.time.StopWatch;

public class PluginPackageUtil {
    private static final String _TYPE_EXT = "ext";
    private static final Log _log = LogFactoryUtil.getLog(PluginPackageUtil.class);
    private static final PluginPackageUtil _pluginPackageUtil = new PluginPackageUtil();
    private final Set<String> _availableTagsCache;
    private final LocalPluginPackageRepository _installedPluginPackages = new LocalPluginPackageRepository();
    private Date _lastUpdateDate;
    private final Map<String, RemotePluginPackageRepository> _repositoryCache = new HashMap<String, RemotePluginPackageRepository>();
    private boolean _settingUpdateAvailable;
    private Boolean _updateAvailable;

    public static void endPluginPackageInstallation(String preliminaryContext) {
        _pluginPackageUtil._endPluginPackageInstallation(preliminaryContext);
    }

    public static List<PluginPackage> getAllAvailablePluginPackages() throws PortalException {
        return _pluginPackageUtil._getAllAvailablePluginPackages();
    }

    public static Collection<String> getAvailableTags() {
        return _pluginPackageUtil._getAvailableTags();
    }

    public static PluginPackage getInstalledPluginPackage(String context) {
        return _pluginPackageUtil._getInstalledPluginPackage(context);
    }

    public static List<PluginPackage> getInstalledPluginPackages() {
        return _pluginPackageUtil._getInstalledPluginPackages();
    }

    public static Date getLastUpdateDate() {
        return _pluginPackageUtil._getLastUpdateDate();
    }

    public static PluginPackage getLatestAvailablePluginPackage(String groupId, String artifactId) throws PortalException {
        return _pluginPackageUtil._getLatestAvailablePluginPackage(groupId, artifactId);
    }

    public static PluginPackage getLatestInstalledPluginPackage(String groupId, String artifactId) {
        return _pluginPackageUtil._getLatestInstalledPluginPackage(groupId, artifactId);
    }

    public static PluginPackage getPluginPackageByModuleId(String moduleId, String repositoryURL) throws PortalException {
        return _pluginPackageUtil._getPluginPackageByModuleId(moduleId, repositoryURL);
    }

    public static PluginPackage getPluginPackageByURL(String url) throws PortalException {
        return _pluginPackageUtil._getPluginPackageByURL(url);
    }

    public static RemotePluginPackageRepository getRepository(String repositoryURL) throws PortalException {
        return _pluginPackageUtil._getRepository(repositoryURL);
    }

    public static String[] getRepositoryURLs() {
        return _pluginPackageUtil._getRepositoryURLs();
    }

    public static String[] getStatusAndInstalledVersion(PluginPackage pluginPackage) {
        return _pluginPackageUtil._getStatusAndInstalledVersion(pluginPackage);
    }

    public static String[] getSupportedTypes() {
        return _pluginPackageUtil._getSupportedTypes();
    }

    public static boolean isCurrentVersionSupported(List<String> versions) {
        return _pluginPackageUtil._isCurrentVersionSupported(versions);
    }

    public static boolean isIgnored(PluginPackage pluginPackage) {
        return _pluginPackageUtil._isIgnored(pluginPackage);
    }

    public static boolean isInstallationInProcess(String context) {
        return _pluginPackageUtil._isInstallationInProcess(context);
    }

    public static boolean isInstalled(String context) {
        return _pluginPackageUtil._isInstalled(context);
    }

    public static boolean isTrusted(String repositoryURL) {
        return _pluginPackageUtil._isTrusted(repositoryURL);
    }

    public static boolean isUpdateAvailable() {
        return _pluginPackageUtil._isUpdateAvailable();
    }

    public static PluginPackage readPluginPackageProperties(String displayName, Properties properties) {
        return _pluginPackageUtil._readPluginPackageProperties(displayName, properties);
    }

    public static PluginPackage readPluginPackageServletContext(ServletContext servletContext) throws DocumentException, IOException {
        return _pluginPackageUtil._readPluginPackageServletContext(servletContext);
    }

    public static PluginPackage readPluginPackageXml(Element pluginPackageElement) {
        return _pluginPackageUtil._readPluginPackageXml(pluginPackageElement);
    }

    public static PluginPackage readPluginPackageXml(String xml) throws DocumentException {
        return _pluginPackageUtil._readPluginPackageXml(xml);
    }

    public static void refreshUpdatesAvailableCache() {
        _pluginPackageUtil._refreshUpdatesAvailableCache();
    }

    public static void registerInstalledPluginPackage(PluginPackage pluginPackage) throws PortalException {
        _pluginPackageUtil._registerInstalledPluginPackage(pluginPackage);
    }

    public static void registerPluginPackageInstallation(String preliminaryContext) {
        _pluginPackageUtil._registerPluginPackageInstallation(preliminaryContext);
    }

    public static RepositoryReport reloadRepositories() throws PortalException {
        return _pluginPackageUtil._reloadRepositories();
    }

    public static void unregisterInstalledPluginPackage(PluginPackage pluginPackage) throws PortalException {
        _pluginPackageUtil._unregisterInstalledPluginPackage(pluginPackage);
    }

    public static void updateInstallingPluginPackage(String preliminaryContext, PluginPackage pluginPackage) {
        _pluginPackageUtil._updateInstallingPluginPackage(preliminaryContext, pluginPackage);
    }

    private PluginPackageUtil() {
        this._availableTagsCache = new TreeSet<String>();
    }

    private void _endPluginPackageInstallation(String preliminaryContext) {
        this._installedPluginPackages.unregisterPluginPackageInstallation(preliminaryContext);
    }

    private PluginPackage _findLatestVersion(List<PluginPackage> pluginPackages) {
        PluginPackage latestPluginPackage = null;
        for (PluginPackage pluginPackage : pluginPackages) {
            if (latestPluginPackage != null && !pluginPackage.isLaterVersionThan(latestPluginPackage)) continue;
            latestPluginPackage = pluginPackage;
        }
        return latestPluginPackage;
    }

    private List<PluginPackage> _getAllAvailablePluginPackages() throws PortalException {
        String[] repositoryURLs;
        ArrayList<PluginPackage> pluginPackages = new ArrayList<PluginPackage>();
        for (String repositoryURL : repositoryURLs = this._getRepositoryURLs()) {
            try {
                RemotePluginPackageRepository repository = this._getRepository(repositoryURL);
                pluginPackages.addAll(repository.getPluginPackages());
            }
            catch (PluginPackageException pluginPackageException) {
                String message = pluginPackageException.getMessage();
                if (message.startsWith("Unable to communicate")) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)message);
                    continue;
                }
                _log.error((Object)message);
            }
        }
        return pluginPackages;
    }

    private List<PluginPackage> _getAvailablePluginPackages(String groupId, String artifactId) throws PortalException {
        String[] repositoryURLs;
        ArrayList<PluginPackage> pluginPackages = new ArrayList<PluginPackage>();
        for (String repositoryURL : repositoryURLs = this._getRepositoryURLs()) {
            RemotePluginPackageRepository repository = this._getRepository(repositoryURL);
            List curPluginPackages = repository.findPluginsByGroupIdAndArtifactId(groupId, artifactId);
            if (curPluginPackages == null) continue;
            pluginPackages.addAll(curPluginPackages);
        }
        return pluginPackages;
    }

    private Collection<String> _getAvailableTags() {
        return this._availableTagsCache;
    }

    private PluginPackage _getInstalledPluginPackage(String context) {
        return this._installedPluginPackages.getPluginPackage(context);
    }

    private List<PluginPackage> _getInstalledPluginPackages() {
        return this._installedPluginPackages.getSortedPluginPackages();
    }

    private Date _getLastUpdateDate() {
        return this._lastUpdateDate;
    }

    private PluginPackage _getLatestAvailablePluginPackage(String groupId, String artifactId) throws PortalException {
        List<PluginPackage> pluginPackages = this._getAvailablePluginPackages(groupId, artifactId);
        return this._findLatestVersion(pluginPackages);
    }

    private PluginPackage _getLatestInstalledPluginPackage(String groupId, String artifactId) {
        return this._installedPluginPackages.getLatestPluginPackage(groupId, artifactId);
    }

    private PluginPackage _getPluginPackageByModuleId(String moduleId, String repositoryURL) throws PortalException {
        RemotePluginPackageRepository repository = this._getRepository(repositoryURL);
        return repository.findPluginPackageByModuleId(moduleId);
    }

    private PluginPackage _getPluginPackageByURL(String url) throws PortalException {
        String[] repositoryURLs;
        for (String repositoryURL : repositoryURLs = this._getRepositoryURLs()) {
            try {
                RemotePluginPackageRepository repository = this._getRepository(repositoryURL);
                return repository.findPluginByArtifactURL(url);
            }
            catch (PluginPackageException pluginPackageException) {
                _log.error((Object)("Unable to load repository " + repositoryURL), (Throwable)((Object)pluginPackageException));
            }
        }
        return null;
    }

    private RemotePluginPackageRepository _getRepository(String repositoryURL) throws PortalException {
        RemotePluginPackageRepository repository = this._repositoryCache.get(repositoryURL);
        if (repository != null) {
            return repository;
        }
        return this._loadRepository(repositoryURL);
    }

    private String[] _getRepositoryURLs() throws PluginPackageException {
        try {
            Object[] trusted = PropsValues.PLUGIN_REPOSITORIES_TRUSTED;
            Object[] untrusted = PropsValues.PLUGIN_REPOSITORIES_UNTRUSTED;
            return (String[])ArrayUtil.append((Object[])trusted, (Object[])untrusted);
        }
        catch (Exception exception) {
            throw new PluginPackageException("Unable to read repository list", exception);
        }
    }

    private String[] _getStatusAndInstalledVersion(PluginPackage pluginPackage) {
        PluginPackage installedPluginPackage = this._installedPluginPackages.getLatestPluginPackage(pluginPackage.getGroupId(), pluginPackage.getArtifactId());
        String status = null;
        String installedVersion = null;
        if (installedPluginPackage == null) {
            status = "notInstalled";
        } else {
            installedVersion = installedPluginPackage.getVersion();
            status = installedPluginPackage.isLaterVersionThan(pluginPackage) ? "newerVersionInstalled" : (installedPluginPackage.isPreviousVersionThan(pluginPackage) ? "olderVersionInstalled" : "sameVersionInstalled");
        }
        return new String[]{status, installedVersion};
    }

    private String[] _getSupportedTypes() {
        return PropsValues.PLUGIN_TYPES;
    }

    private boolean _isCurrentVersionSupported(List<String> versions) {
        Version currentVersion = Version.getInstance((String)ReleaseInfo.getVersion());
        for (String version : versions) {
            Version supportedVersion = Version.getInstance((String)version);
            if (!supportedVersion.includes(currentVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean _isIgnored(PluginPackage pluginPackage) {
        String[] pluginPackagesIgnored;
        String packageId = pluginPackage.getPackageId();
        for (String curPluginPackagesIgnored : pluginPackagesIgnored = PropsValues.PLUGIN_NOTIFICATIONS_PACKAGES_IGNORED) {
            String prefix;
            if (!(curPluginPackagesIgnored.endsWith("*") ? packageId.startsWith(prefix = curPluginPackagesIgnored.substring(0, curPluginPackagesIgnored.length() - 2)) : packageId.equals(curPluginPackagesIgnored))) continue;
            return true;
        }
        return false;
    }

    private boolean _isInstallationInProcess(String context) {
        return this._installedPluginPackages.getInstallingPluginPackage(context) != null;
    }

    private boolean _isInstalled(String context) {
        PluginPackage pluginPackage = this._installedPluginPackages.getPluginPackage(context);
        return pluginPackage != null;
    }

    private boolean _isTrusted(String repositoryURL) throws PluginPackageException {
        try {
            Object[] trusted = PropsValues.PLUGIN_REPOSITORIES_TRUSTED;
            return ArrayUtil.contains((Object[])trusted, (Object)repositoryURL);
        }
        catch (Exception exception) {
            throw new PluginPackageException("Unable to read repository list", exception);
        }
    }

    private boolean _isUpdateAvailable() {
        if (!PropsValues.PLUGIN_NOTIFICATIONS_ENABLED) {
            return false;
        }
        if (this._updateAvailable != null) {
            return this._updateAvailable;
        }
        if (!this._settingUpdateAvailable) {
            this._settingUpdateAvailable = true;
            Thread indexerThread = new Thread((Runnable)new UpdateAvailableRunner(), PluginPackageUtil.class.getName());
            indexerThread.setPriority(1);
            indexerThread.start();
        }
        return false;
    }

    private RemotePluginPackageRepository _loadRepository(String repositoryURL) throws PluginPackageException, PortalException {
        StringBundler sb = new StringBundler(8);
        if (!repositoryURL.startsWith("http://") && !repositoryURL.startsWith("https://")) {
            sb.append("http://");
        }
        sb.append(repositoryURL);
        sb.append("/");
        sb.append("liferay-plugin-repository");
        sb.append("-");
        sb.append(ReleaseInfo.getVersion());
        sb.append(".");
        sb.append("xml");
        String pluginsXmlURL = sb.toString();
        try {
            Http.Options options = new Http.Options();
            options.setLocation(pluginsXmlURL);
            options.setPost(false);
            byte[] bytes = HttpUtil.URLtoByteArray((Http.Options)options);
            Http.Response response = options.getResponse();
            int responseCode = response.getResponseCode();
            if (responseCode != 200) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("A repository for version " + ReleaseInfo.getVersion() + " was not found. Checking general repository"));
                }
                sb.setIndex(0);
                sb.append(repositoryURL);
                sb.append("/");
                sb.append("liferay-plugin-repository");
                sb.append(".");
                sb.append("xml");
                pluginsXmlURL = sb.toString();
                options = new Http.Options();
                options.setLocation(pluginsXmlURL);
                options.setPost(false);
                bytes = HttpUtil.URLtoByteArray((Http.Options)options);
                response = options.getResponse();
                responseCode = response.getResponseCode();
                if (responseCode != 200) {
                    throw new PluginPackageException(StringBundler.concat((Object[])new Object[]{"Unable to download file ", pluginsXmlURL, " because of response code ", responseCode}));
                }
            }
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                RemotePluginPackageRepository repository = this._parseRepositoryXml(new String(bytes), repositoryURL);
                this._repositoryCache.put(repositoryURL, repository);
                this._availableTagsCache.addAll(repository.getTags());
                this._lastUpdateDate = new Date();
                this._updateAvailable = null;
                return repository;
            }
            this._lastUpdateDate = new Date();
            throw new PluginPackageException("Download returned 0 bytes");
        }
        catch (MalformedURLException malformedURLException) {
            this._repositoryCache.remove(repositoryURL);
            throw new PluginPackageException("Invalid URL " + pluginsXmlURL, malformedURLException);
        }
        catch (IOException ioException) {
            this._repositoryCache.remove(repositoryURL);
            throw new PluginPackageException("Unable to communicate with repository " + repositoryURL, ioException);
        }
        catch (DocumentException documentException) {
            this._repositoryCache.remove(repositoryURL);
            throw new PluginPackageException("Unable to parse plugin list for repository " + repositoryURL, documentException);
        }
    }

    private RemotePluginPackageRepository _parseRepositoryXml(String xml, String repositoryURL) throws DocumentException, PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Loading plugin repository ", repositoryURL, ":\n", xml}));
        }
        RemotePluginPackageRepository pluginPackageRepository = new RemotePluginPackageRepository(repositoryURL);
        if (xml == null) {
            return pluginPackageRepository;
        }
        List<String> supportedPluginTypes = Arrays.asList(PluginPackageUtil.getSupportedTypes());
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        Properties settings = this._readProperties(rootElement.element("settings"), "setting");
        pluginPackageRepository.setSettings(settings);
        List pluginPackageElements = rootElement.elements("plugin-package");
        for (Element pluginPackageElement : pluginPackageElements) {
            PluginPackage pluginPackage = this._readPluginPackageXml(pluginPackageElement);
            if (!this._isCurrentVersionSupported(pluginPackage.getLiferayVersions())) continue;
            boolean containsSupportedTypes = false;
            List pluginTypes = pluginPackage.getTypes();
            for (String pluginType : pluginTypes) {
                if (!supportedPluginTypes.contains(pluginType)) continue;
                containsSupportedTypes = true;
                break;
            }
            if (!containsSupportedTypes) continue;
            pluginPackage.setRepository(pluginPackageRepository);
            pluginPackageRepository.addPluginPackage(pluginPackage);
        }
        return pluginPackageRepository;
    }

    private Date _readDate(String text) {
        block3: {
            if (Validator.isNotNull((String)text)) {
                DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"EEE, dd MMM yyyy HH:mm:ss Z", (Locale)LocaleUtil.US);
                try {
                    return dateFormat.parse(text);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to parse date " + text), (Throwable)exception);
                }
            }
        }
        return new Date();
    }

    private String _readHtml(String text) {
        return GetterUtil.getString((String)text);
    }

    private List<License> _readLicenseList(Element parentElement, String name) {
        ArrayList<License> licenses = new ArrayList<License>();
        for (Element licenseElement : parentElement.elements(name)) {
            Attribute url;
            License license = new License();
            license.setName(licenseElement.getText());
            Attribute osiApproved = licenseElement.attribute("osi-approved");
            if (osiApproved != null) {
                license.setOsiApproved(GetterUtil.getBoolean((String)osiApproved.getText()));
            }
            if ((url = licenseElement.attribute("url")) != null) {
                license.setUrl(url.getText());
            }
            licenses.add(license);
        }
        return licenses;
    }

    private List<String> _readList(Element parentElement, String name) {
        ArrayList<String> list = new ArrayList<String>();
        if (parentElement == null) {
            return list;
        }
        for (Element element : parentElement.elements(name)) {
            String text = StringUtil.toLowerCase((String)StringUtil.trim((String)element.getText()));
            list.add(text);
        }
        return list;
    }

    private PluginPackage _readPluginPackageProperties(String displayName, Properties properties) {
        String[] tagsArray;
        String[] liferayVersionsArray;
        String[] licensesArray;
        int pos = displayName.indexOf("-portlet");
        String pluginType = "portlet";
        if (pos == -1) {
            pos = displayName.indexOf("-ext");
            pluginType = _TYPE_EXT;
        }
        if (pos == -1) {
            pos = displayName.indexOf("-hook");
            pluginType = "hook";
        }
        if (pos == -1) {
            pos = displayName.indexOf("-layouttpl");
            pluginType = "layouttpl";
        }
        if (pos == -1) {
            pos = displayName.indexOf("-theme");
            pluginType = "theme";
        }
        if (pos == -1) {
            pos = displayName.indexOf("-web");
            pluginType = "web";
        }
        if (pos == -1) {
            return null;
        }
        String displayPrefix = displayName.substring(0, pos);
        String moduleGroupId = GetterUtil.getString((String)properties.getProperty("module-group-id"));
        String moduleArtifactId = displayPrefix + "-" + pluginType;
        String moduleVersion = GetterUtil.getString((String)properties.getProperty("module-version"));
        if (Validator.isNull((String)moduleVersion)) {
            String moduleIncrementalVersion;
            int moduleVersionPos = pos + pluginType.length() + 2;
            moduleVersion = displayName.length() > moduleVersionPos ? displayName.substring(moduleVersionPos) : (Validator.isNull((String)(moduleIncrementalVersion = GetterUtil.getString((String)properties.getProperty("module-incremental-version")))) ? ReleaseInfo.getVersion() : ReleaseInfo.getVersion() + "." + moduleIncrementalVersion);
        }
        String moduleId = StringBundler.concat((String[])new String[]{moduleGroupId, "/", moduleArtifactId, "/", moduleVersion, "/war"});
        String pluginName = GetterUtil.getString((String)properties.getProperty("name"));
        String deploymentContext = GetterUtil.getString((String)properties.getProperty("recommended-deployment-context"), (String)moduleArtifactId);
        String author = GetterUtil.getString((String)properties.getProperty("author"));
        ArrayList<String> types = new ArrayList<String>();
        types.add(pluginType);
        ArrayList<License> licenses = new ArrayList<License>();
        for (String curLicenses : licensesArray = StringUtil.split((String)properties.getProperty("licenses"))) {
            License license = new License();
            license.setName(curLicenses.trim());
            license.setOsiApproved(true);
            licenses.add(license);
        }
        ArrayList<String> liferayVersions = new ArrayList<String>();
        for (String liferayVersion : liferayVersionsArray = StringUtil.split((String)properties.getProperty("liferay-versions"))) {
            liferayVersions.add(liferayVersion.trim());
        }
        if (liferayVersions.isEmpty()) {
            liferayVersions.add(ReleaseInfo.getVersion() + "+");
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : tagsArray = StringUtil.split((String)properties.getProperty("tags"))) {
            tags.add(tag.trim());
        }
        String shortDescription = GetterUtil.getString((String)properties.getProperty("short-description"));
        String longDescription = GetterUtil.getString((String)properties.getProperty("long-description"));
        String changeLog = GetterUtil.getString((String)properties.getProperty("change-log"));
        String pageURL = GetterUtil.getString((String)properties.getProperty("page-url"));
        String downloadURL = GetterUtil.getString((String)properties.getProperty("download-url"));
        List requiredDeploymentContexts = ListUtil.fromArray((Object[])StringUtil.split((String)properties.getProperty("required-deployment-contexts")));
        PluginPackageImpl pluginPackage = new PluginPackageImpl(moduleId);
        pluginPackage.setName(pluginName);
        pluginPackage.setRecommendedDeploymentContext(deploymentContext);
        pluginPackage.setAuthor(author);
        pluginPackage.setTypes(types);
        pluginPackage.setLicenses(licenses);
        pluginPackage.setLiferayVersions(liferayVersions);
        pluginPackage.setTags(tags);
        pluginPackage.setShortDescription(shortDescription);
        pluginPackage.setLongDescription(longDescription);
        pluginPackage.setChangeLog(changeLog);
        pluginPackage.setPageURL(pageURL);
        pluginPackage.setDownloadURL(downloadURL);
        pluginPackage.setRequiredDeploymentContexts(requiredDeploymentContexts);
        return pluginPackage;
    }

    private PluginPackage _readPluginPackageServletContext(ServletContext servletContext) throws DocumentException, IOException {
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            if (servletContextName == null) {
                _log.debug((Object)"Reading plugin package for the root context");
            } else {
                _log.debug((Object)("Reading plugin package for " + servletContextName));
            }
        }
        PluginPackage pluginPackage = null;
        String xml = StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-plugin-package.xml"));
        if (xml != null) {
            pluginPackage = this._readPluginPackageXml(xml);
        } else {
            String propertiesString = StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-plugin-package.properties"));
            if (propertiesString != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Reading plugin package from liferay-plugin-package.properties");
                }
                Properties properties = PropertiesUtil.load((String)propertiesString);
                String displayName = servletContextName;
                if (displayName.startsWith("/")) {
                    displayName = displayName.substring(1);
                }
                pluginPackage = this._readPluginPackageProperties(displayName, properties);
            }
            if (pluginPackage == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Reading plugin package from MANIFEST.MF");
                }
                pluginPackage = this._readPluginPackageServletManifest(servletContext);
            }
        }
        pluginPackage.setContext(servletContextName);
        return pluginPackage;
    }

    private PluginPackage _readPluginPackageServletManifest(ServletContext servletContext) throws IOException {
        String pageURL;
        String version;
        String artifactId;
        Attributes attributes = null;
        String servletContextName = servletContext.getServletContextName();
        InputStream inputStream = servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");
        if (inputStream != null) {
            Manifest manifest = new Manifest(inputStream);
            attributes = manifest.getMainAttributes();
        } else {
            attributes = new Attributes();
        }
        String artifactGroupId = attributes.getValue("Implementation-Vendor-Id");
        if (Validator.isNull((String)artifactGroupId)) {
            artifactGroupId = attributes.getValue("Implementation-Vendor");
        }
        if (Validator.isNull((String)artifactGroupId)) {
            artifactGroupId = GetterUtil.getString((String)attributes.getValue("Bundle-Vendor"), (String)servletContextName);
        }
        if (Validator.isNull((String)(artifactId = attributes.getValue("Implementation-Title")))) {
            artifactId = GetterUtil.getString((String)attributes.getValue("Bundle-Name"), (String)servletContextName);
        }
        if (Validator.isNull((String)(version = attributes.getValue("Implementation-Version")))) {
            version = GetterUtil.getString((String)attributes.getValue("Bundle-Version"), (String)"unknown");
        }
        if (version.equals("unknown") && _log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Plugin package on context ", servletContextName, " cannot be tracked because this WAR does not contain a ", "liferay-plugin-package.xml file"}));
        }
        PluginPackageImpl pluginPackage = new PluginPackageImpl(StringBundler.concat((String[])new String[]{artifactGroupId, "/", artifactId, "/", version, "/war"}));
        pluginPackage.setName(artifactId);
        String shortDescription = attributes.getValue("Bundle-Description");
        if (Validator.isNotNull((String)shortDescription)) {
            pluginPackage.setShortDescription(shortDescription);
        }
        if (Validator.isNotNull((String)(pageURL = attributes.getValue("Bundle-DocURL")))) {
            pluginPackage.setPageURL(pageURL);
        }
        return pluginPackage;
    }

    private PluginPackage _readPluginPackageXml(Element pluginPackageElement) {
        String name = pluginPackageElement.elementText("name");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading pluginPackage definition " + name));
        }
        PluginPackageImpl pluginPackage = new PluginPackageImpl(GetterUtil.getString((String)pluginPackageElement.elementText("module-id")));
        List<String> liferayVersions = this._readList(pluginPackageElement.element("liferay-versions"), "liferay-version");
        List<String> types = this._readList(pluginPackageElement.element("types"), "type");
        if (types.contains("layout-template")) {
            types.remove("layout-template");
            types.add("layouttpl");
        }
        pluginPackage.setName(this._readText(name));
        pluginPackage.setRecommendedDeploymentContext(this._readText(pluginPackageElement.elementText("recommended-deployment-context")));
        pluginPackage.setRequiredDeploymentContexts(this._readList(pluginPackageElement.element("required-deployment-contexts"), "required-deployment-context"));
        pluginPackage.setModifiedDate(this._readDate(pluginPackageElement.elementText("modified-date")));
        pluginPackage.setAuthor(this._readText(pluginPackageElement.elementText("author")));
        pluginPackage.setTypes(types);
        pluginPackage.setLicenses(this._readLicenseList(pluginPackageElement.element("licenses"), "license"));
        pluginPackage.setLiferayVersions(liferayVersions);
        pluginPackage.setTags(this._readList(pluginPackageElement.element("tags"), "tag"));
        pluginPackage.setShortDescription(this._readText(pluginPackageElement.elementText("short-description")));
        pluginPackage.setLongDescription(this._readHtml(pluginPackageElement.elementText("long-description")));
        pluginPackage.setChangeLog(this._readHtml(pluginPackageElement.elementText("change-log")));
        pluginPackage.setScreenshots(this._readScreenshots(pluginPackageElement.element("screenshots")));
        pluginPackage.setPageURL(this._readText(pluginPackageElement.elementText("page-url")));
        pluginPackage.setDownloadURL(this._readText(pluginPackageElement.elementText("download-url")));
        pluginPackage.setDeploymentSettings(this._readProperties(pluginPackageElement.element("deployment-settings"), "setting"));
        return pluginPackage;
    }

    private PluginPackage _readPluginPackageXml(String xml) throws DocumentException {
        Document document = SAXReaderUtil.read((String)xml);
        return this._readPluginPackageXml(document.getRootElement());
    }

    private Properties _readProperties(Element parentElement, String name) {
        Properties properties = new Properties();
        if (parentElement == null) {
            return properties;
        }
        for (Element element : parentElement.elements(name)) {
            properties.setProperty(element.attributeValue("name"), element.attributeValue("value"));
        }
        return properties;
    }

    private List<Screenshot> _readScreenshots(Element parentElement) {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        if (parentElement == null) {
            return screenshots;
        }
        for (Element screenshotElement : parentElement.elements("screenshot")) {
            Screenshot screenshot = new Screenshot();
            screenshot.setThumbnailURL(screenshotElement.elementText("thumbnail-url"));
            screenshot.setLargeImageURL(screenshotElement.elementText("large-image-url"));
            screenshots.add(screenshot);
        }
        return screenshots;
    }

    private String _readText(String text) {
        return HtmlUtil.extractText((String)GetterUtil.getString((String)text));
    }

    private void _refreshUpdatesAvailableCache() {
        this._updateAvailable = null;
    }

    private void _registerInstalledPluginPackage(PluginPackage pluginPackage) throws PortalException {
        this._installedPluginPackages.addPluginPackage(pluginPackage);
        this._updateAvailable = null;
    }

    private void _registerPluginPackageInstallation(String preliminaryContext) {
        this._installedPluginPackages.registerPluginPackageInstallation(preliminaryContext);
    }

    private RepositoryReport _reloadRepositories() throws PortalException {
        String[] repositoryURLs;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Reloading repositories");
        }
        RepositoryReport repositoryReport = new RepositoryReport();
        for (String repositoryURL : repositoryURLs = this._getRepositoryURLs()) {
            try {
                this._loadRepository(repositoryURL);
                repositoryReport.addSuccess(repositoryURL);
            }
            catch (PluginPackageException pluginPackageException) {
                repositoryReport.addError(repositoryURL, pluginPackageException);
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to load repository ", repositoryURL, " ", pluginPackageException.toString()}));
            }
        }
        return repositoryReport;
    }

    private void _unregisterInstalledPluginPackage(PluginPackage pluginPackage) throws PortalException {
        this._installedPluginPackages.removePluginPackage(pluginPackage);
    }

    private void _updateInstallingPluginPackage(String preliminaryContext, PluginPackage pluginPackage) {
        this._installedPluginPackages.unregisterPluginPackageInstallation(preliminaryContext);
        this._installedPluginPackages.registerPluginPackageInstallation(pluginPackage);
    }

    private class UpdateAvailableRunner
    implements Runnable {
        private UpdateAvailableRunner() {
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.setUpdateAvailable();
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)exception.getMessage());
                }
            }
        }

        protected void setUpdateAvailable() throws Exception {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Checking for available updates");
            }
            for (PluginPackage pluginPackage : PluginPackageUtil.this._installedPluginPackages.getPluginPackages()) {
                Version availablePluginPackageVersion;
                PluginPackage availablePluginPackage;
                if (PluginPackageUtil.this._isIgnored(pluginPackage) || (availablePluginPackage = PluginPackageUtil.getLatestAvailablePluginPackage(pluginPackage.getGroupId(), pluginPackage.getArtifactId())) == null || !(availablePluginPackageVersion = Version.getInstance((String)availablePluginPackage.getVersion())).isLaterVersionThan(pluginPackage.getVersion())) continue;
                PluginPackageUtil.this._updateAvailable = Boolean.TRUE;
                break;
            }
            if (PluginPackageUtil.this._updateAvailable == null) {
                PluginPackageUtil.this._updateAvailable = Boolean.FALSE;
            }
            PluginPackageUtil.this._settingUpdateAvailable = false;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Finished checking for available updates in " + stopWatch.getTime() + " ms"));
            }
        }
    }
}

