/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.PluginPackageException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RepositoryReport
implements Serializable {
    public static final String SUCCESS = "success";
    private final Map<String, String> _reportMap = new TreeMap<String, String>();

    public void addError(String repositoryURL, PluginPackageException pluginPackageException) {
        Throwable throwable;
        StringBundler sb = new StringBundler(2);
        if (Validator.isNotNull((String)pluginPackageException.getMessage())) {
            sb.append(pluginPackageException.getMessage());
        }
        if (pluginPackageException.getCause() != null && Validator.isNotNull((String)(throwable = pluginPackageException.getCause()).getMessage())) {
            sb.append(throwable.getMessage());
        }
        if (sb.index() == 0) {
            sb.append(pluginPackageException.toString());
        }
        this._reportMap.put(repositoryURL, sb.toString());
    }

    public void addSuccess(String repositoryURL) {
        this._reportMap.put(repositoryURL, SUCCESS);
    }

    public Set<String> getRepositoryURLs() {
        return this._reportMap.keySet();
    }

    public String getState(String repositoryURL) {
        return this._reportMap.get(repositoryURL);
    }

    public String toString() {
        Set<String> repositoryURLs = this.getRepositoryURLs();
        if (repositoryURLs.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(repositoryURLs.size() * 3);
        for (String repositoryURL : repositoryURLs) {
            sb.append(repositoryURL);
            sb.append(": ");
            sb.append(this._reportMap.get(repositoryURL));
        }
        return sb.toString();
    }
}

