/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.access.control;

import com.liferay.portal.kernel.security.access.control.AccessControlPolicy;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.security.access.control.AccessControlAdvisor;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AccessControlAdvisorImpl
implements AccessControlAdvisor {
    private static final List<AccessControlPolicy> _accessControlPolicies = new CopyOnWriteArrayList<AccessControlPolicy>();
    private static final ServiceTracker<?, ?> _serviceTracker;

    @Override
    public void accept(Method method, Object[] arguments, AccessControlled accessControlled) throws SecurityException {
        if (AccessControlThreadLocal.isRemoteAccess()) {
            for (AccessControlPolicy accessControlPolicy : _accessControlPolicies) {
                accessControlPolicy.onServiceRemoteAccess(method, arguments, accessControlled);
            }
        } else {
            for (AccessControlPolicy accessControlPolicy : _accessControlPolicies) {
                accessControlPolicy.onServiceAccess(method, arguments, accessControlled);
            }
        }
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(AccessControlPolicy.class, (ServiceTrackerCustomizer)new AccessControlPolicyTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class AccessControlPolicyTrackerCustomizer
    implements ServiceTrackerCustomizer<AccessControlPolicy, AccessControlPolicy> {
        private AccessControlPolicyTrackerCustomizer() {
        }

        public AccessControlPolicy addingService(ServiceReference<AccessControlPolicy> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            AccessControlPolicy accessControlPolicy = (AccessControlPolicy)registry.getService(serviceReference);
            _accessControlPolicies.add(accessControlPolicy);
            return accessControlPolicy;
        }

        public void modifiedService(ServiceReference<AccessControlPolicy> serviceReference, AccessControlPolicy accessControlPolicy) {
        }

        public void removedService(ServiceReference<AccessControlPolicy> serviceReference, AccessControlPolicy accessControlPolicy) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            _accessControlPolicies.remove(accessControlPolicy);
        }
    }
}

