/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.registry;

import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.AuthVerifierPipeline;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceReferenceMapperFactory;
import com.liferay.registry.collections.ServiceTrackerMap;
import com.liferay.registry.collections.ServiceTrackerMapFactory;
import com.liferay.registry.collections.ServiceTrackerMapFactoryUtil;
import java.util.HashMap;
import java.util.Properties;

public class AuthVerifierRegistry {
    private static final ServiceTrackerMap<String, AuthVerifier> _serviceTrackerMap;

    public static AuthVerifier getAuthVerifier(String simpleClassName) {
        return (AuthVerifier)_serviceTrackerMap.getService((Object)simpleClassName);
    }

    private static AuthVerifierConfiguration _buildAuthVerifierConfiguration(ServiceReference<AuthVerifier> serviceReference, AuthVerifier authVerifier) {
        Class<?> clazz = authVerifier.getClass();
        String authVerifierPropertyName = AuthVerifierPipeline.getAuthVerifierPropertyName(clazz.getName());
        Properties properties = new Properties();
        for (String propertyKey : serviceReference.getPropertyKeys()) {
            if (!propertyKey.startsWith(authVerifierPropertyName)) continue;
            properties.put(propertyKey.substring(authVerifierPropertyName.length()), serviceReference.getProperty(propertyKey));
        }
        if (properties.isEmpty()) {
            return null;
        }
        AuthVerifierConfiguration authVerifierConfiguration = new AuthVerifierConfiguration();
        authVerifierConfiguration.setAuthVerifierClassName(clazz.getName());
        authVerifierConfiguration.setProperties(properties);
        return authVerifierConfiguration;
    }

    static {
        ServiceTrackerMapFactory serviceTrackerMapFactory = ServiceTrackerMapFactoryUtil.getServiceTrackerMapFactory();
        ServiceReferenceMapper authVerifierServiceReferenceMapper = ServiceReferenceMapperFactory.create((authVerifier, emitter) -> {
            Class<?> clazz = authVerifier.getClass();
            emitter.emit((Object)clazz.getSimpleName());
        });
        _serviceTrackerMap = serviceTrackerMapFactory.openSingleValueMap(AuthVerifier.class, null, (serviceReference, emitter) -> {
            String authVerifierClassName = GetterUtil.getString((Object)serviceReference.getProperty("auth.verifier.class.name"));
            if (Validator.isNotNull((String)authVerifierClassName)) {
                emitter.emit((Object)authVerifierClassName);
            } else {
                authVerifierServiceReferenceMapper.map(serviceReference, emitter);
            }
        });
        final Registry registry = RegistryUtil.getRegistry();
        ServiceTracker serviceTracker = registry.trackServices(AuthVerifier.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<AuthVerifier, Tracked>(){

            public Tracked addingService(ServiceReference<AuthVerifier> serviceReference) {
                Registry registry2 = RegistryUtil.getRegistry();
                AuthVerifier authVerifier = (AuthVerifier)registry2.getService(serviceReference);
                AuthVerifierConfiguration authVerifierConfiguration = AuthVerifierRegistry._buildAuthVerifierConfiguration((ServiceReference<AuthVerifier>)serviceReference, authVerifier);
                ServiceRegistration serviceRegistration = null;
                if (authVerifierConfiguration != null) {
                    serviceRegistration = registry2.registerService(AuthVerifierConfiguration.class, (Object)authVerifierConfiguration, new HashMap());
                }
                return new Tracked(authVerifier, serviceRegistration);
            }

            public void modifiedService(ServiceReference<AuthVerifier> serviceReference, Tracked tracked) {
                AuthVerifierConfiguration authVerifierConfiguration;
                ServiceRegistration<AuthVerifierConfiguration> serviceRegistration = tracked.getServiceRegistration();
                if (serviceRegistration != null) {
                    serviceRegistration.unregister();
                }
                if ((authVerifierConfiguration = AuthVerifierRegistry._buildAuthVerifierConfiguration((ServiceReference<AuthVerifier>)serviceReference, tracked.getAuthVerifier())) != null) {
                    registry.registerService(AuthVerifierConfiguration.class, (Object)authVerifierConfiguration, new HashMap());
                }
                tracked.setServiceRegistration(serviceRegistration);
            }

            public void removedService(ServiceReference<AuthVerifier> serviceReference, Tracked tracked) {
                ServiceRegistration<AuthVerifierConfiguration> serviceRegistration = tracked.getServiceRegistration();
                if (serviceRegistration != null) {
                    serviceRegistration.unregister();
                }
                Registry registry2 = RegistryUtil.getRegistry();
                registry2.ungetService(serviceReference);
            }
        });
        serviceTracker.open();
    }

    private static class Tracked {
        private AuthVerifier _authVerifier;
        private ServiceRegistration<AuthVerifierConfiguration> _serviceRegistration;

        public AuthVerifier getAuthVerifier() {
            return this._authVerifier;
        }

        public ServiceRegistration<AuthVerifierConfiguration> getServiceRegistration() {
            return this._serviceRegistration;
        }

        public void setAuthVerifier(AuthVerifier authVerifier) {
            this._authVerifier = authVerifier;
        }

        public void setServiceRegistration(ServiceRegistration<AuthVerifierConfiguration> serviceRegistration) {
            this._serviceRegistration = serviceRegistration;
        }

        private Tracked(AuthVerifier authVerifier, ServiceRegistration<AuthVerifierConfiguration> serviceRegistration) {
            this._authVerifier = authVerifier;
            this._serviceRegistration = serviceRegistration;
        }
    }
}

