/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.contributor.RoleContributor;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;

public class PermissionCheckerUtil {
    private static final Log _log = LogFactoryUtil.getLog(PermissionCheckerUtil.class);
    private static final ServiceTrackerList<RoleContributor> _roleContributors = ServiceTrackerCollections.openList(RoleContributor.class);

    public static void setThreadValues(User user) {
        if (user == null) {
            PrincipalThreadLocal.setName(null);
            PermissionThreadLocal.setPermissionChecker(null);
            return;
        }
        PrincipalThreadLocal.setName((String)String.valueOf(user.getUserId()));
        try {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker == null) {
                Class<?> clazz = Class.forName(PropsValues.PERMISSIONS_CHECKER);
                permissionChecker = (PermissionChecker)clazz.newInstance();
            }
            permissionChecker.init(user, (RoleContributor[])_roleContributors.toArray((Object[])new RoleContributor[0]));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }
}

