/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso;

import com.liferay.portal.kernel.security.sso.OpenSSO;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class OpenSSOUtil {
    private static final OpenSSOUtil _openSSOUtil = new OpenSSOUtil();
    private final ServiceTracker<OpenSSO, OpenSSO> _serviceTracker;

    public static Map<String, String> getAttributes(HttpServletRequest httpServletRequest, String serviceUrl) {
        return OpenSSOUtil._getOpenSSO().getAttributes(httpServletRequest, serviceUrl);
    }

    public static String getSubjectId(HttpServletRequest httpServletRequest, String serviceUrl) {
        return OpenSSOUtil._getOpenSSO().getSubjectId(httpServletRequest, serviceUrl);
    }

    public static boolean isAuthenticated(HttpServletRequest httpServletRequest, String serviceUrl) throws IOException {
        return OpenSSOUtil._getOpenSSO().isAuthenticated(httpServletRequest, serviceUrl);
    }

    public static boolean isValidServiceUrl(String serviceUrl) {
        return OpenSSOUtil._getOpenSSO().isValidServiceUrl(serviceUrl);
    }

    public static boolean isValidUrl(String url) {
        return OpenSSOUtil._getOpenSSO().isValidUrl(url);
    }

    public static boolean isValidUrls(String[] urls) {
        return OpenSSOUtil._getOpenSSO().isValidUrls(urls);
    }

    private static OpenSSO _getOpenSSO() {
        return (OpenSSO)OpenSSOUtil._openSSOUtil._serviceTracker.getService();
    }

    private OpenSSOUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(OpenSSO.class);
        this._serviceTracker.open();
    }
}

