/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ContactServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class ContactServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ContactServiceHttp.class);
    private static final Class<?>[] _getCompanyContactsParameterTypes0 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getCompanyContactsCountParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getContactParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getContactsParameterTypes3 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getContactsCountParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE};

    public static List<Contact> getCompanyContacts(HttpPrincipal httpPrincipal, long companyId, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getCompanyContacts", (Class[])_getCompanyContactsParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getCompanyContactsCount(HttpPrincipal httpPrincipal, long companyId) {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getCompanyContactsCount", (Class[])_getCompanyContactsCountParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Contact getContact(HttpPrincipal httpPrincipal, long contactId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getContact", (Class[])_getContactParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{contactId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Contact)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Contact> getContacts(HttpPrincipal httpPrincipal, long classNameId, long classPK, int start, int end, OrderByComparator<Contact> orderByComparator) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getContacts", (Class[])_getContactsParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{classNameId, classPK, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getContactsCount(HttpPrincipal httpPrincipal, long classNameId, long classPK) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getContactsCount", (Class[])_getContactsCountParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{classNameId, classPK});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

