/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.CountryServiceBaseImpl;
import com.liferay.portal.util.PortalInstances;
import java.util.List;

public class CountryServiceImpl
extends CountryServiceBaseImpl {
    public Country addCountry(String a2, String a3, boolean active, boolean billingAllowed, String idd, String name, String number, double position, boolean shippingAllowed, boolean subjectToVAT, boolean zipRequired, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COUNTRIES");
        return this.countryLocalService.addCountry(a2, a3, active, billingAllowed, idd, name, number, position, shippingAllowed, subjectToVAT, zipRequired, serviceContext);
    }

    @Deprecated
    public Country addCountry(String name, String a2, String a3, String number, String idd, boolean active) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        PermissionChecker permissionChecker = this.getPermissionChecker();
        serviceContext.setCompanyId(permissionChecker.getCompanyId());
        serviceContext.setUserId(permissionChecker.getUserId());
        return this.addCountry(a2, a3, active, true, idd, name, number, 0.0, true, false, true, serviceContext);
    }

    public void deleteCountry(long countryId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COUNTRIES");
        this.countryLocalService.deleteCountry(countryId);
    }

    public Country fetchCountry(long countryId) {
        return this.countryLocalService.fetchCountry(countryId);
    }

    public Country fetchCountryByA2(long companyId, String a2) {
        return this.countryLocalService.fetchCountryByA2(companyId, a2);
    }

    @Deprecated
    public Country fetchCountryByA2(String a2) {
        return this.fetchCountryByA2(PortalInstances.getDefaultCompanyId(), a2);
    }

    public Country fetchCountryByA3(long companyId, String a3) {
        return this.countryLocalService.fetchCountryByA3(companyId, a3);
    }

    @Deprecated
    public Country fetchCountryByA3(String a3) {
        return this.fetchCountryByA3(PortalInstances.getDefaultCompanyId(), a3);
    }

    public List<Country> getCompanyCountries(long companyId) {
        return this.countryLocalService.getCompanyCountries(companyId);
    }

    @AccessControlled(guestAccessEnabled=true)
    public List<Country> getCompanyCountries(long companyId, boolean active) {
        return this.countryLocalService.getCompanyCountries(companyId, active);
    }

    public List<Country> getCompanyCountries(long companyId, boolean active, int start, int end, OrderByComparator<Country> orderByComparator) {
        return this.countryLocalService.getCompanyCountries(companyId, active, start, end, orderByComparator);
    }

    public List<Country> getCompanyCountries(long companyId, int start, int end, OrderByComparator<Country> orderByComparator) {
        return this.countryLocalService.getCompanyCountries(companyId, start, end, orderByComparator);
    }

    public int getCompanyCountriesCount(long companyId) {
        return this.countryLocalService.getCompanyCountriesCount(companyId);
    }

    public int getCompanyCountriesCount(long companyId, boolean active) {
        return this.countryLocalService.getCompanyCountriesCount(companyId, active);
    }

    @Deprecated
    public List<Country> getCountries() {
        return this.getCompanyCountries(PortalInstances.getDefaultCompanyId());
    }

    @AccessControlled(guestAccessEnabled=true)
    @Deprecated
    public List<Country> getCountries(boolean active) {
        return this.getCompanyCountries(PortalInstances.getDefaultCompanyId(), active);
    }

    public Country getCountry(long countryId) throws PortalException {
        return this.countryLocalService.getCountry(countryId);
    }

    public Country getCountryByA2(long companyId, String a2) throws PortalException {
        return this.countryLocalService.getCountryByA2(companyId, a2);
    }

    @Deprecated
    public Country getCountryByA2(String a2) throws PortalException {
        return this.getCountryByA2(PortalInstances.getDefaultCompanyId(), a2);
    }

    public Country getCountryByA3(long companyId, String a3) throws PortalException {
        return this.countryLocalService.getCountryByA3(companyId, a3);
    }

    @Deprecated
    public Country getCountryByA3(String a3) throws PortalException {
        return this.getCountryByA3(PortalInstances.getDefaultCompanyId(), a3);
    }

    public Country getCountryByName(long companyId, String name) throws PortalException {
        return this.countryLocalService.getCountryByName(companyId, name);
    }

    @Deprecated
    public Country getCountryByName(String name) throws PortalException {
        return this.getCountryByName(PortalInstances.getDefaultCompanyId(), name);
    }

    public Country getCountryByNumber(long companyId, String number) throws PortalException {
        return this.countryLocalService.getCountryByNumber(companyId, number);
    }

    public BaseModelSearchResult<Country> searchCountries(long companyId, Boolean active, String keywords, int start, int end, OrderByComparator<Country> orderByComparator) throws PortalException {
        return this.countryLocalService.searchCountries(companyId, active, keywords, start, end, orderByComparator);
    }

    public Country updateActive(long countryId, boolean active) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COUNTRIES");
        return this.countryLocalService.updateActive(countryId, active);
    }

    public Country updateCountry(long countryId, String a2, String a3, boolean active, boolean billingAllowed, String idd, String name, String number, double position, boolean shippingAllowed, boolean subjectToVAT) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COUNTRIES");
        return this.countryLocalService.updateCountry(countryId, a2, a3, active, billingAllowed, idd, name, number, position, shippingAllowed, subjectToVAT);
    }

    public Country updateGroupFilterEnabled(long countryId, boolean groupFilterEnabled) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COUNTRIES");
        return this.countryLocalService.updateGroupFilterEnabled(countryId, groupFilterEnabled);
    }
}

