/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.exception.RemoteExportException;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.StagingURLHelperUtil;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.DataLimitExceededException;
import com.liferay.portal.kernel.exception.DuplicateGroupException;
import com.liferay.portal.kernel.exception.GroupFriendlyURLException;
import com.liferay.portal.kernel.exception.GroupInheritContentException;
import com.liferay.portal.kernel.exception.GroupKeyException;
import com.liferay.portal.kernel.exception.GroupParentException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchCompanyException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutSetException;
import com.liferay.portal.kernel.exception.PendingBackgroundTaskException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RemoteOptionsException;
import com.liferay.portal.kernel.exception.RequiredGroupException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.model.UserPersonalSite;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.search.reindexer.ReindexerBridge;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.RemoteAuthException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.RolePermissions;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.tree.TreeModelTasks;
import com.liferay.portal.kernel.tree.TreeModelTasksAdapter;
import com.liferay.portal.kernel.tree.TreePathUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupIdComparator;
import com.liferay.portal.kernel.util.comparator.GroupNameComparator;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.GroupLocalServiceBaseImpl;
import com.liferay.portal.service.http.ClassNameServiceHttp;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.io.File;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class GroupLocalServiceImpl
extends GroupLocalServiceBaseImpl {
    public static final String ORGANIZATION_NAME_SUFFIX = " LFR_ORGANIZATION";
    public static final String ORGANIZATION_STAGING_SUFFIX = " (Staging)";
    protected File publicLARFile;
    private static final Class<?>[] _CHECK_REMOTE_STAGING_GROUP_PARAMETER_TYPES = new Class[]{Long.TYPE};
    private static final Log _log = LogFactoryUtil.getLog(GroupLocalServiceImpl.class);
    private static volatile ReindexerBridge _reindexerBridge = (ReindexerBridge)ServiceProxyFactory.newServiceTrackedInstance(ReindexerBridge.class, GroupLocalServiceImpl.class, (String)"_reindexerBridge", (boolean)false);
    private volatile long[] _classNameIds;
    private volatile long[] _complexSQLClassNameIds;
    private final Map<String, Group> _systemGroupsMap = new HashMap<String, Group>();

    public GroupLocalServiceImpl() {
        this.initImportLARFile();
    }

    public Group addGroup(long userId, long parentGroupId, String className, long classPK, long liveGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean inheritContent, boolean active, ServiceContext serviceContext) throws PortalException {
        User screenNameUser;
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (site && PropsValues.DATA_LIMIT_SITE_MAX_COUNT > 0L && (long)this.groupPersistence.countByC_S(user.getCompanyId(), site) >= PropsValues.DATA_LIMIT_SITE_MAX_COUNT) {
            throw new DataLimitExceededException("Unable to exceed maximum number of allowed sites");
        }
        className = GetterUtil.getString((String)className);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        String groupKey = "";
        String friendlyName = "";
        if (nameMap != null) {
            Locale mostRelevantLocale;
            Locale userLocale;
            nameMap = this._normalizeNameMap(nameMap);
            groupKey = nameMap.get(LocaleUtil.getDefault());
            friendlyName = nameMap.get(LocaleUtil.getDefault());
            if (Validator.isNull((String)groupKey) && (userLocale = user.getLocale()) != null) {
                groupKey = nameMap.get(userLocale);
                friendlyName = nameMap.get(userLocale);
            }
            if (Validator.isNull((String)groupKey) && (mostRelevantLocale = LocaleUtil.getMostRelevantLocale()) != null) {
                groupKey = nameMap.get(mostRelevantLocale);
                friendlyName = nameMap.get(mostRelevantLocale);
            }
            if (Validator.isNull((String)groupKey)) {
                groupKey = nameMap.get(LocaleUtil.US);
                friendlyName = nameMap.get(LocaleUtil.US);
            }
        }
        long groupId = 0L;
        do {
            groupId = this.counterLocalService.increment();
        } while ((screenNameUser = this.userPersistence.fetchByC_SN(user.getCompanyId(), String.valueOf(groupId))) != null);
        boolean staging = this.isStaging(serviceContext);
        long groupClassNameId = this.classNameLocalService.getClassNameId(Group.class);
        if (classNameId <= 0L || className.equals(Group.class.getName()) || className.equals(Company.class.getName()) && staging) {
            className = Group.class.getName();
            classNameId = groupClassNameId;
            classPK = groupId;
        } else if (className.equals(Organization.class.getName())) {
            groupKey = this.getOrgGroupName(groupKey);
        } else if (type != 5 && !"User Personal Site".equals(groupKey)) {
            groupKey = String.valueOf(classPK);
        }
        if (className.equals(Organization.class.getName()) && staging) {
            classPK = liveGroupId;
        }
        if (className.equals(Layout.class.getName())) {
            Layout layout = this.layoutLocalService.getLayout(classPK);
            parentGroupId = layout.getGroupId();
        }
        friendlyURL = this.getFriendlyURL(user.getCompanyId(), groupId, classNameId, classPK, friendlyName, friendlyURL);
        if (staging) {
            groupKey = groupKey.concat("-staging");
            for (Map.Entry entry : nameMap.entrySet()) {
                String name = (String)entry.getValue();
                if (Validator.isNull((String)name)) continue;
                nameMap.put((Locale)entry.getKey(), name.concat(ORGANIZATION_STAGING_SUFFIX));
            }
            friendlyURL = this.getFriendlyURL(friendlyURL.concat("-staging"));
            friendlyURL = this.getValidatedFriendlyURL(user.getCompanyId(), groupId, classNameId, classPK, friendlyURL);
        }
        if (parentGroupId == 0L) {
            membershipRestriction = 0;
        }
        if (className.equals(Group.class.getName()) ? !site && liveGroupId == 0L && !StringUtil.startsWith((String)groupKey, (String)"App") && !groupKey.equals("Control Panel") && !groupKey.equals("Forms") : !className.equals(Company.class.getName()) && !className.equals(Organization.class.getName()) && className.startsWith("com.liferay.portal.kernel.model.") && site) {
            throw new IllegalArgumentException();
        }
        if (classNameId <= 0L || type == 5 || className.equals(Group.class.getName())) {
            this.validateGroupKey(groupId, user.getCompanyId(), groupKey, type, site);
        }
        this.validateInheritContent(parentGroupId, inheritContent);
        friendlyURL = this.getValidatedFriendlyURL(user.getCompanyId(), groupId, classNameId, classPK, friendlyURL);
        this.validateParentGroup(groupId, parentGroupId);
        Group group = this.groupPersistence.create(groupId);
        if (serviceContext != null) {
            group.setUuid(serviceContext.getUuid());
        }
        group.setCompanyId(user.getCompanyId());
        group.setCreatorUserId(userId);
        group.setClassNameId(classNameId);
        group.setClassPK(classPK);
        group.setParentGroupId(parentGroupId);
        group.setLiveGroupId(liveGroupId);
        group.setTreePath(group.buildTreePath());
        group.setGroupKey(groupKey);
        group.setNameMap(nameMap);
        group.setDescriptionMap(descriptionMap);
        group.setType(type);
        group.setManualMembership(manualMembership);
        group.setMembershipRestriction(membershipRestriction);
        group.setFriendlyURL(friendlyURL);
        group.setSite(site);
        group.setInheritContent(inheritContent);
        group.setActive(active);
        if (serviceContext != null && classNameId == groupClassNameId && !user.isDefaultUser()) {
            group.setExpandoBridgeAttributes(serviceContext);
        }
        group = (Group)this.groupPersistence.update((BaseModel)group);
        this.layoutSetLocalService.addLayoutSet(groupId, true);
        this.layoutSetLocalService.addLayoutSet(groupId, false);
        this.resourceLocalService.addResources(group.getCompanyId(), 0L, 0L, Group.class.getName(), group.getGroupId(), false, false, false);
        if (classNameId == groupClassNameId && !user.isDefaultUser()) {
            Role role = this.roleLocalService.getRole(group.getCompanyId(), "Site Owner");
            this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, new long[]{role.getRoleId()});
            this.userLocalService.addGroupUsers(group.getGroupId(), new long[]{userId});
            if (serviceContext != null) {
                this.updateAsset(userId, group, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
            }
        }
        this.addPortletDefaultData(group);
        return group;
    }

    public Group addGroup(long userId, long parentGroupId, String className, long classPK, long liveGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.addGroup(userId, parentGroupId, className, classPK, liveGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, site, false, active, serviceContext);
    }

    @Override
    public void addOrganizationGroup(long organizationId, Group group) {
        super.addOrganizationGroup(organizationId, group);
        try {
            this.reindexUsersInOrganization(organizationId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addOrganizationGroup(long organizationId, long groupId) {
        super.addOrganizationGroup(organizationId, groupId);
        try {
            this.reindexUsersInOrganization(organizationId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addOrganizationGroups(long organizationId, List<Group> groups) {
        super.addOrganizationGroups(organizationId, groups);
        try {
            this.reindexUsersInOrganization(organizationId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addOrganizationGroups(long organizationId, long[] groupIds) {
        super.addOrganizationGroups(organizationId, groupIds);
        try {
            this.reindexUsersInOrganization(organizationId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addUserGroupGroup(long userGroupId, Group group) {
        super.addUserGroupGroup(userGroupId, group);
        try {
            this.reindexUsersInUserGroup(userGroupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addUserGroupGroup(long userGroupId, long groupId) {
        super.addUserGroupGroup(userGroupId, groupId);
        try {
            this.reindexUsersInUserGroup(userGroupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addUserGroupGroups(long userGroupId, List<Group> groups) {
        super.addUserGroupGroups(userGroupId, groups);
        try {
            this.reindexUsersInUserGroup(userGroupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addUserGroupGroups(long userGroupId, long[] groupIds) {
        super.addUserGroupGroups(userGroupId, groupIds);
        try {
            this.reindexUsersInUserGroup(userGroupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkCompanyGroup(long companyId) throws PortalException {
        int count = this.groupPersistence.countByC_C_C(companyId, this.classNameLocalService.getClassNameId(Company.class), companyId);
        if (count == 0) {
            this.groupLocalService.addGroup(this.userLocalService.getDefaultUserId(companyId), 0L, Company.class.getName(), companyId, 0L, this.getLocalizationMap("Global"), null, 0, true, 0, "/global", true, true, null);
        }
    }

    public Group checkScopeGroup(Layout layout, long userId) throws PortalException {
        if (layout.hasScopeGroup()) {
            return layout.getScopeGroup();
        }
        return this.groupLocalService.addGroup(userId, 0L, Layout.class.getName(), layout.getPlid(), 0L, (Map)HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)String.valueOf(layout.getPlid())).build(), null, 0, true, 0, null, false, true, null);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkSystemGroups(long companyId) throws PortalException {
        String[] systemGroups;
        String companyIdHexString = StringUtil.toHexString((long)companyId);
        for (Group group : this.groupFinder.findBySystem(companyId)) {
            this._systemGroupsMap.put(companyIdHexString.concat(group.getGroupKey()), group);
        }
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        for (String groupKey : systemGroups = PortalUtil.getSystemGroups()) {
            LayoutSet layoutSet;
            String groupCacheKey = companyIdHexString.concat(groupKey);
            Group group = this._systemGroupsMap.get(groupCacheKey);
            if (group == null) {
                group = this.groupPersistence.fetchByC_GK(companyId, groupKey);
            }
            if (group == null) {
                String className = null;
                long classPK = 0L;
                int type = 1;
                String friendlyURL = null;
                boolean site = true;
                if (groupKey.equals("Control Panel")) {
                    type = 3;
                    friendlyURL = "/control_panel";
                    site = false;
                } else if (groupKey.equals("Forms")) {
                    type = 3;
                    friendlyURL = "/forms";
                    site = false;
                } else if (groupKey.equals("Guest")) {
                    friendlyURL = "/guest";
                } else if (groupKey.equals("User Personal Site")) {
                    className = UserPersonalSite.class.getName();
                    classPK = defaultUserId;
                    type = 3;
                    friendlyURL = "/personal_site";
                    site = false;
                }
                group = this.groupLocalService.addGroup(defaultUserId, 0L, className, classPK, 0L, this.getLocalizationMap(groupKey), null, type, true, 0, friendlyURL, site, true, null);
                if (groupKey.equals("User Personal Site")) {
                    this.initUserPersonalSitePermissions(group);
                }
            }
            if (group.isControlPanel() && (layoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), true)).getPageCount() == 0) {
                this.addControlPanelLayouts(group);
            }
            if (group.isGuest() && (layoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), false)).getPageCount() == 0) {
                this.addDefaultGuestPublicLayouts(group);
            }
            this._systemGroupsMap.put(groupCacheKey, group);
        }
    }

    @Override
    public void clearOrganizationGroups(long organizationId) {
        super.clearOrganizationGroups(organizationId);
        try {
            this.reindexUsersInOrganization(organizationId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void clearUserGroupGroups(long userGroupId) {
        super.clearUserGroupGroups(userGroupId);
        try {
            this.reindexUsersInUserGroup(userGroupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group deleteGroup(Group group) throws PortalException {
        boolean deleteInProcess = GroupThreadLocal.isDeleteInProcess();
        try {
            ServiceContext serviceContext;
            block23: {
                block22: {
                    GroupThreadLocal.setDeleteInProcess((boolean)true);
                    if ((group.isCompany() && !group.isCompanyStagingGroup() || PortalUtil.isSystemGroup((String)group.getGroupKey())) && !CompanyThreadLocal.isDeleteInProcess()) {
                        throw new RequiredGroupException.MustNotDeleteSystemGroup(group.getGroupId());
                    }
                    int count = this.groupPersistence.countByC_P_S(group.getCompanyId(), group.getGroupId(), true);
                    if (count > 0) {
                        throw new RequiredGroupException.MustNotDeleteGroupThatHasChild(group.getGroupId());
                    }
                    List backgroundTasks = BackgroundTaskManagerUtil.getBackgroundTasks((long)group.getGroupId(), (int)1);
                    if (ListUtil.isNotNull((List)backgroundTasks)) {
                        throw new PendingBackgroundTaskException("Unable to delete group with pending background tasks");
                    }
                    BackgroundTaskManagerUtil.deleteGroupBackgroundTasks((long)group.getGroupId());
                    this.layoutSetBranchLocalService.deleteLayoutSetBranches(group.getGroupId(), true, true);
                    this.layoutSetBranchLocalService.deleteLayoutSetBranches(group.getGroupId(), false, true);
                    serviceContext = new ServiceContext();
                    try {
                        this.layoutSetLocalService.deleteLayoutSet(group.getGroupId(), true, serviceContext);
                    }
                    catch (NoSuchLayoutSetException noSuchLayoutSetException) {
                        if (!_log.isDebugEnabled()) break block22;
                        _log.debug((Object)noSuchLayoutSetException, (Throwable)noSuchLayoutSetException);
                    }
                }
                try {
                    this.layoutSetLocalService.deleteLayoutSet(group.getGroupId(), false, serviceContext);
                }
                catch (NoSuchLayoutSetException noSuchLayoutSetException) {
                    if (!_log.isDebugEnabled()) break block23;
                    _log.debug((Object)noSuchLayoutSetException, (Throwable)noSuchLayoutSetException);
                }
            }
            this.membershipRequestLocalService.deleteMembershipRequests(group.getGroupId());
            this.portletPreferencesLocalService.deletePortletPreferences(group.getGroupId(), 2, 0L);
            this.portletPreferencesLocalService.deletePortletPreferences(group.getGroupId(), 3, 0L);
            this.dlAppLocalService.deleteAllRepositories(group.getGroupId());
            this.teamLocalService.deleteTeams(group.getGroupId());
            this.exportImportConfigurationLocalService.deleteExportImportConfigurations(group.getGroupId());
            this.unscheduleStaging(group);
            if (group.hasStagingGroup()) {
                try {
                    this.stagingLocalService.disableStaging(group, serviceContext);
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to disable staging for group " + group.getGroupId()), (Throwable)exception);
                }
            }
            this.systemEventLocalService.deleteSystemEvents(group.getGroupId());
            ThemeLoader themeLoader = ThemeLoaderFactory.getDefaultThemeLoader();
            if (themeLoader != null) {
                String themePath = themeLoader.getFileStorage() + "/" + group.getGroupId();
                FileUtil.deltree((String)(themePath + "-private"));
                FileUtil.deltree((String)(themePath + "-public"));
            }
            this.deletePortletData(group);
            if (group.isRegularSite()) {
                this.assetEntryLocalService.deleteEntry(Group.class.getName(), group.getGroupId());
            }
            this.assetEntryLocalService.deleteGroupEntries(group.getGroupId());
            this.assetTagLocalService.deleteGroupTags(group.getGroupId());
            this.assetVocabularyLocalService.deleteVocabularies(group.getGroupId());
            this.expandoRowLocalService.deleteRows(group.getCompanyId(), this.classNameLocalService.getClassNameId(Group.class.getName()), group.getGroupId());
            this.socialActivityLocalService.deleteActivities(group.getGroupId());
            this.socialActivitySettingLocalService.deleteActivitySettings(group.getGroupId());
            this.socialRequestLocalService.deleteRequests(this.classNameLocalService.getClassNameId(Group.class), group.getGroupId());
            List resourcePermissions = this.resourcePermissionPersistence.findByC_S_P(group.getCompanyId(), 2, String.valueOf(group.getGroupId()));
            for (Object resourcePermission : resourcePermissions) {
                this.resourcePermissionLocalService.deleteResourcePermission((ResourcePermission)resourcePermission);
            }
            List scopeableWorkflowHandlers = WorkflowHandlerRegistryUtil.getScopeableWorkflowHandlers();
            for (WorkflowHandler scopeableWorkflowHandler : scopeableWorkflowHandlers) {
                WorkflowDefinitionLink workflowDefinitionLink;
                if (!scopeableWorkflowHandler.isVisible() || (workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(group.getCompanyId(), group.getGroupId(), scopeableWorkflowHandler.getClassName(), 0L, 0L, true)) == null || workflowDefinitionLink.getGroupId() == group.getLiveGroupId()) continue;
                this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink);
            }
            if (!group.isStagingGroup() && group.isOrganization() && group.isSite()) {
                group.setSite(false);
                group = (Group)this.groupPersistence.update((BaseModel)group);
                this.userGroupRoleLocalService.deleteUserGroupRoles(group.getGroupId(), 2);
                this.userGroupGroupRoleLocalService.deleteUserGroupGroupRoles(group.getGroupId(), 2);
            } else {
                block24: {
                    this.userGroupRoleLocalService.deleteUserGroupRolesByGroupId(group.getGroupId());
                    this.userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByGroupId(group.getGroupId());
                    try {
                        this.resourceLocalService.deleteResource(group.getCompanyId(), Group.class.getName(), 4, group.getGroupId());
                    }
                    catch (Exception exception) {
                        if (!_log.isWarnEnabled()) break block24;
                        _log.warn((Object)("No resources found for group " + group.getGroupId()), (Throwable)exception);
                    }
                }
                long companyId = group.getCompanyId();
                long[] userIds = this.getUserPrimaryKeys(group.getGroupId());
                if (ArrayUtil.isNotEmpty((long[])userIds)) {
                    TransactionCommitCallbackUtil.registerCallback(() -> {
                        this.reindex(companyId, userIds);
                        return null;
                    });
                }
                this.groupPersistence.remove((BaseModel)group);
            }
            Group group2 = group;
            return group2;
        }
        finally {
            GroupThreadLocal.setDeleteInProcess((boolean)deleteInProcess);
        }
    }

    @Override
    public Group deleteGroup(long groupId) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        return this.deleteGroup(group);
    }

    @Override
    public void deleteOrganizationGroup(long organizationId, Group group) {
        super.deleteOrganizationGroup(organizationId, group);
        try {
            this.reindexUsersInOrganization(organizationId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void deleteOrganizationGroup(long organizationId, long groupId) {
        super.deleteOrganizationGroup(organizationId, groupId);
        try {
            this.reindexUsersInOrganization(organizationId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void deleteOrganizationGroups(long organizationId, List<Group> groups) {
        super.deleteOrganizationGroups(organizationId, groups);
        try {
            this.reindexUsersInOrganization(organizationId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void deleteOrganizationGroups(long organizationId, long[] groupIds) {
        super.deleteOrganizationGroups(organizationId, groupIds);
        try {
            this.reindexUsersInOrganization(organizationId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void deleteUserGroupGroup(long userGroupId, Group group) {
        super.deleteUserGroupGroup(userGroupId, group);
        try {
            this.reindexUsersInUserGroup(userGroupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void deleteUserGroupGroup(long userGroupId, long groupId) {
        super.deleteUserGroupGroup(userGroupId, groupId);
        try {
            this.reindexUsersInUserGroup(userGroupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void deleteUserGroupGroups(long userGroupId, List<Group> groups) {
        super.deleteUserGroupGroups(userGroupId, groups);
        try {
            this.reindexUsersInUserGroup(userGroupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void deleteUserGroupGroups(long userGroupId, long[] groupIds) {
        super.deleteUserGroupGroups(userGroupId, groupIds);
        try {
            this.reindexUsersInUserGroup(userGroupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public synchronized void disableStaging(long groupId) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        int stagingGroupCount = group.getRemoteStagingGroupCount();
        if (stagingGroupCount == 0) {
            return;
        }
        group.setRemoteStagingGroupCount(--stagingGroupCount);
        if (stagingGroupCount == 0) {
            UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : typeSettingsUnicodeProperties.keySet()) {
                if (!key.startsWith("staged-portlet_")) continue;
                keys.add(key);
            }
            for (String key : keys) {
                typeSettingsUnicodeProperties.remove((Object)key);
            }
            group.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        }
        this.groupPersistence.update((BaseModel)group);
    }

    public synchronized void enableStaging(long groupId) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        int stagingGroupCount = group.getRemoteStagingGroupCount() + 1;
        group.setRemoteStagingGroupCount(stagingGroupCount);
        this.groupPersistence.update((BaseModel)group);
    }

    public Group fetchCompanyGroup(long companyId) {
        return this.groupPersistence.fetchByC_C_C(companyId, this.classNameLocalService.getClassNameId(Company.class), companyId);
    }

    public Group fetchFriendlyURLGroup(long companyId, String friendlyURL) {
        if (Validator.isNull((String)friendlyURL)) {
            return null;
        }
        friendlyURL = this.getFriendlyURL(friendlyURL);
        return this.groupPersistence.fetchByC_F(companyId, friendlyURL);
    }

    @Override
    @ThreadLocalCachable
    public Group fetchGroup(long groupId) {
        return this.groupPersistence.fetchByPrimaryKey(groupId);
    }

    public Group fetchGroup(long companyId, long classNameId, long classPK) {
        return this.groupPersistence.fetchByC_C_C(companyId, classNameId, classPK);
    }

    @Transactional(enabled=false)
    public Group fetchGroup(long companyId, String groupKey) {
        String companyIdHexString = StringUtil.toHexString((long)companyId);
        Group group = this._systemGroupsMap.get(companyIdHexString.concat(groupKey));
        if (group != null) {
            return group;
        }
        return this.groupLocalService.loadFetchGroup(companyId, groupKey);
    }

    public Group fetchStagingGroup(long liveGroupId) {
        return this.groupPersistence.fetchByLiveGroupId(liveGroupId);
    }

    public Group fetchUserGroup(long companyId, long userId) {
        return this.groupPersistence.fetchByC_C_C(companyId, this.classNameLocalService.getClassNameId(User.class), userId);
    }

    public Group fetchUserPersonalSiteGroup(long companyId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(UserPersonalSite.class);
        return this.groupPersistence.fetchByC_C_C(companyId, classNameId, this.userLocalService.getDefaultUserId(companyId));
    }

    public List<Long> getActiveGroupIds(long userId) {
        return this.groupFinder.findByActiveGroupIds(userId);
    }

    public List<Group> getActiveGroups(long companyId, boolean active) {
        return this.groupPersistence.findByC_A(companyId, active);
    }

    public List<Group> getActiveGroups(long companyId, boolean site, boolean active, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.groupPersistence.findByC_S_A(companyId, site, active, start, end, orderByComparator);
    }

    public List<Group> getActiveGroups(long companyId, boolean active, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.groupPersistence.findByC_A(companyId, active, start, end, orderByComparator);
    }

    public int getActiveGroupsCount(long companyId, boolean active) {
        return this.groupPersistence.countByC_A(companyId, active);
    }

    public int getActiveGroupsCount(long companyId, boolean active, boolean site) {
        return this.groupPersistence.countByC_S_A(companyId, active, site);
    }

    public Group getCompanyGroup(long companyId) throws PortalException {
        return this.groupPersistence.findByC_C_C(companyId, this.classNameLocalService.getClassNameId(Company.class), companyId);
    }

    public List<Group> getCompanyGroups(long companyId, int start, int end) {
        return this.groupPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyGroupsCount(long companyId) {
        return this.groupPersistence.countByCompanyId(companyId);
    }

    public Group getFriendlyURLGroup(long companyId, String friendlyURL) throws PortalException {
        if (Validator.isNull((String)friendlyURL)) {
            StringBundler sb = new StringBundler(5);
            sb.append("{companyId=");
            sb.append(companyId);
            sb.append(", friendlyURL=");
            sb.append(friendlyURL);
            sb.append("}");
            throw new NoSuchGroupException(sb.toString());
        }
        friendlyURL = this.getFriendlyURL(friendlyURL);
        return this.groupPersistence.findByC_F(companyId, friendlyURL);
    }

    @Override
    @ThreadLocalCachable
    public Group getGroup(long groupId) throws PortalException {
        return this.groupPersistence.findByPrimaryKey(groupId);
    }

    @Transactional(enabled=false)
    public Group getGroup(long companyId, String groupKey) throws PortalException {
        String companyIdHexString = StringUtil.toHexString((long)companyId);
        Group group = this._systemGroupsMap.get(companyIdHexString.concat(groupKey));
        if (group != null) {
            return group;
        }
        return this.groupLocalService.loadGetGroup(companyId, groupKey);
    }

    public List<Long> getGroupIds(long companyId, boolean active) {
        return this.groupFinder.findByC_A(companyId, active);
    }

    public List<Group> getGroups(long companyId, long parentGroupId, boolean site) {
        if (parentGroupId == -1L) {
            return this.groupPersistence.findByC_S(companyId, site);
        }
        return this.groupPersistence.findByC_P_S(companyId, parentGroupId, site);
    }

    public List<Group> getGroups(long companyId, long parentGroupId, boolean site, boolean inheritContent) {
        return this.groupPersistence.findByC_P_S_I(companyId, parentGroupId, site, inheritContent);
    }

    public List<Group> getGroups(long companyId, long parentGroupId, boolean site, int start, int end) {
        if (parentGroupId == -1L) {
            return this.groupPersistence.findByC_S(companyId, site, start, end);
        }
        return this.groupPersistence.findByC_P_S(companyId, parentGroupId, site, start, end);
    }

    public List<Group> getGroups(long companyId, long parentGroupId, String name, boolean site, int start, int end) {
        if (Validator.isNull((String)name)) {
            return this.getGroups(companyId, parentGroupId, site, start, end);
        }
        if (parentGroupId == -1L) {
            return this.groupPersistence.findByC_LikeN_S(companyId, name, site, start, end);
        }
        return this.groupPersistence.findByC_P_LikeN_S(companyId, parentGroupId, name, site, start, end);
    }

    public List<Group> getGroups(long companyId, String treePath, boolean site) {
        return this.groupPersistence.findByC_T_S(companyId, treePath, site);
    }

    public List<Group> getGroups(long companyId, String className, long parentGroupId) {
        return this.groupPersistence.findByC_C_P(companyId, this.classNameLocalService.getClassNameId(className), parentGroupId);
    }

    public List<Group> getGroups(long companyId, String className, long parentGroupId, int start, int end) {
        return this.groupPersistence.findByC_C_P(companyId, this.classNameLocalService.getClassNameId(className), parentGroupId, start, end);
    }

    public List<Group> getGroups(long[] groupIds) throws PortalException {
        ArrayList<Group> groups = new ArrayList<Group>(groupIds.length);
        for (long groupId : groupIds) {
            groups.add(this.getGroup(groupId));
        }
        return groups;
    }

    public int getGroupsCount(long companyId, long parentGroupId, boolean site) {
        if (parentGroupId == -1L) {
            return this.groupPersistence.countByC_S(companyId, site);
        }
        return this.groupPersistence.countByC_P_S(companyId, parentGroupId, site);
    }

    public int getGroupsCount(long companyId, long parentGroupId, String name, boolean site) {
        if (Validator.isNull((String)name)) {
            return this.getGroupsCount(companyId, parentGroupId, site);
        }
        if (parentGroupId == -1L) {
            return this.groupPersistence.countByC_LikeN_S(companyId, name, site);
        }
        return this.groupPersistence.countByC_P_LikeN_S(companyId, parentGroupId, name, site);
    }

    public int getGroupsCount(long companyId, String className, long parentGroupId) {
        return this.groupPersistence.countByC_C_P(companyId, this.classNameLocalService.getClassNameId(className), parentGroupId);
    }

    public Group getLayoutGroup(long companyId, long plid) throws PortalException {
        return this.groupPersistence.findByC_C_C(companyId, this.classNameLocalService.getClassNameId(Layout.class), plid);
    }

    public Group getLayoutPrototypeGroup(long companyId, long layoutPrototypeId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(LayoutPrototype.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, layoutPrototypeId);
    }

    public Group getLayoutSetPrototypeGroup(long companyId, long layoutSetPrototypeId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(LayoutSetPrototype.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, layoutSetPrototypeId);
    }

    public List<Group> getLayoutsGroups(long companyId, long parentGroupId, boolean site, boolean active, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.groupFinder.findByLayouts(companyId, parentGroupId, site, Boolean.valueOf(active), start, end, orderByComparator);
    }

    public List<Group> getLayoutsGroups(long companyId, long parentGroupId, boolean site, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.groupFinder.findByLayouts(companyId, parentGroupId, site, null, start, end, orderByComparator);
    }

    public int getLayoutsGroupsCount(long companyId, long parentGroupId, boolean site) {
        return this.groupFinder.countByLayouts(companyId, parentGroupId, site);
    }

    public int getLayoutsGroupsCount(long companyId, long parentGroupId, boolean site, boolean active) {
        return this.groupFinder.countByLayouts(companyId, parentGroupId, site, Boolean.valueOf(active));
    }

    public List<Group> getLiveGroups() {
        return this.groupFinder.findByLiveGroups();
    }

    public Group getOrganizationGroup(long companyId, long organizationId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(Organization.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, organizationId);
    }

    public List<Group> getOrganizationsGroups(List<Organization> organizations) {
        ArrayList<Group> organizationGroups = new ArrayList<Group>();
        for (Organization organization : organizations) {
            organizationGroups.add(organization.getGroup());
        }
        return organizationGroups;
    }

    public List<Group> getOrganizationsRelatedGroups(List<Organization> organizations) {
        ArrayList<Group> organizationGroups = new ArrayList<Group>();
        for (Organization organization : organizations) {
            List groups = this.organizationPersistence.getGroups(organization.getOrganizationId());
            organizationGroups.addAll(groups);
        }
        return organizationGroups;
    }

    public List<Group> getParentGroups(long groupId) throws PortalException {
        if (groupId == 0L) {
            return new ArrayList<Group>();
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        return group.getAncestors();
    }

    public List<Group> getStagedSites() {
        return this.groupFinder.findByL_TS_S_RSGC(0L, "staged=true", true, 0);
    }

    public Group getStagingGroup(long liveGroupId) throws PortalException {
        return this.groupPersistence.findByLiveGroupId(liveGroupId);
    }

    public Group getUserGroup(long companyId, long userId) throws PortalException {
        return this.groupPersistence.findByC_C_C(companyId, this.classNameLocalService.getClassNameId(User.class), userId);
    }

    public Group getUserGroupGroup(long companyId, long userGroupId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, userGroupId);
    }

    public List<Group> getUserGroups(long userId, boolean inherit) throws PortalException {
        return this.getUserGroups(userId, inherit, -1, -1);
    }

    public List<Group> getUserGroups(long userId, boolean inherit, int start, int end) throws PortalException {
        if (inherit) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            return this.search(user.getCompanyId(), null, null, (LinkedHashMap<String, Object>)LinkedHashMapBuilder.put((Object)"usersGroups", (Object)userId).build(), start, end);
        }
        return this.userPersistence.getGroups(userId, start, end);
    }

    public List<Group> getUserGroupsGroups(List<UserGroup> userGroups) throws PortalException {
        ArrayList<Group> userGroupGroups = new ArrayList<Group>();
        for (UserGroup userGroup : userGroups) {
            userGroupGroups.add(userGroup.getGroup());
        }
        return userGroupGroups;
    }

    public List<Group> getUserGroupsRelatedGroups(List<UserGroup> userGroups) {
        ArrayList<Group> userGroupGroups = new ArrayList<Group>();
        for (UserGroup userGroup : userGroups) {
            List groups = this.userGroupPersistence.getGroups(userGroup.getUserGroupId());
            userGroupGroups.addAll(groups);
        }
        return userGroupGroups;
    }

    public List<Group> getUserOrganizationsGroups(long userId, int start, int end) throws PortalException {
        ArrayList<Group> userOrgsGroups = new ArrayList<Group>();
        List userOrgs = this.organizationLocalService.getUserOrganizations(userId, start, end);
        for (Organization organization : userOrgs) {
            userOrgsGroups.add(0, organization.getGroup());
            if (PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) continue;
            for (Organization ancestorOrganization : organization.getAncestors()) {
                userOrgsGroups.add(0, ancestorOrganization.getGroup());
            }
        }
        return ListUtil.unique(userOrgsGroups);
    }

    public Group getUserPersonalSiteGroup(long companyId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(UserPersonalSite.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, this.userLocalService.getDefaultUserId(companyId));
    }

    public List<Group> getUserSitesGroups(long userId) throws PortalException {
        UserBag userBag = PermissionCacheUtil.getUserBag(userId);
        if (userBag == null) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            return this.groupFinder.findByCompanyId(user.getCompanyId(), LinkedHashMapBuilder.put((Object)"inherit", (Object)Boolean.TRUE).put((Object)"site", (Object)Boolean.TRUE).put((Object)"usersGroups", (Object)userId).build(), -1, -1, (OrderByComparator)new GroupNameComparator(true));
        }
        Collection userGroups = userBag.getUserGroups();
        ArrayList<Group> userSiteGroups = new ArrayList<Group>(userGroups.size());
        for (Group group : userGroups) {
            if (!group.isSite()) continue;
            userSiteGroups.add(group);
        }
        userSiteGroups.sort((Comparator<Group>)new GroupNameComparator(true));
        return userSiteGroups;
    }

    public List<Group> getUserSitesGroups(long userId, boolean includeAdministrative) throws PortalException {
        if (!includeAdministrative) {
            return this.getUserSitesGroups(userId);
        }
        HashSet<Group> siteGroups = new HashSet<Group>();
        List userGroupRoles = this.userGroupRoleLocalService.getUserGroupRoles(userId);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            Role role = userGroupRole.getRole();
            String roleName = role.getName();
            if (!roleName.equals("Site Administrator") && !roleName.equals("Site Owner")) continue;
            siteGroups.add(userGroupRole.getGroup());
        }
        siteGroups.addAll(this.getUserSitesGroups(userId));
        return new ArrayList<Group>(siteGroups);
    }

    public List<Group> getUserSitesGroups(long userId, int start, int end) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.groupFinder.findByCompanyId(user.getCompanyId(), LinkedHashMapBuilder.put((Object)"inherit", (Object)Boolean.TRUE).put((Object)"site", (Object)Boolean.TRUE).put((Object)"usersGroups", (Object)userId).build(), start, end, (OrderByComparator)new GroupNameComparator(true));
    }

    public boolean hasStagingGroup(long liveGroupId) {
        return this.groupPersistence.fetchByLiveGroupId(liveGroupId) != null;
    }

    @Override
    public boolean hasUserGroup(long userId, long groupId) {
        return this.hasUserGroup(userId, groupId, true);
    }

    public boolean hasUserGroup(long userId, long groupId, boolean inherit) {
        return this.groupFinder.countByG_U(groupId, userId, inherit) > 0;
    }

    @Transactional(enabled=false)
    public boolean isLiveGroupActive(Group group) {
        if (group == null) {
            return false;
        }
        if (!group.isStagingGroup()) {
            return group.isActive();
        }
        Group liveGroup = group.getLiveGroup();
        if (liveGroup == null) {
            return false;
        }
        return liveGroup.isActive();
    }

    public Group loadFetchGroup(long companyId, String groupKey) {
        return this.groupPersistence.fetchByC_GK(companyId, groupKey);
    }

    public Group loadGetGroup(long companyId, String groupKey) throws PortalException {
        return this.groupPersistence.findByC_GK(companyId, groupKey);
    }

    public void rebuildTree(long companyId) throws PortalException {
        final long classNameId = this.classNameLocalService.getClassNameId(Group.class);
        TreePathUtil.rebuildTree((long)companyId, (long)0L, (String)"/", (TreeModelTasks)new TreeModelTasksAdapter<Group>(){

            public List<Group> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) {
                return GroupLocalServiceImpl.this.groupPersistence.findByG_C_C_P(previousId, companyId, classNameId, parentPrimaryKey, -1, size, (OrderByComparator)new GroupIdComparator(true));
            }
        });
    }

    public List<Group> search(long companyId, LinkedHashMap<String, Object> params, int start, int end) {
        return this.groupFinder.findByCompanyId(companyId, params, start, end, (OrderByComparator)new GroupNameComparator(true));
    }

    public List<Group> search(long companyId, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end) {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, keywords, params, start, end, orderByComparator);
    }

    public List<Group> search(long companyId, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, name, description, params, andOperator, start, end, orderByComparator);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end) {
        return this.search(companyId, classNameIds, parentGroupId, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> orderByComparator) {
        String[] keywordsArray = this.getSearchNames(companyId, keywords);
        boolean andOperator = false;
        if (Validator.isNull((String)keywords)) {
            andOperator = true;
        }
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.findByC_C_PG_N_D(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator, start, end, orderByComparator);
        }
        Collection<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator);
        return this.sort(groups, start, end, orderByComparator);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.search(companyId, classNameIds, parentGroupId, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> orderByComparator) {
        String[] names = this.getSearchNames(companyId, name);
        String[] descriptions = CustomSQLUtil.keywords((String)description);
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.findByC_C_PG_N_D(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator, start, end, orderByComparator);
        }
        Collection<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator);
        return this.sort(groups, start, end, orderByComparator);
    }

    public List<Group> search(long companyId, long[] classNameIds, String keywords, LinkedHashMap<String, Object> params, int start, int end) {
        return this.search(companyId, classNameIds, -1L, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.search(companyId, classNameIds, -1L, keywords, params, start, end, orderByComparator);
    }

    public List<Group> search(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.search(companyId, classNameIds, -1L, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.search(companyId, classNameIds, -1L, name, description, params, andOperator, start, end, orderByComparator);
    }

    @ThreadLocalCachable
    public List<Group> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end) {
        return this.search(companyId, this.getClassNameIds(), -1L, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.search(companyId, this.getClassNameIds(), -1L, keywords, params, start, end, orderByComparator);
    }

    public List<Group> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.search(companyId, this.getClassNameIds(), -1L, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.search(companyId, this.getClassNameIds(), -1L, name, description, params, andOperator, start, end, orderByComparator);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long parentGroupId, String keywords, LinkedHashMap<String, Object> params) {
        return this.searchCount(companyId, this.getClassNameIds(), parentGroupId, keywords, params);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        return this.searchCount(companyId, this.getClassNameIds(), parentGroupId, name, description, params, andOperator);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, long parentGroupId, String keywords, LinkedHashMap<String, Object> params) {
        String[] keywordsArray = this.getSearchNames(companyId, keywords);
        boolean andOperator = false;
        if (Validator.isNull((String)keywords)) {
            andOperator = true;
        }
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.countByC_C_PG_N_D(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator);
        }
        Collection<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator);
        return groups.size();
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        String[] names = this.getSearchNames(companyId, name);
        String[] descriptions = CustomSQLUtil.keywords((String)description);
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.countByC_C_PG_N_D(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator);
        }
        Collection<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator);
        return groups.size();
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, String keywords, LinkedHashMap<String, Object> params) {
        return this.searchCount(companyId, classNameIds, -1L, keywords, params);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        return this.searchCount(companyId, classNameIds, -1L, name, description, params, andOperator);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, String keywords, LinkedHashMap<String, Object> params) {
        return this.searchCount(companyId, this.getClassNameIds(), -1L, keywords, params);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        return this.searchCount(companyId, this.getClassNameIds(), -1L, name, description, params, andOperator);
    }

    public void unsetRoleGroups(long roleId, long[] groupIds) {
        this.rolePersistence.removeGroups(roleId, groupIds);
    }

    public void unsetUserGroups(long userId, long[] groupIds) {
        this.userGroupRoleLocalService.deleteUserGroupRoles(userId, groupIds);
        this.userPersistence.removeGroups(userId, groupIds);
    }

    public void updateAsset(long userId, Group group, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        Group companyGroup = company.getGroup();
        this.assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), null, null, Group.class.getName(), group.getGroupId(), null, 0L, assetCategoryIds, assetTagNames, true, false, null, null, null, null, null, group.getDescriptiveName(), group.getDescription(), null, null, null, 0, 0, null);
    }

    public Group updateFriendlyURL(long groupId, String friendlyURL) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (group.isUser()) {
            User user = this.userPersistence.findByPrimaryKey(group.getClassPK());
            friendlyURL = "/" + user.getScreenName();
            if (friendlyURL.equals(group.getFriendlyURL())) {
                return group;
            }
        }
        friendlyURL = this.getFriendlyURL(group.getCompanyId(), groupId, group.getClassNameId(), group.getClassPK(), "", friendlyURL);
        if (group.isUser()) {
            friendlyURL = this.getValidatedFriendlyURL(group.getCompanyId(), group.getGroupId(), group.getClassNameId(), group.getClassPK(), friendlyURL);
        } else {
            this.validateFriendlyURL(group.getCompanyId(), group.getGroupId(), group.getClassNameId(), group.getClassPK(), friendlyURL);
        }
        group.setFriendlyURL(friendlyURL);
        return (Group)this.groupPersistence.update((BaseModel)group);
    }

    public Group updateGroup(long groupId, long parentGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean inheritContent, boolean active, ServiceContext serviceContext) throws PortalException {
        ArrayList<String> names = new ArrayList<String>(nameMap.values());
        if (ListUtil.isNull(names)) {
            throw new GroupKeyException();
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        String className = group.getClassName();
        long classNameId = group.getClassNameId();
        long classPK = group.getClassPK();
        String groupKey = group.getGroupKey();
        if (nameMap != null && Validator.isNotNull((String)(nameMap = this._normalizeNameMap(nameMap)).get(LocaleUtil.fromLanguageId((String)group.getDefaultLanguageId())))) {
            groupKey = nameMap.get(LocaleUtil.fromLanguageId((String)group.getDefaultLanguageId()));
        }
        friendlyURL = this.getFriendlyURL(group.getCompanyId(), groupId, classNameId, classPK, "", friendlyURL);
        if (classNameId <= 0L || type == 5 || className.equals(Group.class.getName())) {
            this.validateGroupKey(group.getGroupId(), group.getCompanyId(), groupKey, group.getType(), group.isSite());
        } else if (className.equals(Organization.class.getName())) {
            Organization organization = this.organizationPersistence.findByPrimaryKey(classPK);
            groupKey = this.getOrgGroupName(organization.getName());
        } else if (!"User Personal Site".equals(group.getGroupKey())) {
            groupKey = String.valueOf(classPK);
        }
        if (PortalUtil.isSystemGroup((String)group.getGroupKey()) && !groupKey.equals(group.getGroupKey())) {
            throw new RequiredGroupException.MustNotDeleteSystemGroup(group.getGroupId());
        }
        if (group.isUser()) {
            friendlyURL = this.getValidatedFriendlyURL(group.getCompanyId(), group.getGroupId(), group.getClassNameId(), group.getClassPK(), friendlyURL);
        } else {
            this.validateFriendlyURL(group.getCompanyId(), group.getGroupId(), group.getClassNameId(), group.getClassPK(), friendlyURL);
        }
        this.validateParentGroup(group.getGroupId(), parentGroupId);
        group.setParentGroupId(parentGroupId);
        group.setTreePath(group.buildTreePath());
        group.setGroupKey(groupKey);
        group.setNameMap(nameMap);
        group.setDescriptionMap(descriptionMap);
        group.setType(type);
        group.setManualMembership(manualMembership);
        group.setMembershipRestriction(membershipRestriction);
        group.setFriendlyURL(friendlyURL);
        group.setInheritContent(inheritContent);
        if (group.isActive() != active) {
            group.setActive(active);
            long companyId = group.getCompanyId();
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this.reindex(companyId, this.getUserPrimaryKeys(groupId));
                return null;
            });
        }
        if (serviceContext != null && group.isSite()) {
            group.setExpandoBridgeAttributes(serviceContext);
        }
        if ((group = (Group)this.groupPersistence.update((BaseModel)group)).hasStagingGroup() && !group.isStagedRemotely()) {
            Group stagingGroup = group.getStagingGroup();
            stagingGroup.setParentGroupId(group.getParentGroupId());
            stagingGroup.setTreePath(stagingGroup.buildTreePath());
            this.groupPersistence.update((BaseModel)stagingGroup);
        }
        if (serviceContext == null || !group.isSite()) {
            return group;
        }
        User user = this.userPersistence.fetchByPrimaryKey(group.getCreatorUserId());
        if (user == null) {
            user = this.userPersistence.fetchByPrimaryKey(serviceContext.getUserId());
        }
        if (user == null) {
            user = this.userLocalService.getDefaultUser(group.getCompanyId());
        }
        this.updateAsset(user.getUserId(), group, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return group;
    }

    public Group updateGroup(long groupId, String typeSettings) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        UnicodeProperties oldTypeSettingsUnicodeProperties = new UnicodeProperties(true);
        oldTypeSettingsUnicodeProperties.fastLoad(group.getTypeSettings());
        this._validateGroupKeyChange(groupId, typeSettings);
        group = this.groupPersistence.findByPrimaryKey(groupId);
        UnicodeProperties typeSettingsUnicodeProperties = new UnicodeProperties(true);
        typeSettingsUnicodeProperties.fastLoad(typeSettings);
        String newLanguageIds = typeSettingsUnicodeProperties.getProperty("locales");
        if (Validator.isNotNull((String)newLanguageIds)) {
            String oldLanguageIds = oldTypeSettingsUnicodeProperties.getProperty("locales", "");
            String defaultLanguageId = typeSettingsUnicodeProperties.getProperty("languageId", LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
            this.validateLanguageIds(defaultLanguageId, newLanguageIds);
            if (!Objects.equals(group.getDefaultLanguageId(), defaultLanguageId)) {
                Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
                Map oldNameMap = group.getNameMap();
                group.setNameMap(oldNameMap, defaultLocale);
                Map oldDescriptionMap = group.getDescriptionMap();
                group.setDescriptionMap(oldDescriptionMap, defaultLocale);
                Map nameMap = group.getNameMap();
                if (nameMap != null && Validator.isNotNull((String)((String)nameMap.get(defaultLocale)))) {
                    group.setGroupKey((String)nameMap.get(defaultLocale));
                }
            }
            if (!Objects.equals(oldLanguageIds, newLanguageIds)) {
                LanguageUtil.resetAvailableGroupLocales((long)groupId);
            }
        }
        group.setTypeSettings(typeSettings);
        return (Group)this.groupPersistence.update((BaseModel)group);
    }

    public Group updateSite(long groupId, boolean site) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (!group.isOrganization()) {
            return group;
        }
        group.setSite(site);
        return (Group)this.groupPersistence.update((BaseModel)group);
    }

    public void validateRemote(long groupId, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId) throws PortalException {
        RemoteOptionsException remoteOptionsException = null;
        if (!Validator.isDomain((String)remoteAddress) && !Validator.isIPAddress((String)remoteAddress)) {
            remoteOptionsException = new RemoteOptionsException(1);
            remoteOptionsException.setRemoteAddress(remoteAddress);
            throw remoteOptionsException;
        }
        if (remotePort < 1 || remotePort > 65535) {
            remoteOptionsException = new RemoteOptionsException(2);
            remoteOptionsException.setRemotePort(remotePort);
            throw remoteOptionsException;
        }
        if (Validator.isNotNull((String)remotePathContext) && (!remotePathContext.startsWith("/") || remotePathContext.endsWith("/"))) {
            remoteOptionsException = new RemoteOptionsException(4);
            remoteOptionsException.setRemotePathContext(remotePathContext);
            throw remoteOptionsException;
        }
        this.validateRemoteGroup(groupId, remoteGroupId, remoteAddress, remotePort, remotePathContext, secureConnection);
    }

    protected void addControlPanelLayouts(Group group) throws PortalException {
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        String friendlyURL = this.getFriendlyURL(PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        this.layoutLocalService.addLayout(defaultUserId, group.getGroupId(), true, 0L, PropsValues.CONTROL_PANEL_LAYOUT_NAME, "", "", "control_panel", false, friendlyURL, serviceContext);
    }

    protected void addDefaultGuestPublicLayouts(Group group) throws PortalException {
        if (this.publicLARFile != null) {
            this.addDefaultGuestPublicLayoutsByLAR(group, this.publicLARFile);
        }
    }

    protected void addDefaultGuestPublicLayoutsByLAR(Group group, File larFile) throws PortalException {
        User defaultUser = this.userLocalService.getDefaultUser(group.getCompanyId());
        Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap((User)defaultUser, (long)group.getGroupId(), (boolean)false, null, (Map)HashMapBuilder.put((Object)"PERMISSIONS", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_CONFIGURATION", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_DATA", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_DATA_CONTROL_DEFAULT", (Object)new String[]{Boolean.TRUE.toString()}).build());
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(defaultUser.getUserId(), 6, importLayoutSettingsMap);
        this.exportImportLocalService.importLayouts(exportImportConfiguration, larFile);
    }

    protected void addPortletDefaultData(Group group) throws PortalException {
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createPreparePortletDataContext((long)group.getCompanyId(), (long)group.getGroupId(), null, null);
        List<PortletDataHandler> portletDataHandlers = this.getPortletDataHandlers(group);
        for (PortletDataHandler portletDataHandler : portletDataHandlers) {
            try {
                portletDataHandler.addDefaultData(portletDataContext, portletDataHandler.getPortletId(), null);
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to add default data for portlet ", portletDataHandler.getPortletId(), " in group ", group.getGroupId()}));
                if (!portletDataHandler.isRollbackOnException()) continue;
                throw new SystemException((Throwable)exception);
            }
        }
    }

    protected void deletePortletData(Group group) throws PortalException {
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createPreparePortletDataContext((long)group.getCompanyId(), (long)group.getGroupId(), null, null);
        List<PortletDataHandler> portletDataHandlers = this.getPortletDataHandlers(group);
        for (PortletDataHandler portletDataHandler : portletDataHandlers) {
            try {
                portletDataHandler.deleteData(portletDataContext, portletDataHandler.getPortletId(), null);
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to delete data for portlet ", portletDataHandler.getPortletId(), " in group ", group.getGroupId()}), (Throwable)exception);
                if (!portletDataHandler.isRollbackOnException()) continue;
                throw exception;
            }
        }
    }

    protected Collection<Group> doSearch(long companyId, long[] classNameIds, long parentGroupId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator) {
        String actionId;
        Long roleId;
        ResourceAction resourceAction;
        boolean parentGroupIdEquals = true;
        if (parentGroupId == -1L) {
            parentGroupIdEquals = false;
        }
        params = new LinkedHashMap<String, Object>(params);
        Boolean active = (Boolean)params.remove("active");
        List excludedGroupIds = (List)params.remove("excludedGroupIds");
        List groupsTree = (List)params.remove("groupsTree");
        Boolean manualMembership = (Boolean)params.remove("manualMembership");
        Integer membershipRestriction = (Integer)params.remove("membershipRestriction");
        Boolean site = (Boolean)params.remove("site");
        List types = (List)params.remove("types");
        HashSet<Group> groups = new HashSet<Group>();
        Long userId = (Long)params.remove("usersGroups");
        for (long classNameId : classNameIds) {
            if (site != null) {
                groups.addAll(this.groupPersistence.findByC_C_S(companyId, classNameId, site.booleanValue()));
                continue;
            }
            groups.addAll(this.groupPersistence.findByC_C(companyId, classNameId));
        }
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            AssetEntry assetEntry;
            Group group = (Group)iterator.next();
            long liveGroupId = group.getLiveGroupId();
            if (liveGroupId != 0L) {
                iterator.remove();
                continue;
            }
            long groupParentGroupId = group.getParentGroupId();
            if (parentGroupIdEquals && groupParentGroupId != parentGroupId) {
                iterator.remove();
                continue;
            }
            String string = group.getGroupKey();
            if (string.equals("Control Panel")) {
                iterator.remove();
                continue;
            }
            boolean containsName = this.matches(group.getNameCurrentValue(), names);
            if (!containsName && (assetEntry = this.assetEntryPersistence.fetchByC_C(group.getClassNameId(), group.getGroupId())) != null) {
                containsName = this.matches(assetEntry.getTitle(), names);
            }
            int containsDescription = this.matches(group.getDescriptionCurrentValue(), descriptions);
            if (andOperator && (!containsName || containsDescription == 0) || !andOperator && !containsName && containsDescription == 0) {
                iterator.remove();
                continue;
            }
            if (active != null && active.booleanValue() != this.isLiveGroupActive(group)) {
                iterator.remove();
                continue;
            }
            if (excludedGroupIds != null && excludedGroupIds.contains(group.getGroupId())) {
                iterator.remove();
                continue;
            }
            if (groupsTree != null) {
                String treePath = group.getTreePath();
                boolean matched = false;
                for (Group groupTree : groupsTree) {
                    String groupTreePath = StringUtil.quote((String)String.valueOf(groupTree.getGroupId()), (String)"/");
                    if (!treePath.contains(groupTreePath)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    iterator.remove();
                    continue;
                }
            }
            if (manualMembership != null && manualMembership.booleanValue() != group.isManualMembership()) {
                iterator.remove();
                continue;
            }
            if (membershipRestriction != null && membershipRestriction.intValue() != group.getMembershipRestriction()) {
                iterator.remove();
                continue;
            }
            int type = group.getType();
            if (type == 4) {
                iterator.remove();
                continue;
            }
            if (types == null || types.contains(type)) continue;
            iterator.remove();
        }
        RolePermissions rolePermissions = (RolePermissions)params.remove("rolePermissions");
        if (rolePermissions != null && (resourceAction = this.resourceActionLocalService.fetchResourceAction(rolePermissions.getName(), rolePermissions.getActionId())) != null) {
            HashSet<Group> rolePermissionsGroups = new HashSet<Group>();
            List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_R(companyId, rolePermissions.getName(), rolePermissions.getScope(), rolePermissions.getRoleId());
            for (ResourcePermission resourcePermission : resourcePermissions) {
                Group group;
                if (!resourcePermission.hasAction(resourceAction) || (group = this.groupPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)resourcePermission.getPrimKey()))) == null) continue;
                rolePermissionsGroups.add(group);
            }
            groups.retainAll(rolePermissionsGroups);
        }
        if ((roleId = (Long)params.remove("groupsRoles")) != null) {
            groups.retainAll(this.rolePersistence.getGroups(roleId.longValue()));
        }
        if (userId == null) {
            return groups;
        }
        HashSet<Group> joinedGroups = new HashSet<Group>(this.userPersistence.getGroups(userId.longValue()));
        boolean inherit = GetterUtil.getBoolean(params.remove("inherit"), (boolean)true);
        if (inherit) {
            long[] lArray;
            long[] organizationIds;
            for (long organizationId : organizationIds = this.userPersistence.getOrganizationPrimaryKeys(userId.longValue())) {
                for (Group group : groups) {
                    if (organizationId != group.getClassPK()) continue;
                    joinedGroups.add(group);
                }
            }
            for (long organizationId : organizationIds) {
                joinedGroups.addAll(this.organizationPersistence.getGroups(organizationId));
            }
            for (long userGroupId : lArray = this.userPersistence.getUserGroupPrimaryKeys(userId.longValue())) {
                joinedGroups.addAll(this.userGroupPersistence.getGroups(userGroupId));
            }
        }
        if ((actionId = (String)params.remove("actionId")) != null) {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            for (Group group : groups) {
                try {
                    if (!permissionChecker.isGroupAdmin(group.getGroupId()) && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)actionId)) continue;
                    joinedGroups.add(group);
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to check permission for group " + group.getGroupId()), (Throwable)portalException);
                }
            }
        }
        if (_log.isDebugEnabled() && !params.isEmpty()) {
            _log.debug((Object)("Unprocessed parameters " + MapUtil.toString(params)));
        }
        joinedGroups.retainAll(groups);
        return joinedGroups;
    }

    protected long[] getClassNameIds() {
        if (this._classNameIds == null) {
            this._classNameIds = new long[]{this.classNameLocalService.getClassNameId(Group.class), this.classNameLocalService.getClassNameId(Organization.class)};
        }
        return this._classNameIds;
    }

    protected String getFriendlyURL(long companyId, long groupId, long classNameId, long classPK, String friendlyName, String friendlyURL) throws PortalException {
        if (Validator.isNotNull((String)(friendlyURL = this.getFriendlyURL(friendlyURL)))) {
            return friendlyURL;
        }
        String safeFriendlyName = StringUtil.removeChars((String)friendlyName, (char[])new char[]{'%'});
        friendlyURL = "/" + this.getFriendlyURL(safeFriendlyName);
        return this.getValidatedFriendlyURL(companyId, groupId, classNameId, classPK, friendlyURL);
    }

    protected String getFriendlyURL(String friendlyURL) {
        return FriendlyURLNormalizerUtil.normalizeWithEncoding((String)friendlyURL);
    }

    protected String getOrgGroupName(String name) {
        return name + ORGANIZATION_NAME_SUFFIX;
    }

    protected List<PortletDataHandler> getPortletDataHandlers(Group group) {
        List portlets = this.portletLocalService.getPortlets(group.getCompanyId());
        ArrayList<PortletDataHandler> portletDataHandlers = new ArrayList<PortletDataHandler>(portlets.size());
        for (Portlet portlet : portlets) {
            PortletDataHandler portletDataHandler;
            if (!portlet.isActive() || (portletDataHandler = portlet.getPortletDataHandlerInstance()) == null || portletDataHandler.isDataPortalLevel()) continue;
            portletDataHandlers.add(portletDataHandler);
        }
        return portletDataHandlers;
    }

    protected String[] getSearchNames(long companyId, String name) {
        if (Validator.isNull((String)name)) {
            return new String[]{null};
        }
        Company company = this.companyPersistence.fetchByPrimaryKey(companyId);
        if (company == null) {
            return CustomSQLUtil.keywords((String)name);
        }
        Account account = this.accountPersistence.fetchByPrimaryKey(company.getAccountId());
        if (account == null) {
            return CustomSQLUtil.keywords((String)name);
        }
        String companyName = account.getName();
        if (StringUtil.wildcardMatches((String)companyName, (String)name, (char)'_', (char)'%', (char)'\\', (boolean)false)) {
            Object[] searchNames = CustomSQLUtil.keywords((String)name);
            String guestName = StringUtil.quote((String)StringUtil.toLowerCase((String)"Guest"), (String)"%");
            return (String[])ArrayUtil.append((Object[])searchNames, (Object)guestName);
        }
        return CustomSQLUtil.keywords((String)name);
    }

    protected String getValidatedFriendlyURL(long companyId, long groupId, long classNameId, long classPK, String friendlyURL) throws PortalException {
        int i = 0;
        while (true) {
            try {
                this.validateFriendlyURL(companyId, groupId, classNameId, classPK, friendlyURL);
            }
            catch (GroupFriendlyURLException groupFriendlyURLException) {
                int type = groupFriendlyURLException.getType();
                if (type == 6) {
                    if (friendlyURL.matches(".+-[0-9]+$")) {
                        int end = friendlyURL.lastIndexOf(45);
                        long suffix = GetterUtil.getLong((String)friendlyURL.substring(end + 1));
                        if (!friendlyURL.contains("group") || groupId != suffix) {
                            friendlyURL = friendlyURL.substring(0, end);
                        }
                    }
                    if (StringUtil.endsWith((String)friendlyURL, (char)'-')) {
                        friendlyURL = friendlyURL + ++i;
                        continue;
                    }
                    friendlyURL = friendlyURL + '-' + ++i;
                    continue;
                }
                if (type == 11) {
                    friendlyURL = StringUtil.replaceLast((String)friendlyURL, (char)'-', (String)"");
                    continue;
                }
                friendlyURL = "/group-" + classPK;
                continue;
            }
            break;
        }
        return friendlyURL;
    }

    protected void initImportLARFile() {
        String publicLARFileName = PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading public LAR file " + publicLARFileName));
        }
        if (Validator.isNotNull((String)publicLARFileName)) {
            this.publicLARFile = new File(publicLARFileName);
            if (!this.publicLARFile.exists()) {
                _log.error((Object)("Public LAR file " + this.publicLARFile + " does not exist"));
                this.publicLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using public LAR file " + publicLARFileName));
            }
        }
    }

    protected void initUserPersonalSitePermissions(Group group) throws PortalException {
        Role role = this.roleLocalService.getRole(group.getCompanyId(), "User");
        this.setRolePermissions(group, role, Layout.class.getName(), new String[]{"VIEW"});
        role = this.roleLocalService.getRole(group.getCompanyId(), "Power User");
        this.setRolePermissions(group, role, Group.class.getName(), new String[]{"MANAGE_LAYOUTS", "VIEW_SITE_ADMINISTRATION"});
    }

    protected boolean isCompanyGroup(HttpPrincipal httpPrincipal, Group group) {
        ClassName className = ClassNameServiceHttp.fetchByClassNameId(httpPrincipal, group.getClassNameId());
        return Objects.equals(className.getValue(), Company.class.getName());
    }

    protected boolean isParentGroup(long parentGroupId, long groupId) throws PortalException {
        if (groupId == 0L) {
            return false;
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        String treePath = group.getTreePath();
        return treePath.contains("/" + parentGroupId + "/");
    }

    protected boolean isStaging(ServiceContext serviceContext) {
        if (serviceContext != null) {
            return ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"staging");
        }
        return false;
    }

    protected boolean isUseComplexSQL(long[] classNameIds) {
        if (ArrayUtil.isEmpty((long[])classNameIds)) {
            return true;
        }
        if (this._complexSQLClassNameIds == null) {
            String[] complexSQLClassNames = PropsValues.GROUPS_COMPLEX_SQL_CLASS_NAMES;
            long[] complexSQLClassNameIds = new long[complexSQLClassNames.length];
            for (int i = 0; i < complexSQLClassNames.length; ++i) {
                String complexSQLClassName = complexSQLClassNames[i];
                complexSQLClassNameIds[i] = this.classNameLocalService.getClassNameId(complexSQLClassName);
            }
            this._complexSQLClassNameIds = complexSQLClassNameIds;
        }
        for (long classNameId : classNameIds) {
            if (!ArrayUtil.contains((long[])this._complexSQLClassNameIds, (long)classNameId)) continue;
            return true;
        }
        return false;
    }

    protected boolean matches(String s, String[] keywords) {
        if (keywords == null || keywords.length == 1 && keywords[0] == null) {
            return true;
        }
        for (String keyword : keywords) {
            if (!StringUtil.wildcardMatches((String)s, (String)keyword, (char)'_', (char)'%', (char)'\\', (boolean)false)) continue;
            return true;
        }
        return false;
    }

    protected void reindex(long companyId, long[] userIds) throws PortalException {
        _reindexerBridge.reindex(companyId, User.class.getName(), userIds);
    }

    protected void reindexUsersInOrganization(long organizationId) throws PortalException {
        Organization organization = this.organizationLocalService.getOrganization(organizationId);
        long[] userIds = this.organizationLocalService.getUserPrimaryKeys(organizationId);
        if (ArrayUtil.isNotEmpty((long[])userIds)) {
            long companyId = organization.getCompanyId();
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this.reindex(companyId, userIds);
                return null;
            });
        }
    }

    protected void reindexUsersInUserGroup(long userGroupId) throws PortalException {
        UserGroup userGroup = this.userGroupLocalService.getUserGroup(userGroupId);
        long[] userIds = this.organizationLocalService.getUserPrimaryKeys(userGroupId);
        if (ArrayUtil.isNotEmpty((long[])userIds)) {
            long companyId = userGroup.getCompanyId();
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this.reindex(companyId, userIds);
                return null;
            });
        }
    }

    protected void setCompanyPermissions(Role role, String name, String[] actionIds) throws PortalException {
        this.resourcePermissionLocalService.setResourcePermissions(role.getCompanyId(), name, 1, String.valueOf(role.getCompanyId()), role.getRoleId(), actionIds);
    }

    protected void setRolePermissions(Group group, Role role, String name) throws PortalException {
        List actions = ResourceActionsUtil.getModelResourceActions((String)name);
        this.setRolePermissions(group, role, name, actions.toArray(new String[0]));
    }

    protected void setRolePermissions(Group group, Role role, String name, String[] actionIds) throws PortalException {
        this.resourcePermissionLocalService.setResourcePermissions(group.getCompanyId(), name, 2, String.valueOf(group.getGroupId()), role.getRoleId(), actionIds);
    }

    protected List<Group> sort(Collection<Group> groups, int start, int end, OrderByComparator<Group> orderByComparator) {
        if (orderByComparator == null) {
            orderByComparator = new GroupNameComparator(true);
        }
        ArrayList<Group> groupList = null;
        groupList = groups instanceof List ? (ArrayList<Group>)groups : new ArrayList<Group>(groups);
        Collections.sort(groupList, orderByComparator);
        return Collections.unmodifiableList(ListUtil.subList(groupList, (int)start, (int)end));
    }

    protected void unscheduleStaging(Group group) {
        try {
            String groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_remote_publisher", (long)group.getGroupId());
            SchedulerEngineHelperUtil.delete((String)groupName, (StorageType)StorageType.PERSISTED);
            long liveGroupId = 0L;
            long stagingGroupId = 0L;
            if (group.isStagingGroup()) {
                liveGroupId = group.getLiveGroupId();
                stagingGroupId = group.getGroupId();
            } else if (group.hasStagingGroup()) {
                liveGroupId = group.getGroupId();
                Group stagingGroup = group.getStagingGroup();
                stagingGroupId = stagingGroup.getGroupId();
            }
            if (liveGroupId != 0L && stagingGroupId != 0L) {
                groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_local_publisher", (long)liveGroupId);
                SchedulerEngineHelperUtil.delete((String)groupName, (StorageType)StorageType.PERSISTED);
                groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_local_publisher", (long)stagingGroupId);
                SchedulerEngineHelperUtil.delete((String)groupName, (StorageType)StorageType.PERSISTED);
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to unschedule events for group: " + group.getGroupId()), (Throwable)exception);
        }
    }

    protected void validateFriendlyURL(long companyId, long groupId, long classNameId, long classPK, String friendlyURL) throws PortalException {
        long groupClassNameId;
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (company.isSystem()) {
            return;
        }
        if (Validator.isNull((String)friendlyURL)) {
            return;
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new GroupFriendlyURLException(exceptionType);
        }
        Group group = this.groupPersistence.fetchByC_F(companyId, friendlyURL);
        if (group != null && group.getGroupId() != groupId) {
            GroupFriendlyURLException groupFriendlyURLException = new GroupFriendlyURLException(6);
            groupFriendlyURLException.setDuplicateClassPK(group.getGroupId());
            groupFriendlyURLException.setDuplicateClassName(Group.class.getName());
            throw groupFriendlyURLException;
        }
        String groupIdFriendlyURL = friendlyURL.substring(1);
        if (Validator.isNumber((String)groupIdFriendlyURL) && (classNameId != (groupClassNameId = this.classNameLocalService.getClassNameId(Group.class)) && !groupIdFriendlyURL.equals(String.valueOf(classPK)) && !PropsValues.USERS_SCREEN_NAME_ALLOW_NUMERIC || classNameId == groupClassNameId)) {
            GroupFriendlyURLException groupFriendlyURLException = new GroupFriendlyURLException(8);
            groupFriendlyURLException.setKeywordConflict(groupIdFriendlyURL);
            throw groupFriendlyURLException;
        }
        if (StringUtil.count((String)friendlyURL, (char)'/') > 1) {
            throw new GroupFriendlyURLException(9);
        }
        if (StringUtil.endsWith((String)friendlyURL, (char)'-')) {
            throw new GroupFriendlyURLException(11);
        }
        if (StringUtil.equals((String)friendlyURL, (String)"/.") || StringUtil.equals((String)friendlyURL, (String)"/..")) {
            throw new GroupFriendlyURLException(5);
        }
    }

    protected void validateGroupKey(long groupId, long companyId, String groupKey, int type, boolean site) throws PortalException {
        block9: {
            block8: {
                int groupKeyMaxLength = ModelHintsUtil.getMaxLength((String)Group.class.getName(), (String)"groupKey");
                if (Validator.isNull((String)groupKey) || Validator.isNumber((String)groupKey) || groupKey.contains("*") || groupKey.contains(ORGANIZATION_NAME_SUFFIX) || groupKey.length() > groupKeyMaxLength) {
                    throw new GroupKeyException();
                }
                try {
                    Group group = this.groupFinder.findByC_GK(companyId, groupKey);
                    if (groupId <= 0L || group.getGroupId() != groupId) {
                        throw new DuplicateGroupException("{groupId=" + groupId + "}");
                    }
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    if (!_log.isDebugEnabled()) break block8;
                    _log.debug((Object)noSuchGroupException, (Throwable)noSuchGroupException);
                }
            }
            if (site || type == 5) {
                try {
                    Company company = this.companyLocalService.getCompany(companyId);
                    if (groupKey.equals(company.getName())) {
                        throw new DuplicateGroupException();
                    }
                }
                catch (NoSuchCompanyException noSuchCompanyException) {
                    if (!_log.isDebugEnabled()) break block9;
                    _log.debug((Object)noSuchCompanyException, (Throwable)noSuchCompanyException);
                }
            }
        }
    }

    protected void validateInheritContent(long parentGroupId, boolean inheritContent) throws GroupInheritContentException {
        if (!inheritContent) {
            return;
        }
        if (parentGroupId == 0L) {
            throw new GroupInheritContentException();
        }
        Group parentGroup = this.groupPersistence.fetchByPrimaryKey(parentGroupId);
        if (parentGroup.isInheritContent()) {
            throw new GroupInheritContentException();
        }
    }

    protected void validateLanguageIds(String defaultLanguageId, String languageIds) throws PortalException {
        Object[] languageIdsArray;
        for (String string : languageIdsArray = StringUtil.split((String)languageIds)) {
            if (LanguageUtil.isAvailableLocale((Locale)LocaleUtil.fromLanguageId((String)string))) continue;
            LocaleException localeException = new LocaleException(1);
            localeException.setSourceAvailableLocales((Collection)LanguageUtil.getAvailableLocales());
            localeException.setTargetAvailableLocales(Arrays.asList(LocaleUtil.fromLanguageIds((String[])languageIdsArray)));
            throw localeException;
        }
        if (!ArrayUtil.contains((Object[])languageIdsArray, (Object)defaultLanguageId)) {
            LocaleException localeException = new LocaleException(4);
            localeException.setSourceAvailableLocales((Collection)LanguageUtil.getAvailableLocales());
            localeException.setTargetAvailableLocales(Arrays.asList(LocaleUtil.fromLanguageIds((String[])languageIdsArray)));
            throw localeException;
        }
    }

    protected void validateParentGroup(long groupId, long parentGroupId) throws PortalException {
        Group parentGroup;
        Group stagingGroup;
        long stagingGroupId;
        if (parentGroupId == 0L) {
            return;
        }
        if (groupId == parentGroupId) {
            throw new GroupParentException.MustNotBeOwnParent(groupId);
        }
        Group group = this.groupPersistence.fetchByPrimaryKey(groupId);
        if (group == null) {
            return;
        }
        if (groupId > 0L && parentGroupId != 0L && this.isParentGroup(groupId, parentGroupId)) {
            throw new GroupParentException.MustNotHaveChildParent(groupId, parentGroupId);
        }
        if (group.isStagingGroup() && groupId == (stagingGroupId = (stagingGroup = (parentGroup = this.groupPersistence.findByPrimaryKey(parentGroupId)).getStagingGroup()).getGroupId())) {
            throw new GroupParentException.MustNotHaveStagingParent(groupId, stagingGroupId);
        }
    }

    protected void validateRemoteGroup(long groupId, long remoteGroupId, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection) throws PortalException {
        if (remoteGroupId <= 0L) {
            RemoteOptionsException remoteOptionsException = new RemoteOptionsException(3);
            remoteOptionsException.setRemoteGroupId(remoteGroupId);
            throw remoteOptionsException;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        String remoteURL = StagingURLHelperUtil.buildRemoteURL((String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection);
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            try {
                MethodKey methodKey = new MethodKey(GroupService.class, "checkRemoteStagingGroup", (Class[])_CHECK_REMOTE_STAGING_GROUP_PARAMETER_TYPES);
                MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{remoteGroupId});
                try {
                    TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
                }
                catch (Exception exception) {
                    if (exception instanceof PortalException) {
                        throw (PortalException)((Object)exception);
                    }
                    throw new SystemException((Throwable)exception);
                }
            }
            catch (SystemException systemException) {
                if (systemException.getCause() instanceof ConnectException) {
                    _log.error((Object)("Unable to connect to remote live: " + systemException.getMessage()));
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)systemException, (Throwable)systemException);
                    }
                } else {
                    _log.error((Object)systemException, (Throwable)systemException);
                }
                throw systemException;
            }
            Group group = this.groupLocalService.getGroup(groupId);
            Group remoteGroup = GroupServiceHttp.getGroup(httpPrincipal, remoteGroupId);
            if (group.isCompany() ^ this.isCompanyGroup(httpPrincipal, remoteGroup) || group.isDepot() ^ remoteGroup.isDepot()) {
                RemoteExportException remoteExportException = new RemoteExportException(2);
                remoteExportException.setGroupId(remoteGroupId);
                throw remoteExportException;
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchGroupException, (Throwable)noSuchGroupException);
            }
            RemoteExportException remoteExportException = new RemoteExportException(3);
            remoteExportException.setGroupId(remoteGroupId);
            throw remoteExportException;
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            RemoteExportException remoteExportException = new RemoteExportException(5);
            remoteExportException.setGroupId(remoteGroupId);
            throw remoteExportException;
        }
        catch (RemoteAuthException remoteAuthException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)remoteAuthException, (Throwable)remoteAuthException);
            }
            remoteAuthException.setURL(remoteURL);
            throw remoteAuthException;
        }
        catch (SystemException systemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)systemException, (Throwable)systemException);
            }
            RemoteExportException remoteExportException = new RemoteExportException(1, systemException.getMessage());
            remoteExportException.setURL(remoteURL);
            throw remoteExportException;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    private Map<Locale, String> _normalizeNameMap(Map<Locale, String> nameMap) {
        HashMap<Locale, String> normalizedNameMap = new HashMap<Locale, String>();
        for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
            String value = entry.getValue();
            if (!Validator.isNotNull((String)value)) continue;
            normalizedNameMap.put(entry.getKey(), StringUtil.trim((String)value));
        }
        return normalizedNameMap;
    }

    private void _validateGroupKeyChange(long groupId, String typeSettings) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (!Objects.equals(group.getClassName(), Group.class.getName()) && !group.isDepot()) {
            return;
        }
        UnicodeProperties typeSettingsUnicodeProperties = new UnicodeProperties(true);
        typeSettingsUnicodeProperties.fastLoad(typeSettings);
        String defaultLanguageId = typeSettingsUnicodeProperties.getProperty("languageId", LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        Map nameMap = group.getNameMap();
        if (nameMap != null && Validator.isNotNull((String)((String)nameMap.get(defaultLocale))) && group.getCompanyId() > 0L) {
            this.validateGroupKey(group.getGroupId(), group.getCompanyId(), (String)nameMap.get(defaultLocale), group.getType(), group.isSite());
        }
    }
}

