/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredLayoutSetPrototypeException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.service.base.LayoutSetPrototypeLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutSetPrototypeLocalServiceImpl
extends LayoutSetPrototypeLocalServiceBaseImpl {
    public LayoutSetPrototype addLayoutSetPrototype(long userId, long companyId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, boolean readyForPropagation, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long layoutSetPrototypeId = this.counterLocalService.increment();
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.create(layoutSetPrototypeId);
        layoutSetPrototype.setUuid(serviceContext.getUuid());
        layoutSetPrototype.setCompanyId(companyId);
        layoutSetPrototype.setUserId(userId);
        layoutSetPrototype.setUserName(user.getFullName());
        layoutSetPrototype.setCreateDate(serviceContext.getCreateDate(now));
        layoutSetPrototype.setModifiedDate(serviceContext.getModifiedDate(now));
        layoutSetPrototype.setNameMap(nameMap);
        layoutSetPrototype.setDescriptionMap(descriptionMap);
        layoutSetPrototype.setActive(active);
        UnicodeProperties settingsUnicodeProperties = layoutSetPrototype.getSettingsProperties();
        settingsUnicodeProperties.put("layoutsUpdateable", String.valueOf(layoutsUpdateable));
        settingsUnicodeProperties.put("readyForPropagation", String.valueOf(readyForPropagation));
        layoutSetPrototype.setSettingsProperties(settingsUnicodeProperties);
        layoutSetPrototype = (LayoutSetPrototype)this.layoutSetPrototypePersistence.update((BaseModel)layoutSetPrototype);
        this.resourceLocalService.addResources(companyId, 0L, userId, LayoutSetPrototype.class.getName(), layoutSetPrototype.getLayoutSetPrototypeId(), false, true, false);
        String friendlyURL = "/template-" + layoutSetPrototype.getLayoutSetPrototypeId();
        this.groupLocalService.addGroup(userId, 0L, LayoutSetPrototype.class.getName(), layoutSetPrototype.getLayoutSetPrototypeId(), 0L, layoutSetPrototype.getNameMap(), null, 0, true, 0, friendlyURL, false, true, serviceContext);
        return layoutSetPrototype;
    }

    public LayoutSetPrototype addLayoutSetPrototype(long userId, long companyId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutSetPrototype(userId, companyId, nameMap, descriptionMap, active, layoutsUpdateable, true, serviceContext);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public LayoutSetPrototype deleteLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype) throws PortalException {
        long count;
        if (!CompanyThreadLocal.isDeleteInProcess() && (count = (long)this.layoutSetPersistence.countByC_L(layoutSetPrototype.getCompanyId(), layoutSetPrototype.getUuid())) > 0L) {
            throw new RequiredLayoutSetPrototypeException();
        }
        this.groupLocalService.deleteGroup(layoutSetPrototype.getGroup());
        this.resourceLocalService.deleteResource(layoutSetPrototype.getCompanyId(), LayoutSetPrototype.class.getName(), 4, layoutSetPrototype.getLayoutSetPrototypeId());
        this.layoutSetPrototypePersistence.remove((BaseModel)layoutSetPrototype);
        return layoutSetPrototype;
    }

    @Override
    public LayoutSetPrototype deleteLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(layoutSetPrototypeId);
        return this.deleteLayoutSetPrototype(layoutSetPrototype);
    }

    public void deleteLayoutSetPrototypes() throws PortalException {
        List layoutSetPrototypes = this.layoutSetPrototypePersistence.findAll();
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            this.layoutSetPrototypeLocalService.deleteLayoutSetPrototype(layoutSetPrototype);
        }
    }

    public void deleteNondefaultLayoutSetPrototypes(long companyId) throws PortalException {
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        List layoutSetPrototypes = this.layoutSetPrototypePersistence.findByCompanyId(companyId);
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            if (layoutSetPrototype.getUserId() == defaultUserId) continue;
            this.deleteLayoutSetPrototype(layoutSetPrototype);
        }
    }

    public List<LayoutSetPrototype> getLayoutSetPrototypes(long companyId) {
        return this.layoutSetPrototypePersistence.findByCompanyId(companyId);
    }

    public List<LayoutSetPrototype> search(long companyId, Boolean active, int start, int end, OrderByComparator<LayoutSetPrototype> orderByComparator) {
        if (active != null) {
            return this.layoutSetPrototypePersistence.findByC_A(companyId, active.booleanValue(), start, end, orderByComparator);
        }
        return this.layoutSetPrototypePersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int searchCount(long companyId, Boolean active) {
        if (active != null) {
            return this.layoutSetPrototypePersistence.countByC_A(companyId, active.booleanValue());
        }
        return this.layoutSetPrototypePersistence.countByCompanyId(companyId);
    }

    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, boolean readyForPropagation, ServiceContext serviceContext) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(layoutSetPrototypeId);
        layoutSetPrototype.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutSetPrototype.setNameMap(nameMap);
        layoutSetPrototype.setDescriptionMap(descriptionMap);
        layoutSetPrototype.setActive(active);
        UnicodeProperties settingsUnicodeProperties = layoutSetPrototype.getSettingsProperties();
        settingsUnicodeProperties.put("layoutsUpdateable", String.valueOf(layoutsUpdateable));
        settingsUnicodeProperties.put("readyForPropagation", String.valueOf(readyForPropagation));
        layoutSetPrototype.setSettingsProperties(settingsUnicodeProperties);
        return (LayoutSetPrototype)this.layoutSetPrototypePersistence.update((BaseModel)layoutSetPrototype);
    }

    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException {
        return this.updateLayoutSetPrototype(layoutSetPrototypeId, nameMap, descriptionMap, active, layoutsUpdateable, true, serviceContext);
    }

    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, String settings) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(layoutSetPrototypeId);
        layoutSetPrototype.setModifiedDate(new Date());
        layoutSetPrototype.setSettings(settings);
        layoutSetPrototype = (LayoutSetPrototype)this.layoutSetPrototypePersistence.update((BaseModel)layoutSetPrototype);
        UnicodeProperties settingsUnicodeProperties = layoutSetPrototype.getSettingsProperties();
        if (!settingsUnicodeProperties.containsKey((Object)"customJspServletContextName")) {
            return layoutSetPrototype;
        }
        Group group = this.groupLocalService.getLayoutSetPrototypeGroup(layoutSetPrototype.getCompanyId(), layoutSetPrototypeId);
        UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
        typeSettingsUnicodeProperties.setProperty("customJspServletContextName", settingsUnicodeProperties.getProperty("customJspServletContextName"));
        group.setTypeSettings(typeSettingsUnicodeProperties.toString());
        this.groupPersistence.update((BaseModel)group);
        return layoutSetPrototype;
    }
}

