/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupGroupRoleTable;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.model.Users_UserGroupsTable;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.service.base.UserGroupRoleLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;

public class UserGroupRoleLocalServiceImpl
extends UserGroupRoleLocalServiceBaseImpl {
    public UserGroupRole addUserGroupRole(long userId, long groupId, long roleId) {
        UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByU_G_R(userId, groupId, roleId);
        if (userGroupRole == null) {
            userGroupRole = this.userGroupRolePersistence.create(this.counterLocalService.increment(UserGroupRole.class.getName()));
            userGroupRole.setUserId(userId);
            userGroupRole.setGroupId(groupId);
            userGroupRole.setRoleId(roleId);
            userGroupRole = (UserGroupRole)this.userGroupRolePersistence.update((BaseModel)userGroupRole);
        }
        return userGroupRole;
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public UserGroupRole addUserGroupRole(UserGroupRole userGroupRole) {
        if (userGroupRole.getUserGroupRoleId() == 0L) {
            userGroupRole.setUserGroupRoleId(this.counterLocalService.increment(UserGroupRole.class.getName()));
        }
        userGroupRole.setNew(true);
        return (UserGroupRole)this.userGroupRolePersistence.update((BaseModel)userGroupRole);
    }

    public List<UserGroupRole> addUserGroupRoles(long userId, long groupId, long[] roleIds) {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        for (long roleId : roleIds) {
            UserGroupRole userGroupRole = this.addUserGroupRole(userId, groupId, roleId);
            userGroupRoles.add(userGroupRole);
        }
        Group group = this.groupPersistence.fetchByPrimaryKey(groupId);
        if (group.isRegularSite()) {
            this.groupPersistence.addUser(groupId, userId);
        }
        return userGroupRoles;
    }

    public List<UserGroupRole> addUserGroupRoles(long[] userIds, long groupId, long roleId) {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        for (long userId : userIds) {
            UserGroupRole userGroupRole = this.addUserGroupRole(userId, groupId, roleId);
            userGroupRoles.add(userGroupRole);
        }
        Group group = this.groupPersistence.fetchByPrimaryKey(groupId);
        if (group.isRegularSite()) {
            this.groupPersistence.addUsers(groupId, userIds);
        }
        return userGroupRoles;
    }

    public void deleteUserGroupRoles(long groupId, int roleType) {
        List userGroupRoles = this.userGroupRoleFinder.findByGroupRoleType(groupId, roleType);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            this.userGroupRolePersistence.removeByG_R(groupId, userGroupRole.getRoleId());
        }
    }

    public void deleteUserGroupRoles(long userId, long groupId, long[] roleIds) {
        for (long roleId : roleIds) {
            UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByU_G_R(userId, groupId, roleId);
            if (userGroupRole == null) continue;
            this.userGroupRolePersistence.remove((BaseModel)userGroupRole);
        }
    }

    public void deleteUserGroupRoles(long userId, long[] groupIds) {
        for (long groupId : groupIds) {
            this.userGroupRolePersistence.removeByU_G(userId, groupId);
        }
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId) {
        for (long userId : userIds) {
            this.userGroupRolePersistence.removeByU_G(userId, groupId);
        }
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId, int roleType) {
        List roles = this.rolePersistence.findByT_S(roleType, "");
        for (long userId : userIds) {
            for (Role role : roles) {
                UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByU_G_R(userId, groupId, role.getRoleId());
                if (userGroupRole == null) continue;
                this.userGroupRolePersistence.remove((BaseModel)userGroupRole);
            }
        }
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId, long roleId) {
        for (long userId : userIds) {
            UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByU_G_R(userId, groupId, roleId);
            if (userGroupRole == null) continue;
            this.userGroupRolePersistence.remove((BaseModel)userGroupRole);
        }
    }

    public void deleteUserGroupRolesByGroupId(long groupId) {
        this.userGroupRolePersistence.removeByGroupId(groupId);
    }

    public void deleteUserGroupRolesByRoleId(long roleId) {
        this.userGroupRolePersistence.removeByRoleId(roleId);
    }

    public void deleteUserGroupRolesByUserId(long userId) {
        this.userGroupRolePersistence.removeByUserId(userId);
    }

    public UserGroupRole fetchUserGroupRole(long userId, long groupId, long roleId) {
        return this.userGroupRolePersistence.fetchByU_G_R(userId, groupId, roleId);
    }

    public List<UserGroupRole> getUserGroupRoles(long userId) {
        return this.userGroupRolePersistence.findByUserId(userId);
    }

    public List<UserGroupRole> getUserGroupRoles(long userId, long groupId) {
        return this.userGroupRolePersistence.findByU_G(userId, groupId);
    }

    public List<UserGroupRole> getUserGroupRoles(long userId, long groupId, int start, int end) {
        return this.userGroupRolePersistence.findByU_G(userId, groupId, start, end);
    }

    public List<UserGroupRole> getUserGroupRolesByGroup(long groupId) {
        return this.userGroupRolePersistence.findByGroupId(groupId);
    }

    public List<UserGroupRole> getUserGroupRolesByGroupAndRole(long groupId, long roleId) {
        return this.userGroupRolePersistence.findByG_R(groupId, roleId);
    }

    public List<UserGroupRole> getUserGroupRolesByUserUserGroupAndGroup(long userId, long groupId) {
        return this.userGroupRoleFinder.findByUserUserGroupGroupRole(userId, groupId);
    }

    public int getUserGroupRolesCount(long userId, long groupId) {
        return this.userGroupRolePersistence.countByU_G(userId, groupId);
    }

    public boolean hasUserGroupRole(long userId, long groupId, long roleId) {
        return this.hasUserGroupRole(userId, groupId, roleId, false);
    }

    public boolean hasUserGroupRole(long userId, long groupId, long roleId, boolean inherit) {
        int count = this.userGroupRolePersistence.countByU_G_R(userId, groupId, roleId);
        if (count > 0) {
            return true;
        }
        return inherit && (count = this.rolePersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)RoleTable.INSTANCE).innerJoinON((Table)UserGroupGroupRoleTable.INSTANCE, UserGroupGroupRoleTable.INSTANCE.roleId.eq((Expression)RoleTable.INSTANCE.roleId)).innerJoinON((Table)Users_UserGroupsTable.INSTANCE, Users_UserGroupsTable.INSTANCE.userGroupId.eq((Expression)UserGroupGroupRoleTable.INSTANCE.userGroupId)).where(RoleTable.INSTANCE.roleId.eq((Object)roleId).and((Expression)UserGroupGroupRoleTable.INSTANCE.groupId.eq((Object)groupId)).and((Expression)Users_UserGroupsTable.INSTANCE.userId.eq((Object)userId))))) > 0;
    }

    public boolean hasUserGroupRole(long userId, long groupId, String roleName) throws PortalException {
        return this.hasUserGroupRole(userId, groupId, roleName, false);
    }

    public boolean hasUserGroupRole(long userId, long groupId, String roleName, boolean inherit) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Role role = this.rolePersistence.fetchByC_N(user.getCompanyId(), roleName);
        if (role == null) {
            return false;
        }
        return this.hasUserGroupRole(userId, groupId, role.getRoleId(), inherit);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public UserGroupRole updateUserGroupRole(UserGroupRole userGroupRole) {
        if (userGroupRole.getUserGroupRoleId() == 0L) {
            userGroupRole.setUserGroupRoleId(this.counterLocalService.increment(UserGroupRole.class.getName()));
        }
        return (UserGroupRole)this.userGroupRolePersistence.update((BaseModel)userGroupRole);
    }
}

