/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.AccountLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.AccountPermission;

public class AccountPermissionImpl
implements AccountPermission {
    public void check(PermissionChecker permissionChecker, Account account, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, account, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Account.class.getName(), account.getAccountId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long accountId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Account.class.getName(), accountId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, Account account, String actionId) {
        return permissionChecker.hasPermission(null, Account.class.getName(), account.getAccountId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long accountId, String actionId) throws PortalException {
        return this.contains(permissionChecker, AccountLocalServiceUtil.getAccount((long)accountId), actionId);
    }
}

