/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.PortletPreferenceValueTable;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletPreferencesTable;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.persistence.PortletPreferencesFinder;
import com.liferay.portal.kernel.service.persistence.PortletPreferencesUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.impl.PortletPreferencesImpl;
import com.liferay.portal.service.persistence.impl.PortletPreferencesFinderBaseImpl;
import com.liferay.portal.service.persistence.impl.PortletPreferencesPersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PortletPreferencesFinderImpl
extends PortletPreferencesFinderBaseImpl
implements PortletPreferencesFinder {
    public static final String FIND_BY_PORTLET_ID = PortletPreferencesFinder.class.getName() + ".findByPortletId";
    public static final String FIND_BY_C_G_O_O_P_P = PortletPreferencesFinder.class.getName() + ".findByC_G_O_O_P_P";
    public static final FinderPath FINDER_PATH_FIND_BY_C_G_O_O_P_P = new FinderPath(PortletPreferencesPersistenceImpl.FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_G_O_O_P_P", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName(), String.class.getName(), Boolean.class.getName()}, new String[]{"ownerId", "ownerType", "portletId"}, true);

    public long countByO_O_P(long ownerId, int ownerType, String portletId, boolean excludeDefaultPreferences) {
        return this.countByO_O_P_P_P(ownerId, ownerType, -1L, portletId, excludeDefaultPreferences);
    }

    public long countByO_O_P_P_P(long ownerId, int ownerType, long plid, String portletId, boolean excludeDefaultPreferences) {
        Session session = null;
        try {
            session = this.openSession();
            JoinStep joinStep = DSLQueryFactoryUtil.count().from((Table)PortletPreferencesTable.INSTANCE);
            if (excludeDefaultPreferences) {
                joinStep = joinStep.innerJoinON((Table)PortletPreferenceValueTable.INSTANCE, PortletPreferenceValueTable.INSTANCE.portletPreferencesId.eq((Expression)PortletPreferencesTable.INSTANCE.portletPreferencesId));
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery((DSLQuery)joinStep.where(() -> {
                Predicate predicate = PortletPreferencesTable.INSTANCE.ownerType.eq((Object)ownerType);
                if (ownerId != -1L) {
                    predicate = predicate.and((Expression)PortletPreferencesTable.INSTANCE.ownerId.eq((Object)ownerId));
                }
                predicate = plid == -1L ? predicate.and((Expression)PortletPreferencesTable.INSTANCE.portletId.eq((Object)portletId).or((Expression)PortletPreferencesTable.INSTANCE.portletId.like(portletId.concat("%_INSTANCE_%"))).withParentheses()) : predicate.and((Expression)PortletPreferencesTable.INSTANCE.portletId.eq((Object)portletId).and((Expression)PortletPreferencesTable.INSTANCE.plid.eq((Object)plid)));
                return predicate;
            }));
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            int count = 0;
            Iterator iterator = sqlQuery.iterate();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                if (l == null) continue;
                count += l.intValue();
            }
            long l = count;
            return l;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Deprecated
    public Map<Serializable, PortletPreferences> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        return PortletPreferencesUtil.fetchByPrimaryKeys(primaryKeys);
    }

    public List<PortletPreferences> findByPortletId(String portletId) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_PORTLET_ID);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("PortletPreferences", PortletPreferencesImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(portletId);
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<PortletPreferences> findByC_G_O_O_P_P(long companyId, long groupId, long ownerId, int ownerType, String portletId, boolean privateLayout) {
        Object[] finderArgs = new Object[]{companyId, groupId, ownerId, ownerType, portletId, privateLayout};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_C_G_O_O_P_P, (Object[])finderArgs);
        if (list != null && !list.isEmpty()) {
            for (PortletPreferences portletPreferences : list) {
                if (ownerId == portletPreferences.getOwnerId() && ownerType == portletPreferences.getOwnerType() && this.isInstanceOf(portletPreferences.getPortletId(), portletId)) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                String sql = CustomSQLUtil.get((String)FIND_BY_C_G_O_O_P_P);
                SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
                sqlQuery.addEntity("PortletPreferences", PortletPreferencesImpl.class);
                QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
                queryPos.add(companyId);
                queryPos.add(groupId);
                queryPos.add(ownerId);
                queryPos.add(ownerType);
                queryPos.add(portletId);
                queryPos.add(portletId.concat("_INSTANCE_%"));
                queryPos.add(privateLayout);
                list = sqlQuery.list(true);
                PortletPreferencesUtil.cacheResult((List)list);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_C_G_O_O_P_P, (Object[])finderArgs, (Object)list);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    protected boolean isInstanceOf(String portletPreferencesPortletId, String portletId) {
        if ((portletPreferencesPortletId = GetterUtil.getString((String)portletPreferencesPortletId)).equals(portletId = GetterUtil.getString((String)portletId))) {
            return true;
        }
        String portletName = PortletIdCodec.decodePortletName((String)portletPreferencesPortletId);
        return Objects.equals(portletName, portletId);
    }
}

