/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchTicketException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.TicketTable;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.TicketPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.TicketImpl;
import com.liferay.portal.model.impl.TicketModelImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TicketPersistenceImpl
extends BasePersistenceImpl<Ticket>
implements TicketPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = TicketImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByKey;
    private FinderPath _finderPathCountByKey;
    private static final String _FINDER_COLUMN_KEY_KEY_2 = "ticket.key = ?";
    private static final String _FINDER_COLUMN_KEY_KEY_3 = "(ticket.key IS NULL OR ticket.key = '')";
    private FinderPath _finderPathWithPaginationFindByC_C_T;
    private FinderPath _finderPathWithoutPaginationFindByC_C_T;
    private FinderPath _finderPathCountByC_C_T;
    private static final String _FINDER_COLUMN_C_C_T_CLASSNAMEID_2 = "ticket.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_T_CLASSPK_2 = "ticket.classPK = ? AND ";
    private static final String _FINDER_COLUMN_C_C_T_TYPE_2 = "ticket.type = ?";
    private FinderPath _finderPathWithPaginationFindByC_C_C_T;
    private FinderPath _finderPathWithoutPaginationFindByC_C_C_T;
    private FinderPath _finderPathCountByC_C_C_T;
    private static final String _FINDER_COLUMN_C_C_C_T_COMPANYID_2 = "ticket.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_T_CLASSNAMEID_2 = "ticket.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_T_CLASSPK_2 = "ticket.classPK = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_T_TYPE_2 = "ticket.type = ?";
    private static final String _SQL_SELECT_TICKET = "SELECT ticket FROM Ticket ticket";
    private static final String _SQL_SELECT_TICKET_WHERE = "SELECT ticket FROM Ticket ticket WHERE ";
    private static final String _SQL_COUNT_TICKET = "SELECT COUNT(ticket) FROM Ticket ticket";
    private static final String _SQL_COUNT_TICKET_WHERE = "SELECT COUNT(ticket) FROM Ticket ticket WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ticket.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Ticket exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Ticket exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(TicketPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"key", "type"});
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public Ticket findByKey(String key) throws NoSuchTicketException {
        Ticket ticket = this.fetchByKey(key);
        if (ticket == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("key=");
            sb.append(key);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchTicketException(sb.toString());
        }
        return ticket;
    }

    public Ticket fetchByKey(String key) {
        return this.fetchByKey(key, true);
    }

    public Ticket fetchByKey(String key, boolean useFinderCache) {
        Ticket ticket;
        key = Objects.toString(key, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{key};
        }
        Object result = null;
        if (useFinderCache) {
            result = FinderCacheUtil.getResult((FinderPath)this._finderPathFetchByKey, (Object[])finderArgs);
        }
        if (result instanceof Ticket && !Objects.equals(key, (ticket = (Ticket)result).getKey())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_TICKET_WHERE);
            boolean bindKey = false;
            if (key.isEmpty()) {
                sb.append(_FINDER_COLUMN_KEY_KEY_3);
            } else {
                bindKey = true;
                sb.append(_FINDER_COLUMN_KEY_KEY_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindKey) {
                    queryPos.add(key);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByKey, (Object[])finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{key};
                            }
                            _log.warn((Object)("TicketPersistenceImpl.fetchByKey(String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    Ticket ticket2 = (Ticket)list.get(0);
                    result = ticket2;
                    this.cacheResult(ticket2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Ticket)result;
    }

    public Ticket removeByKey(String key) throws NoSuchTicketException {
        Ticket ticket = this.findByKey(key);
        return (Ticket)this.remove((BaseModel)ticket);
    }

    public int countByKey(String key) {
        key = Objects.toString(key, "");
        FinderPath finderPath = this._finderPathCountByKey;
        Object[] finderArgs = new Object[]{key};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_TICKET_WHERE);
            boolean bindKey = false;
            if (key.isEmpty()) {
                sb.append(_FINDER_COLUMN_KEY_KEY_3);
            } else {
                bindKey = true;
                sb.append(_FINDER_COLUMN_KEY_KEY_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindKey) {
                    queryPos.add(key);
                }
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Ticket> findByC_C_T(long classNameId, long classPK, int type) {
        return this.findByC_C_T(classNameId, classPK, type, -1, -1, null);
    }

    public List<Ticket> findByC_C_T(long classNameId, long classPK, int type, int start, int end) {
        return this.findByC_C_T(classNameId, classPK, type, start, end, null);
    }

    public List<Ticket> findByC_C_T(long classNameId, long classPK, int type, int start, int end, OrderByComparator<Ticket> orderByComparator) {
        return this.findByC_C_T(classNameId, classPK, type, start, end, orderByComparator, true);
    }

    public List<Ticket> findByC_C_T(long classNameId, long classPK, int type, int start, int end, OrderByComparator<Ticket> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_C_T;
                finderArgs = new Object[]{classNameId, classPK, type};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_C_T;
            finderArgs = new Object[]{classNameId, classPK, type, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (Ticket ticket : list) {
                if (classNameId == ticket.getClassNameId() && classPK == ticket.getClassPK() && type == ticket.getType()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_TICKET_WHERE);
            sb.append("ticket.classNameId = ? AND ");
            sb.append("ticket.classPK = ? AND ");
            sb.append("ticket.type = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ticket.ticketId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                queryPos.add(type);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Ticket findByC_C_T_First(long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.fetchByC_C_T_First(classNameId, classPK, type, orderByComparator);
        if (ticket != null) {
            return ticket;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append(", type=");
        sb.append(type);
        sb.append("}");
        throw new NoSuchTicketException(sb.toString());
    }

    public Ticket fetchByC_C_T_First(long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) {
        List<Ticket> list = this.findByC_C_T(classNameId, classPK, type, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Ticket findByC_C_T_Last(long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.fetchByC_C_T_Last(classNameId, classPK, type, orderByComparator);
        if (ticket != null) {
            return ticket;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append(", type=");
        sb.append(type);
        sb.append("}");
        throw new NoSuchTicketException(sb.toString());
    }

    public Ticket fetchByC_C_T_Last(long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) {
        int count = this.countByC_C_T(classNameId, classPK, type);
        if (count == 0) {
            return null;
        }
        List<Ticket> list = this.findByC_C_T(classNameId, classPK, type, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Ticket[] findByC_C_T_PrevAndNext(long ticketId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.findByPrimaryKey(ticketId);
        Session session = null;
        try {
            session = this.openSession();
            Ticket[] array = new TicketImpl[]{this.getByC_C_T_PrevAndNext(session, ticket, classNameId, classPK, type, orderByComparator, true), ticket, this.getByC_C_T_PrevAndNext(session, ticket, classNameId, classPK, type, orderByComparator, false)};
            Ticket[] ticketArray = array;
            return ticketArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Ticket getByC_C_T_PrevAndNext(Session session, Ticket ticket, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_TICKET_WHERE);
        sb.append("ticket.classNameId = ? AND ");
        sb.append("ticket.classPK = ? AND ");
        sb.append("ticket.type = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ticket.ticketId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(classNameId);
        queryPos.add(classPK);
        queryPos.add(type);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ticket)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Ticket)list.get(1);
        }
        return null;
    }

    public void removeByC_C_T(long classNameId, long classPK, int type) {
        for (Ticket ticket : this.findByC_C_T(classNameId, classPK, type, -1, -1, null)) {
            this.remove((BaseModel)ticket);
        }
    }

    public int countByC_C_T(long classNameId, long classPK, int type) {
        FinderPath finderPath = this._finderPathCountByC_C_T;
        Object[] finderArgs = new Object[]{classNameId, classPK, type};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_TICKET_WHERE);
            sb.append("ticket.classNameId = ? AND ");
            sb.append("ticket.classPK = ? AND ");
            sb.append("ticket.type = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                queryPos.add(type);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Ticket> findByC_C_C_T(long companyId, long classNameId, long classPK, int type) {
        return this.findByC_C_C_T(companyId, classNameId, classPK, type, -1, -1, null);
    }

    public List<Ticket> findByC_C_C_T(long companyId, long classNameId, long classPK, int type, int start, int end) {
        return this.findByC_C_C_T(companyId, classNameId, classPK, type, start, end, null);
    }

    public List<Ticket> findByC_C_C_T(long companyId, long classNameId, long classPK, int type, int start, int end, OrderByComparator<Ticket> orderByComparator) {
        return this.findByC_C_C_T(companyId, classNameId, classPK, type, start, end, orderByComparator, true);
    }

    public List<Ticket> findByC_C_C_T(long companyId, long classNameId, long classPK, int type, int start, int end, OrderByComparator<Ticket> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_C_C_T;
                finderArgs = new Object[]{companyId, classNameId, classPK, type};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_C_C_T;
            finderArgs = new Object[]{companyId, classNameId, classPK, type, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (Ticket ticket : list) {
                if (companyId == ticket.getCompanyId() && classNameId == ticket.getClassNameId() && classPK == ticket.getClassPK() && type == ticket.getType()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(6);
            sb.append(_SQL_SELECT_TICKET_WHERE);
            sb.append(_FINDER_COLUMN_C_C_C_T_COMPANYID_2);
            sb.append("ticket.classNameId = ? AND ");
            sb.append("ticket.classPK = ? AND ");
            sb.append("ticket.type = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ticket.ticketId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                queryPos.add(type);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Ticket findByC_C_C_T_First(long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.fetchByC_C_C_T_First(companyId, classNameId, classPK, type, orderByComparator);
        if (ticket != null) {
            return ticket;
        }
        StringBundler sb = new StringBundler(10);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append(", type=");
        sb.append(type);
        sb.append("}");
        throw new NoSuchTicketException(sb.toString());
    }

    public Ticket fetchByC_C_C_T_First(long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) {
        List<Ticket> list = this.findByC_C_C_T(companyId, classNameId, classPK, type, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Ticket findByC_C_C_T_Last(long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.fetchByC_C_C_T_Last(companyId, classNameId, classPK, type, orderByComparator);
        if (ticket != null) {
            return ticket;
        }
        StringBundler sb = new StringBundler(10);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append(", type=");
        sb.append(type);
        sb.append("}");
        throw new NoSuchTicketException(sb.toString());
    }

    public Ticket fetchByC_C_C_T_Last(long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) {
        int count = this.countByC_C_C_T(companyId, classNameId, classPK, type);
        if (count == 0) {
            return null;
        }
        List<Ticket> list = this.findByC_C_C_T(companyId, classNameId, classPK, type, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Ticket[] findByC_C_C_T_PrevAndNext(long ticketId, long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.findByPrimaryKey(ticketId);
        Session session = null;
        try {
            session = this.openSession();
            Ticket[] array = new TicketImpl[]{this.getByC_C_C_T_PrevAndNext(session, ticket, companyId, classNameId, classPK, type, orderByComparator, true), ticket, this.getByC_C_C_T_PrevAndNext(session, ticket, companyId, classNameId, classPK, type, orderByComparator, false)};
            Ticket[] ticketArray = array;
            return ticketArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Ticket getByC_C_C_T_PrevAndNext(Session session, Ticket ticket, long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(6);
        sb.append(_SQL_SELECT_TICKET_WHERE);
        sb.append(_FINDER_COLUMN_C_C_C_T_COMPANYID_2);
        sb.append("ticket.classNameId = ? AND ");
        sb.append("ticket.classPK = ? AND ");
        sb.append("ticket.type = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ticket.ticketId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(classNameId);
        queryPos.add(classPK);
        queryPos.add(type);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ticket)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Ticket)list.get(1);
        }
        return null;
    }

    public void removeByC_C_C_T(long companyId, long classNameId, long classPK, int type) {
        for (Ticket ticket : this.findByC_C_C_T(companyId, classNameId, classPK, type, -1, -1, null)) {
            this.remove((BaseModel)ticket);
        }
    }

    public int countByC_C_C_T(long companyId, long classNameId, long classPK, int type) {
        FinderPath finderPath = this._finderPathCountByC_C_C_T;
        Object[] finderArgs = new Object[]{companyId, classNameId, classPK, type};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_COUNT_TICKET_WHERE);
            sb.append(_FINDER_COLUMN_C_C_C_T_COMPANYID_2);
            sb.append("ticket.classNameId = ? AND ");
            sb.append("ticket.classPK = ? AND ");
            sb.append("ticket.type = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                queryPos.add(type);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public TicketPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("key", "key_");
        dbColumnNames.put("type", "type_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(Ticket.class);
        this.setModelImplClass(TicketImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)TicketTable.INSTANCE);
    }

    public void cacheResult(Ticket ticket) {
        EntityCacheUtil.putResult(TicketImpl.class, (Serializable)Long.valueOf(ticket.getPrimaryKey()), (Serializable)ticket);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByKey, (Object[])new Object[]{ticket.getKey()}, (Object)ticket);
    }

    public void cacheResult(List<Ticket> tickets) {
        for (Ticket ticket : tickets) {
            if (EntityCacheUtil.getResult(TicketImpl.class, (Serializable)Long.valueOf(ticket.getPrimaryKey())) != null) continue;
            this.cacheResult(ticket);
        }
    }

    public void clearCache() {
        EntityCacheUtil.clearCache(TicketImpl.class);
        FinderCacheUtil.clearCache(TicketImpl.class);
    }

    public void clearCache(Ticket ticket) {
        EntityCacheUtil.removeResult(TicketImpl.class, (BaseModel)ticket);
    }

    public void clearCache(List<Ticket> tickets) {
        for (Ticket ticket : tickets) {
            EntityCacheUtil.removeResult(TicketImpl.class, (BaseModel)ticket);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        FinderCacheUtil.clearCache(TicketImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            EntityCacheUtil.removeResult(TicketImpl.class, (Serializable)primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(TicketModelImpl ticketModelImpl) {
        Object[] args = new Object[]{ticketModelImpl.getKey()};
        FinderCacheUtil.putResult((FinderPath)this._finderPathCountByKey, (Object[])args, (Object)1L);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByKey, (Object[])args, (Object)((Object)ticketModelImpl));
    }

    public Ticket create(long ticketId) {
        TicketImpl ticket = new TicketImpl();
        ticket.setNew(true);
        ticket.setPrimaryKey(ticketId);
        ticket.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ticket;
    }

    public Ticket remove(long ticketId) throws NoSuchTicketException {
        return this.remove(Long.valueOf(ticketId));
    }

    public Ticket remove(Serializable primaryKey) throws NoSuchTicketException {
        Session session = null;
        try {
            session = this.openSession();
            Ticket ticket = (Ticket)session.get(TicketImpl.class, primaryKey);
            if (ticket == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchTicketException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Ticket ticket2 = (Ticket)this.remove((BaseModel)ticket);
            return ticket2;
        }
        catch (NoSuchTicketException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Ticket removeImpl(Ticket ticket) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ticket)) {
                ticket = (Ticket)session.get(TicketImpl.class, ticket.getPrimaryKeyObj());
            }
            if (ticket != null) {
                session.delete((Object)ticket);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ticket != null) {
            this.clearCache(ticket);
        }
        return ticket;
    }

    public Ticket updateImpl(Ticket ticket) {
        boolean isNew = ticket.isNew();
        if (!(ticket instanceof TicketModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ticket.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ticket);
                throw new IllegalArgumentException("Implement ModelWrapper in ticket proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Ticket implementation " + ticket.getClass());
        }
        TicketModelImpl ticketModelImpl = (TicketModelImpl)ticket;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && ticket.getCreateDate() == null) {
            if (serviceContext == null) {
                ticket.setCreateDate(date);
            } else {
                ticket.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)ticket);
            } else {
                ticket = (Ticket)session.merge((Object)ticket);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        EntityCacheUtil.putResult(TicketImpl.class, (BaseModel)ticketModelImpl, (boolean)false, (boolean)true);
        this.cacheUniqueFindersCache(ticketModelImpl);
        if (isNew) {
            ticket.setNew(false);
        }
        ticket.resetOriginalValues();
        return ticket;
    }

    public Ticket findByPrimaryKey(Serializable primaryKey) throws NoSuchTicketException {
        Ticket ticket = (Ticket)this.fetchByPrimaryKey(primaryKey);
        if (ticket == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchTicketException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ticket;
    }

    public Ticket findByPrimaryKey(long ticketId) throws NoSuchTicketException {
        return this.findByPrimaryKey(Long.valueOf(ticketId));
    }

    public Ticket fetchByPrimaryKey(long ticketId) {
        return (Ticket)this.fetchByPrimaryKey(Long.valueOf(ticketId));
    }

    public List<Ticket> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Ticket> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Ticket> findAll(int start, int end, OrderByComparator<Ticket> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Ticket> findAll(int start, int end, OrderByComparator<Ticket> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_TICKET);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_TICKET;
                sql = sql.concat(" ORDER BY ticket.ticketId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Ticket ticket : this.findAll()) {
            this.remove((BaseModel)ticket);
        }
    }

    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_TICKET);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    protected String getPKDBName() {
        return "ticketId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_TICKET;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return TicketModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Registry registry = RegistryUtil.getRegistry();
        this._argumentsResolverServiceRegistration = registry.registerService(ArgumentsResolver.class, (Object)new TicketModelArgumentsResolver());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathFetchByKey = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByKey", new String[]{String.class.getName()}, new String[]{"key_"}, true);
        this._finderPathCountByKey = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByKey", new String[]{String.class.getName()}, new String[]{"key_"}, false);
        this._finderPathWithPaginationFindByC_C_T = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C_T", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"classNameId", "classPK", "type_"}, true);
        this._finderPathWithoutPaginationFindByC_C_T = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C_T", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName()}, new String[]{"classNameId", "classPK", "type_"}, true);
        this._finderPathCountByC_C_T = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_T", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName()}, new String[]{"classNameId", "classPK", "type_"}, false);
        this._finderPathWithPaginationFindByC_C_C_T = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C_C_T", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "classNameId", "classPK", "type_"}, true);
        this._finderPathWithoutPaginationFindByC_C_C_T = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C_C_T", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName()}, new String[]{"companyId", "classNameId", "classPK", "type_"}, true);
        this._finderPathCountByC_C_C_T = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_C_T", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName()}, new String[]{"companyId", "classNameId", "classPK", "type_"}, false);
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)TicketImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    protected FinderCache getFinderCache() {
        return FinderCacheUtil.getFinderCache();
    }

    private static class TicketModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache;
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private TicketModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            TicketModelImpl ticketModelImpl = (TicketModelImpl)baseModel;
            long columnBitmask = ticketModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return TicketModelArgumentsResolver._getValue(ticketModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | TicketModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return TicketModelArgumentsResolver._getValue(ticketModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return TicketImpl.class.getName();
        }

        public String getTableName() {
            return TicketTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(TicketModelImpl ticketModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? ticketModelImpl.getColumnOriginalValue(columnName) : ticketModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask;
            _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask = 0L;
        }
    }
}

