/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetvibesServlet
extends HttpServlet {
    private static final String _NETVIBES_CSS = "http://www.netvibes.com/themes/uwa/style.css";
    private static final String _NETVIBES_JS = "http://www.netvibes.com/js/UWA/load.js.php?env=Standalone";
    private static final Log _log = LogFactoryUtil.getLog(NetvibesServlet.class);

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String content = this.getContent(httpServletRequest);
            if (content == null) {
                PortalUtil.sendError((int)404, (Exception)((Object)new NoSuchLayoutException()), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            } else {
                httpServletRequest.setAttribute("NETVIBES", (Object)Boolean.TRUE);
                httpServletResponse.setContentType("text/html");
                ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)content);
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            PortalUtil.sendError((int)500, (Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
    }

    protected String getContent(HttpServletRequest httpServletRequest) throws Exception {
        String path = GetterUtil.getString((String)httpServletRequest.getPathInfo());
        if (Validator.isNull((String)path)) {
            return null;
        }
        int pos = path.indexOf("/-/");
        if (pos == -1) {
            return null;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest);
        String portletId = path.substring(pos + "/-/".length());
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        String title = HtmlUtil.escape((String)portlet.getDisplayName());
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest);
        String iconURL = portalURL + PortalUtil.getPathContext() + portlet.getIcon();
        String widgetURL = String.valueOf(httpServletRequest.getRequestURL());
        widgetURL = widgetURL.replaceFirst(PropsValues.NETVIBES_SERVLET_MAPPING, PropsValues.WIDGET_SERVLET_MAPPING);
        widgetURL = HtmlUtil.escapeJS((String)widgetURL);
        StringBundler sb = new StringBundler(26);
        sb.append("<!DOCTYPE html>");
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<link href=\"");
        sb.append(_NETVIBES_CSS);
        sb.append("\" rel=\"stylesheet\" type=\"text/css\" ");
        sb.append("/>");
        sb.append("<script src=\"");
        sb.append(_NETVIBES_JS);
        sb.append("\" ");
        sb.append("type=\"text/javascript\"></script>");
        sb.append("<title>");
        sb.append(title);
        sb.append("</title>");
        sb.append("<link href=\"");
        sb.append(iconURL);
        sb.append("\" rel=\"icon\" type=\"image/png\" ");
        sb.append("/>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<iframe frameborder=\"0\" height=\"100%\" src=\"");
        sb.append(widgetURL);
        sb.append("\" width=\"100%\">");
        sb.append("</iframe>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }
}

