/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.autologin;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AutoLoginFilter
extends BasePortalFilter {
    private static final String _PATH_CHAT_LATEST = "/-/chat/latest";
    private static final Log _log = LogFactoryUtil.getLog(AutoLoginFilter.class);
    private static final ServiceTrackerList<AutoLogin> _autoLogins = ServiceTrackerCollections.openList(AutoLogin.class, (ServiceTrackerCustomizer)new AutoLoginServiceTrackerCustomizer());

    protected String getLoginRemoteUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpSession session, String[] credentials) throws Exception {
        if (credentials == null || credentials.length != 3) {
            return null;
        }
        String jUserName = credentials[0];
        String jPassword = credentials[1];
        if (Validator.isNull((String)jUserName) || Validator.isNull((String)jPassword)) {
            return null;
        }
        long userId = GetterUtil.getLong((String)jUserName);
        if (userId <= 0L) {
            return null;
        }
        User user = UserLocalServiceUtil.fetchUserById((long)userId);
        if (user == null || user.isLockout()) {
            return null;
        }
        if (!PropsValues.AUTH_SIMULTANEOUS_LOGINS) {
            AuthenticatedSessionManagerUtil.signOutSimultaneousLogins((long)userId);
        }
        if (PropsValues.SESSION_ENABLE_PHISHING_PROTECTION) {
            session = AuthenticatedSessionManagerUtil.renewSession((HttpServletRequest)httpServletRequest, (HttpSession)session);
        }
        session.setAttribute("j_username", (Object)jUserName);
        if (GetterUtil.getBoolean((String)credentials[2])) {
            session.setAttribute("j_password", (Object)jPassword);
        } else {
            session.setAttribute("j_password", (Object)PasswordEncryptorUtil.encrypt((String)jPassword, (String)user.getPassword()));
            if (PropsValues.SESSION_STORE_PASSWORD) {
                session.setAttribute("USER_PASSWORD", (Object)jPassword);
            }
        }
        session.setAttribute("j_remoteuser", (Object)jUserName);
        if (PropsValues.PORTAL_JAAS_ENABLE) {
            String mainPath = PortalUtil.getPathMain();
            String redirect = mainPath.concat("/portal/protected");
            if (PropsValues.AUTH_FORWARD_BY_LAST_PATH) {
                redirect = redirect.concat("?redirect=");
                String autoLoginRedirect = (String)httpServletRequest.getAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE");
                if (Validator.isNull((String)autoLoginRedirect)) {
                    autoLoginRedirect = PortalUtil.getCurrentCompleteURL((HttpServletRequest)httpServletRequest);
                }
                redirect = redirect.concat(URLCodec.encodeURL((String)autoLoginRedirect));
            }
            httpServletResponse.sendRedirect(redirect);
        }
        return jUserName;
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        String host = PortalUtil.getHost((HttpServletRequest)httpServletRequest);
        if (PortalInstances.isAutoLoginIgnoreHost(host)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Ignore host " + host));
            }
            this.processFilter(AutoLoginFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        String contextPath = PortalUtil.getPathContext();
        String path = StringUtil.toLowerCase((String)httpServletRequest.getRequestURI());
        if (!contextPath.equals("/") && path.startsWith(contextPath)) {
            path = path.substring(contextPath.length());
        }
        if (PortalInstances.isAutoLoginIgnorePath(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Ignore path " + path));
            }
            this.processFilter(AutoLoginFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        String remoteUser = httpServletRequest.getRemoteUser();
        HttpSession session = httpServletRequest.getSession();
        String jUserName = (String)session.getAttribute("j_username");
        if (!PropsValues.AUTH_LOGIN_DISABLED && remoteUser == null && jUserName == null) {
            for (AutoLogin autoLogin : _autoLogins) {
                try {
                    String[] credentials = autoLogin.login(httpServletRequest, httpServletResponse);
                    String redirect = (String)httpServletRequest.getAttribute("AUTO_LOGIN_REDIRECT");
                    if (Validator.isNotNull((String)redirect)) {
                        httpServletResponse.sendRedirect(redirect);
                        return;
                    }
                    String loginRemoteUser = this.getLoginRemoteUser(httpServletRequest, httpServletResponse, session, credentials);
                    if (loginRemoteUser == null) continue;
                    httpServletRequest = new ProtectedServletRequest(httpServletRequest, loginRemoteUser);
                    if (PropsValues.PORTAL_JAAS_ENABLE) {
                        return;
                    }
                    redirect = !PropsValues.AUTH_FORWARD_BY_LAST_PATH ? "/c" : (String)httpServletRequest.getAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE");
                    if (!Validator.isNotNull((String)redirect)) continue;
                    httpServletResponse.sendRedirect(redirect);
                    return;
                }
                catch (Exception exception) {
                    StringBundler sb = new StringBundler(6);
                    sb.append("Current URL ");
                    String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)httpServletRequest);
                    sb.append(currentURL);
                    sb.append(" generates exception: ");
                    sb.append(exception.getMessage());
                    if (_log.isInfoEnabled()) {
                        sb.append(" stack: ");
                        sb.append(StackTraceUtil.getStackTrace((Throwable)exception));
                    }
                    if (currentURL.endsWith(_PATH_CHAT_LATEST)) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)sb.toString());
                        continue;
                    }
                    _log.error((Object)sb.toString());
                }
            }
        }
        this.processFilter(AutoLoginFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
    }

    private static class AutoLoginServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AutoLogin, AutoLogin> {
        private AutoLoginServiceTrackerCustomizer() {
        }

        public AutoLogin addingService(ServiceReference<AutoLogin> serviceReference) {
            if (GetterUtil.getBoolean((Object)serviceReference.getProperty("private.auto.login"))) {
                return null;
            }
            Registry registry = RegistryUtil.getRegistry();
            AutoLogin autoLogin = (AutoLogin)registry.getService(serviceReference);
            if (autoLogin == null) {
                return null;
            }
            return autoLogin;
        }

        public void modifiedService(ServiceReference<AutoLogin> serviceReference, AutoLogin autoLogin) {
        }

        public void removedService(ServiceReference<AutoLogin> serviceReference, AutoLogin autoLogin) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            _autoLogins.remove((Object)autoLogin);
        }
    }
}

