/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.dynamiccss;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class DynamicCSSUtil {
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private static final Log _log = LogFactoryUtil.getLog(DynamicCSSUtil.class);
    private static final Pattern _pluginThemePattern = Pattern.compile("\\/([^\\/]+)-theme\\/", 2);
    private static final Pattern _portalThemePattern = Pattern.compile("themes\\/([^\\/]+)\\/css", 2);

    public static String replaceToken(ServletContext servletContext, HttpServletRequest httpServletRequest, String content) throws Exception {
        Theme theme = DynamicCSSUtil._getTheme(httpServletRequest);
        if (theme == null) {
            return content;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return DynamicCSSUtil.replaceToken(servletContext, httpServletRequest, themeDisplay, theme, content);
    }

    public static String replaceToken(ServletContext servletContext, HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, Theme theme, String parsedContent) throws Exception {
        String proxyPath = PortalUtil.getPathProxy();
        String baseURL = proxyPath.concat(servletContext.getContextPath());
        if (baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        return StringUtil.replace((String)parsedContent, (String[])new String[]{"@base_url@", "@portal_ctx@", "@theme_image_path@"}, (String[])new String[]{baseURL, PortalUtil.getPathContext(), DynamicCSSUtil._getThemeImagesPath(httpServletRequest, themeDisplay, theme)});
    }

    protected static String propagateQueryString(String content, String queryString) {
        StringBundler sb = new StringBundler(content.length());
        int pos = 0;
        while (true) {
            int importX = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int importY = content.indexOf(_CSS_IMPORT_END, importX + _CSS_IMPORT_BEGIN.length());
            if (importX == -1 || importY == -1) break;
            sb.append(content.substring(pos, importX));
            sb.append(_CSS_IMPORT_BEGIN);
            String url = content.substring(importX + _CSS_IMPORT_BEGIN.length(), importY);
            char firstChar = url.charAt(0);
            if (firstChar == '\'') {
                sb.append('\'');
            } else if (firstChar == '\"') {
                sb.append('\"');
            }
            url = StringUtil.unquote((String)url);
            sb.append(url);
            if (url.indexOf(63) != -1) {
                sb.append('&');
            } else {
                sb.append('?');
            }
            sb.append(queryString);
            if (firstChar == '\'') {
                sb.append('\'');
            } else if (firstChar == '\"') {
                sb.append('\"');
            }
            sb.append(_CSS_IMPORT_END);
            pos = importY + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos));
        return sb.toString();
    }

    private static Theme _getTheme(HttpServletRequest httpServletRequest) throws Exception {
        String requestURI;
        Matcher portalThemeMatcher;
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest);
        String themeId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"themeId");
        if (Validator.isNotNull((String)themeId)) {
            try {
                return ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
        if ((portalThemeMatcher = _portalThemePattern.matcher(requestURI = URLDecoder.decode(httpServletRequest.getRequestURI(), "UTF-8"))).find()) {
            String themePathId = portalThemeMatcher.group(1);
            themePathId = StringUtil.replace((String)themePathId, (char)'_', (String)"");
            themeId = PortalUtil.getJsSafePortletId((String)themePathId);
        } else {
            Matcher pluginThemeMatcher = _pluginThemePattern.matcher(requestURI);
            if (pluginThemeMatcher.find()) {
                String themePathId = pluginThemeMatcher.group(1);
                themePathId = StringUtil.replace((String)themePathId, (char)'_', (String)"");
                StringBundler sb = new StringBundler(4);
                sb.append(themePathId);
                sb.append("_WAR_");
                sb.append(themePathId);
                sb.append("theme");
                themePathId = sb.toString();
                themeId = PortalUtil.getJsSafePortletId((String)themePathId);
            }
        }
        if (Validator.isNull((String)themeId)) {
            return null;
        }
        try {
            return ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return null;
        }
    }

    private static String _getThemeImagesPath(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, Theme theme) throws Exception {
        String themeImagesPath = null;
        if (themeDisplay != null) {
            themeImagesPath = themeDisplay.getPathThemeImages();
        } else {
            String cdnHost = PortalUtil.getCDNHost((HttpServletRequest)httpServletRequest);
            String themeStaticResourcePath = theme.getStaticResourcePath();
            themeImagesPath = cdnHost + themeStaticResourcePath + theme.getImagesPath();
        }
        return themeImagesPath;
    }
}

