/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.sharepoint.SharepointException;
import com.liferay.portal.sharepoint.SharepointStorage;
import com.liferay.portal.sharepoint.SharepointUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SharepointRequest {
    private byte[] _bytes;
    private final HttpServletRequest _httpServletRequest;
    private final HttpServletResponse _httpServletResponse;
    private final Map<String, String[]> _params = new HashMap<String, String[]>();
    private String _rootPath = "";
    private SharepointStorage _storage;
    private final User _user;

    public SharepointRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, User user) throws SharepointException {
        this(httpServletRequest, httpServletResponse, user, "");
    }

    public SharepointRequest(String rootPath) throws SharepointException {
        this(null, null, null, rootPath);
    }

    public void addParam(String key, String value) {
        this._params.put(key, new String[]{value});
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public long getCompanyId() {
        return this._user.getCompanyId();
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this._httpServletResponse;
    }

    public String getParameterValue(String name) {
        Object[] values = this._params.get(name);
        if (ArrayUtil.isNotEmpty((Object[])values)) {
            return GetterUtil.getString((String)this._params.get(name)[0]);
        }
        return "";
    }

    public String getRootPath() {
        return this._rootPath;
    }

    public SharepointStorage getSharepointStorage() {
        return this._storage;
    }

    public User getUser() {
        return this._user;
    }

    public long getUserId() {
        return this._user.getUserId();
    }

    public void setBytes(byte[] bytes) {
        this._bytes = bytes;
    }

    public void setRootPath(String rootPath) {
        this._rootPath = SharepointUtil.replaceBackSlashes(rootPath);
    }

    public void setSharepointStorage(SharepointStorage storage) {
        this._storage = storage;
    }

    protected void addParams() throws SharepointException {
        String contentType = this._httpServletRequest.getContentType();
        if (!contentType.equals("application/x-vermeer-urlencoded")) {
            return;
        }
        try {
            String[] params;
            ServletInputStream inputStream = this._httpServletRequest.getInputStream();
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream);
            byte[] bytes = unsyncByteArrayOutputStream.toByteArray();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(new ByteArrayInputStream(bytes)));
            String url = unsyncBufferedReader.readLine();
            for (String param : params = url.split("&")) {
                String[] kvp = param.split("=");
                String key = HttpUtil.decodeURL((String)kvp[0]);
                String value = "";
                if (kvp.length > 1) {
                    value = HttpUtil.decodeURL((String)kvp[1]);
                }
                this.addParam(key, value);
            }
            this.setBytes(ArrayUtil.subset((byte[])bytes, (int)(url.length() + 1), (int)bytes.length));
        }
        catch (Exception exception) {
            throw new SharepointException(exception);
        }
    }

    private SharepointRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, User user, String rootPath) throws SharepointException {
        this._httpServletRequest = httpServletRequest;
        this._httpServletResponse = httpServletResponse;
        this._user = user;
        this._rootPath = rootPath;
        this._params.putAll(httpServletRequest.getParameterMap());
        this.addParams();
    }
}

