/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.cache.thread.local.ThreadLocalCacheAdvice;
import com.liferay.portal.dao.jdbc.aop.DynamicDataSourceAdvice;
import com.liferay.portal.increment.BufferedIncrementAdvice;
import com.liferay.portal.internal.cluster.ClusterableAdvice;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.dao.jdbc.aop.DynamicDataSourceTargetSource;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.search.IndexableAdvice;
import com.liferay.portal.security.access.control.AccessControlAdvice;
import com.liferay.portal.service.ServiceContextAdvice;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import com.liferay.portal.spring.aop.RetryAdvice;
import com.liferay.portal.spring.transaction.TransactionHandler;
import com.liferay.portal.systemevent.SystemEventAdvice;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AopCacheManager {
    private static final Comparator<ChainableMethodAdvice> _CHAINABLE_METHOD_ADVICE_COMPARATOR = Comparator.comparing(chainableMethodAdvice -> {
        Class<?> clazz = chainableMethodAdvice.getClass();
        return clazz.getName();
    });
    private static final Set<AopInvocationHandler> _aopInvocationHandlers = new HashSet<AopInvocationHandler>();
    private static final List<ChainableMethodAdvice> _chainableMethodAdvices = AopCacheManager._createStaticChainableMethodAdvices();

    public static synchronized AopInvocationHandler create(Object target, TransactionHandler transactionHandler) {
        AopInvocationHandler aopInvocationHandler = new AopInvocationHandler(target, _chainableMethodAdvices.toArray(new ChainableMethodAdvice[0]), transactionHandler);
        _aopInvocationHandlers.add(aopInvocationHandler);
        return aopInvocationHandler;
    }

    public static synchronized void destroy(AopInvocationHandler aopInvocationHandler) {
        _aopInvocationHandlers.remove(aopInvocationHandler);
    }

    private static List<ChainableMethodAdvice> _createStaticChainableMethodAdvices() {
        DynamicDataSourceTargetSource dynamicDataSourceTargetSource;
        ArrayList<ChainableMethodAdvice> chainableMethodAdvices = new ArrayList<ChainableMethodAdvice>();
        chainableMethodAdvices.add(new AccessControlAdvice());
        chainableMethodAdvices.add(new BufferedIncrementAdvice());
        if (PropsValues.CLUSTER_LINK_ENABLED) {
            chainableMethodAdvices.add(new ClusterableAdvice());
        }
        if ((dynamicDataSourceTargetSource = InfrastructureUtil.getDynamicDataSourceTargetSource()) != null) {
            chainableMethodAdvices.add(new DynamicDataSourceAdvice(dynamicDataSourceTargetSource));
        }
        chainableMethodAdvices.add(new IndexableAdvice());
        chainableMethodAdvices.add(new RetryAdvice());
        chainableMethodAdvices.add(new ServiceContextAdvice());
        chainableMethodAdvices.add(new SystemEventAdvice());
        chainableMethodAdvices.add(new ThreadLocalCacheAdvice());
        chainableMethodAdvices.sort(_CHAINABLE_METHOD_ADVICE_COMPARATOR);
        return chainableMethodAdvices;
    }

    private AopCacheManager() {
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        ServiceTracker serviceTracker = registry.trackServices(ChainableMethodAdvice.class, (ServiceTrackerCustomizer)new ChainableMethodAdviceServiceTrackerCustomizer());
        serviceTracker.open();
    }

    private static class ChainableMethodAdviceServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ChainableMethodAdvice, ChainableMethodAdvice> {
        private ChainableMethodAdviceServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChainableMethodAdvice addingService(ServiceReference<ChainableMethodAdvice> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            ChainableMethodAdvice chainableMethodAdvice = (ChainableMethodAdvice)registry.getService(serviceReference);
            Class<AopCacheManager> clazz = AopCacheManager.class;
            synchronized (AopCacheManager.class) {
                int index = Collections.binarySearch(_chainableMethodAdvices, chainableMethodAdvice, _CHAINABLE_METHOD_ADVICE_COMPARATOR);
                if (index < 0) {
                    index = -index - 1;
                }
                _chainableMethodAdvices.add(index, chainableMethodAdvice);
                this._reset();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return chainableMethodAdvice;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifiedService(ServiceReference<ChainableMethodAdvice> serviceReference, ChainableMethodAdvice chainableMethodAdvice) {
            Class<AopCacheManager> clazz = AopCacheManager.class;
            synchronized (AopCacheManager.class) {
                for (AopInvocationHandler aopInvocationHandler : _aopInvocationHandlers) {
                    aopInvocationHandler.reset();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ChainableMethodAdvice> serviceReference, ChainableMethodAdvice chainableMethodAdvice) {
            Class<AopCacheManager> clazz = AopCacheManager.class;
            synchronized (AopCacheManager.class) {
                _chainableMethodAdvices.remove(chainableMethodAdvice);
                this._reset();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                Registry registry = RegistryUtil.getRegistry();
                registry.ungetService(serviceReference);
                return;
            }
        }

        private void _reset() {
            ChainableMethodAdvice[] chainableMethodAdvices = _chainableMethodAdvices.toArray(new ChainableMethodAdvice[0]);
            for (AopInvocationHandler aopInvocationHandler : _aopInvocationHandlers) {
                aopInvocationHandler.setChainableMethodAdvices(chainableMethodAdvices);
            }
        }
    }
}

