/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import java.util.function.Function;

public class ServiceLocator {
    private static final Log _log = LogFactoryUtil.getLog(ServiceLocator.class);
    private static final ServiceLocator _serviceLocator = new ServiceLocator();

    public static ServiceLocator getInstance() {
        return _serviceLocator;
    }

    public Object findService(String serviceName) {
        Object bean = null;
        try {
            Registry registry = RegistryUtil.getRegistry();
            bean = registry.callService(serviceName, Function.identity());
            if (bean == null) {
                bean = PortalBeanLocatorUtil.locate((String)this._getServiceName(serviceName));
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return bean;
    }

    public Object findService(String servletContextName, String serviceName) {
        Object bean = null;
        try {
            bean = PortletBeanLocatorUtil.locate((String)servletContextName, (String)this._getServiceName(serviceName));
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return bean;
    }

    private ServiceLocator() {
    }

    private String _getServiceName(String serviceName) {
        if (!serviceName.endsWith(".velocity")) {
            serviceName = serviceName + ".velocity";
        }
        return serviceName;
    }
}

