/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.propertiesdoc;

import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.tools.ArgumentsUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PropertiesDocIndexBuilder {
    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            new PropertiesDocIndexBuilder(arguments);
        }
        catch (Exception exception) {
            ArgumentsUtil.processMainException(arguments, exception);
        }
    }

    public PropertiesDocIndexBuilder(Map<String, String> arguments) {
        File[] files;
        String propertiesDirName = GetterUtil.getString((String)arguments.get("properties.dir"));
        File propertiesDir = new File(propertiesDirName);
        if (!propertiesDir.exists()) {
            System.out.println(propertiesDirName + " not found");
            return;
        }
        ArrayList<String> propertiesHTMLFileNames = new ArrayList<String>();
        for (File file : files = propertiesDir.listFiles()) {
            String fileName = file.getName();
            if (!fileName.endsWith(".properties.html")) continue;
            String propertiesHTMLFileName = fileName.substring(0, fileName.length() - 5);
            propertiesHTMLFileNames.add(propertiesHTMLFileName);
        }
        if (propertiesHTMLFileNames.isEmpty()) {
            System.out.println("No properties HTML files found in " + propertiesDirName);
            return;
        }
        HashMap context = HashMapBuilder.put((Object)"propertiesHTMLFileNames", propertiesHTMLFileNames).put((Object)"releaseInfoVersion", (Object)ReleaseInfo.getVersion()).build();
        try {
            String indexHTMLFileName = propertiesDirName + "/index.html";
            File indexHTMLFile = new File(indexHTMLFileName);
            System.out.println("Writing " + indexHTMLFile);
            FileWriter writer = new FileWriter(indexHTMLFile);
            try {
                FreeMarkerUtil.process("com/liferay/portal/tools/propertiesdoc/dependencies/index.ftl", context, writer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ((Writer)writer).flush();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }
}

