/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.DBTypeToSQLMap;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.upgrade.v7_0_0.util.AssetEntryTable;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;

public class UpgradeAsset
extends UpgradeProcess {
    protected void deleteOrphanedAssetEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long classNameId = PortalUtil.getClassNameId((String)DLFileEntryConstants.getClassName());
            StringBundler sb = new StringBundler(5);
            sb.append("delete from AssetEntry where classNameId = ");
            sb.append(classNameId);
            sb.append(" and classPK not in (select fileVersionId from ");
            sb.append("DLFileVersion) and classPK not in (select fileEntryId ");
            sb.append("from DLFileEntry)");
            DBTypeToSQLMap dbTypeToSQLMap = new DBTypeToSQLMap(sb.toString());
            sb = new StringBundler(6);
            sb.append("delete from AssetEntry where classNameId = ");
            sb.append(classNameId);
            sb.append(" and not exists (select null from DLFileVersion where ");
            sb.append("fileVersionId = AssetEntry.classPK) and not exists ");
            sb.append("(select null from DLFileEntry where fileEntryId = ");
            sb.append("AssetEntry.classPK)");
            dbTypeToSQLMap.add(DBType.POSTGRESQL, sb.toString());
            this.runSQL(dbTypeToSQLMap);
        }
    }

    protected void doUpgrade() throws Exception {
        this.alter(AssetEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "description", "TEXT null"), new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "summary", "TEXT null")});
        this.deleteOrphanedAssetEntries();
        this.updateAssetEntries();
        this.updateAssetVocabularies();
    }

    /*
     * Exception decompiling
     */
    protected long getDDMStructureId(String structureKey) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateAssetEntries() throws Exception {
        StringBundler sb = new StringBundler(10);
        sb.append("update AssetEntry set listable = ? where classNameId = ? ");
        sb.append("and classPK in (select JournalArticle.resourcePrimKey as ");
        sb.append("resourcePrimKey from (select ");
        sb.append("JournalArticle.resourcePrimKey as primKey, ");
        sb.append("max(JournalArticle.version) as maxVersion from ");
        sb.append("JournalArticle group by JournalArticle.resourcePrimKey) ");
        sb.append("TEMP_TABLE inner join JournalArticle on ");
        sb.append("(JournalArticle.resourcePrimKey = TEMP_TABLE.primKey and ");
        sb.append("JournalArticle.indexable = ? and JournalArticle.status = ");
        sb.append("0 and JournalArticle.version = TEMP_TABLE.maxVersion))");
        long classNameId = PortalUtil.getClassNameId((String)"com.liferay.journal.model.JournalArticle");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(sb.toString());){
            preparedStatement1.setBoolean(1, false);
            preparedStatement1.setLong(2, classNameId);
            preparedStatement1.setBoolean(3, false);
            preparedStatement1.execute();
        }
    }

    protected void updateAssetVocabularies() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select vocabularyId, settings_ from AssetVocabulary");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update AssetVocabulary set settings_ = ? where vocabularyId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long vocabularyId = resultSet.getLong("vocabularyId");
                String settings = resultSet.getString("settings_");
                preparedStatement2.setString(1, this.upgradeVocabularySettings(settings));
                preparedStatement2.setLong(2, vocabularyId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected String upgradeVocabularySettings(String settings) {
        UnicodeProperties unicodeProperties = new UnicodeProperties(true);
        unicodeProperties.fastLoad(settings);
        AssetVocabularySettingsHelper vocabularySettingsHelper = new AssetVocabularySettingsHelper();
        vocabularySettingsHelper.setMultiValued(GetterUtil.getBoolean((String)unicodeProperties.getProperty("multiValued"), (boolean)true));
        long[] classNameIds = StringUtil.split((String)unicodeProperties.getProperty("selectedClassNameIds"), (long)0L);
        long[] classTypePKs = new long[classNameIds.length];
        Arrays.fill(classTypePKs, -1L);
        long[] requiredClassNameIds = StringUtil.split((String)unicodeProperties.getProperty("requiredClassNameIds"), (long)0L);
        boolean[] requireds = new boolean[classNameIds.length];
        for (int i = 0; i < classNameIds.length; ++i) {
            requireds[i] = ArrayUtil.contains((long[])requiredClassNameIds, (long)classNameIds[i]);
        }
        vocabularySettingsHelper.setClassNameIdsAndClassTypePKs(classNameIds, classTypePKs, requireds);
        return vocabularySettingsHelper.toString();
    }
}

