/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PortletPreferenceValue;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

public abstract class UpgradePortletSettings
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradePortletSettings.class);
    private final SettingsFactory _settingsFactory;

    public UpgradePortletSettings(SettingsFactory settingsFactory) {
        this._settingsFactory = settingsFactory;
    }

    protected void copyPortletSettingsAsServiceSettings(String portletId, int ownerType, String serviceName) throws Exception {
        block41: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Copy portlet settings as service settings");
            }
            try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select PortletPreferences.portletPreferencesId, ", "PortletPreferences.ownerId, PortletPreferences.plid, ", "Layout.groupId from PortletPreferences left join ", "Layout on Layout.plid = PortletPreferences.plid ", "where PortletPreferences.ownerType = ", ownerType, " and PortletPreferences.portletId = '", portletId, "'"}));){
                ResultSet resultSet = selectPreparedStatement.executeQuery();
                Throwable throwable = null;
                block29: while (true) {
                    try {
                        while (resultSet.next()) {
                            long oldPortletPreferencesId = resultSet.getLong(1);
                            long ownerId = 0L;
                            long plid = 0L;
                            if (ownerType == 3) {
                                ownerId = resultSet.getLong(3);
                                plid = 0L;
                            } else {
                                ownerId = resultSet.getLong(1);
                                plid = resultSet.getLong(2);
                            }
                            long newPortletPreferencesId = this.increment();
                            try {
                                PreparedStatement insertPreparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into PortletPreferences (mvccVersion, ", "ctCollectionId, portletPreferencesId, ", "ownerId, ownerType, plid, portletId) values ", "(0, 0, ?, ?, ?, ?, ?)"}));
                                Throwable throwable2 = null;
                                try {
                                    insertPreparedStatement.setLong(1, newPortletPreferencesId);
                                    insertPreparedStatement.setLong(2, ownerId);
                                    insertPreparedStatement.setInt(3, 2);
                                    insertPreparedStatement.setLong(4, plid);
                                    insertPreparedStatement.setString(5, serviceName);
                                    insertPreparedStatement.executeUpdate();
                                    this._copyPortletPreferenceValues(oldPortletPreferencesId, newPortletPreferencesId);
                                    continue block29;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (insertPreparedStatement == null) continue block29;
                                    if (throwable2 != null) {
                                        try {
                                            insertPreparedStatement.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue block29;
                                    }
                                    insertPreparedStatement.close();
                                    continue block29;
                                }
                            }
                            catch (SQLException sqlException) {
                                if (!_log.isDebugEnabled()) continue;
                                _log.debug((Object)("Unable to copy portlet preferences " + oldPortletPreferencesId), (Throwable)sqlException);
                            }
                        }
                        break block41;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                finally {
                    if (resultSet != null) {
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
        }
    }

    protected void resetPortletPreferencesValues(String portletId, int ownerType, SettingsDescriptor settingsDescriptor) throws Exception {
        Set allKeys = settingsDescriptor.getAllKeys();
        if (allKeys.isEmpty()) {
            return;
        }
        StringBundler sb = new StringBundler(allKeys.size() + 8);
        sb.append("delete from PortletPreferenceValue where ");
        sb.append("PortletPreferenceValue.portletPreferencesId in (select ");
        sb.append("PortletPreferences.portletPreferencesId from ");
        sb.append("PortletPreferences where PortletPreferences.ownerType = ");
        sb.append(ownerType);
        sb.append(" and PortletPreferences.portletId = '");
        sb.append(portletId);
        sb.append("') and PortletPreferenceValue.name in (?");
        for (int i = 1; i < allKeys.size(); ++i) {
            sb.append(", ?");
        }
        sb.append(")");
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sb.toString());){
            int i = 0;
            for (String key : allKeys) {
                preparedStatement.setString(++i, key);
            }
            preparedStatement.executeUpdate();
        }
    }

    protected void upgradeDisplayPortlet(String portletId, String serviceName, int ownerType) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(portletId);){
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Upgrading display portlet " + portletId + " settings"));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Delete service keys from portlet settings");
            }
            SettingsDescriptor settingsDescriptor = this._settingsFactory.getSettingsDescriptor(serviceName);
            this.resetPortletPreferencesValues(portletId, ownerType, settingsDescriptor);
            this.resetPortletPreferencesValues(portletId, 5, settingsDescriptor);
        }
    }

    protected void upgradeMainPortlet(String portletId, String serviceName, int ownerType, boolean resetPortletInstancePreferences) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(portletId);){
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Upgrading main portlet " + portletId + " settings"));
            }
            this.copyPortletSettingsAsServiceSettings(portletId, ownerType, serviceName);
            if (resetPortletInstancePreferences) {
                SettingsDescriptor portletInstanceSettingsDescriptor = this._settingsFactory.getSettingsDescriptor(portletId);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Delete portlet instance keys from service settings");
                }
                this.resetPortletPreferencesValues(serviceName, 2, portletInstanceSettingsDescriptor);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Delete service keys from portlet settings");
            }
            SettingsDescriptor serviceSettingsDescriptor = this._settingsFactory.getSettingsDescriptor(serviceName);
            this.resetPortletPreferencesValues(portletId, ownerType, serviceSettingsDescriptor);
            this.resetPortletPreferencesValues(portletId, 5, serviceSettingsDescriptor);
        }
    }

    private void _copyPortletPreferenceValues(long oldPortletPreferencesId, long newPortletPreferencesId) throws SQLException {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select portletPreferenceValueId from ", "PortletPreferenceValue where portletPreferencesId = ", "?"}));
             PreparedStatement insertPreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into PortletPreferenceValue (mvccVersion, ", "ctCollectionId, portletPreferenceValueId, ", "companyId, portletPreferencesId, index_, ", "largeValue, name, readOnly, smallValue) select 0 ", "as mvccVersion, 0 as ctCollectionId, ? as ", "portletPreferenceValueId, TEMP_TABLE.companyId, ", "? as portletPreferencesId, TEMP_TABLE.index_, ", "TEMP_TABLE.largeValue, TEMP_TABLE.name, ", "TEMP_TABLE.readOnly, TEMP_TABLE.smallValue from ", "PortletPreferenceValue TEMP_TABLE where ", "TEMP_TABLE.portletPreferenceValueId = ?"})));){
            selectPreparedStatement.setLong(1, oldPortletPreferencesId);
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();){
                while (resultSet.next()) {
                    insertPreparedStatement.setLong(1, this.increment(PortletPreferenceValue.class.getName()));
                    insertPreparedStatement.setLong(2, newPortletPreferencesId);
                    insertPreparedStatement.setLong(3, resultSet.getLong(1));
                    insertPreparedStatement.addBatch();
                }
                insertPreparedStatement.executeBatch();
            }
        }
    }
}

